/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="set-properties", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class SetPropertiesMojo
extends AbstractGitflowBranchMojo {
    @Parameter(property="masterBranchProperties")
    private Properties masterBranchProperties;
    @Parameter(property="masterBranchPropertyFile")
    private File masterBranchPropertyFile;
    @Parameter(property="releaseBranchProperties")
    private Properties releaseBranchProperties;
    @Parameter(property="releaseBranchPropertyFile")
    private File releaseBranchPropertyFile;
    @Parameter(property="hotfixBranchProperties")
    private Properties hotfixBranchProperties;
    @Parameter(property="hotfixBranchPropertyFile")
    private File hotfixBranchPropertyFile;
    @Parameter(property="developmentBranchProperties")
    private Properties developmentBranchProperties;
    @Parameter(property="developmentBranchPropertyFile")
    private File developmentBranchPropertyFile;
    @Parameter(property="otherBranchProperties")
    private Properties otherBranchProperties;
    @Parameter(property="otherBranchPropertyFile")
    private File otherBranchPropertyFile;
    @Parameter(property="undefinedBranchProperties")
    private Properties undefinedBranchProperties;
    @Parameter(property="undefinedBranchPropertyFile")
    private File undefinedBranchPropertyFile;
    @Parameter(property="scope", defaultValue="project")
    private String scope;
    @Parameter(property="resolve", defaultValue="true")
    private boolean resolve;
    @Parameter(property="keyPrefix", defaultValue="")
    private String keyPrefix = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(GitBranchType type, String gitBranch, String branchPattern) throws MojoExecutionException, MojoFailureException {
        Properties toInject = null;
        File toLoad = null;
        switch (type) {
            case MASTER: {
                toInject = this.masterBranchProperties;
                toLoad = this.masterBranchPropertyFile;
                break;
            }
            case RELEASE: {
                toInject = this.releaseBranchProperties;
                toLoad = this.releaseBranchPropertyFile;
                break;
            }
            case HOTFIX: {
                toInject = this.hotfixBranchProperties;
                toLoad = this.hotfixBranchPropertyFile;
                break;
            }
            case DEVELOPMENT: {
                toInject = this.developmentBranchProperties;
                toLoad = this.developmentBranchPropertyFile;
                break;
            }
            case OTHER: {
                toInject = this.otherBranchProperties;
                toLoad = this.otherBranchPropertyFile;
                break;
            }
            case UNDEFINED: {
                toInject = this.undefinedBranchProperties;
                toLoad = this.undefinedBranchPropertyFile;
            }
        }
        this.setProperties(toInject);
        if (toLoad != null) {
            toInject = new Properties();
            FileInputStream fis = null;
            try {
                this.getLog().info((CharSequence)("Loading properties from: " + toLoad.getCanonicalPath()));
                fis = new FileInputStream(toLoad);
                toInject.load(fis);
            }
            catch (IOException ioe) {
                this.getLog().error((CharSequence)("Could not load from : " + toLoad.getAbsolutePath()), (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
            }
            this.setProperties(toInject);
        }
    }

    public void setProperties(Properties toInject) {
        if (toInject == null) {
            return;
        }
        this.getLog().info((CharSequence)("Setting " + toInject.size() + " properties..."));
        Enumeration<?> propertyNames = toInject.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            String key = this.keyPrefix + this.resolveExpression(propertyName);
            String value = this.resolveExpression(toInject.getProperty(propertyName));
            this.getLog().debug((CharSequence)("  " + key + " = " + value));
            Object replaced = "system".equalsIgnoreCase(this.scope) ? System.setProperty(key, value) : this.project.getProperties().setProperty(key, value);
            if (replaced == null) continue;
            this.getLog().debug((CharSequence)("   replaced previous value : " + replaced));
        }
    }
}

