/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="enforce-versions", defaultPhase=LifecyclePhase.VALIDATE)
public class EnforceVersionsMojo
extends AbstractGitflowBranchMojo {
    protected void execute(GitBranchType type, String gitBranch, String branchPattern) throws MojoExecutionException, MojoFailureException {
        if (GitBranchType.VERSIONED_TYPES.contains((Object)type)) {
            this.getLog().debug((CharSequence)("Versioned Branch Type: " + (Object)((Object)type) + " with branchPattern: " + branchPattern + " Checking against current branch: " + gitBranch));
            Matcher gitMatcher = Pattern.compile(branchPattern).matcher(gitBranch);
            if (gitMatcher.matches()) {
                if (ArtifactUtils.isSnapshot((String)this.project.getVersion())) {
                    throw new MojoFailureException("The current git branch: [" + gitBranch + "] is defined as a release branch. The maven project version: [" + this.project.getVersion() + "] is currently a snapshot version.");
                }
                if (gitMatcher.groupCount() >= 1 && !gitMatcher.group(1).trim().equals(this.project.getVersion().trim())) {
                    throw new MojoFailureException("The current git branch: [" + gitBranch + "] expected the maven project version to be: [" + gitMatcher.group(1).trim() + "], but the maven project version is: [" + this.project.getVersion() + "]");
                }
            }
        }
    }
}

