/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.GitBranchType;
import com.e_gineering.maven.gitflowhelper.properties.ExpansionBuffer;
import com.e_gineering.maven.gitflowhelper.properties.PropertyResolver;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractGitflowBranchMojo
extends AbstractMojo {
    private Properties systemEnvVars = new Properties();
    private PropertyResolver resolver = new PropertyResolver();
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="origin/master", property="masterBranchPattern", required=true)
    private String masterBranchPattern;
    @Parameter(defaultValue="origin/release/(.*)", property="releaseBranchPattern", required=true)
    private String releaseBranchPattern;
    @Parameter(defaultValue="origin/hotfix/(.*)", property="hotfixBranchPattern", required=true)
    private String hotfixBranchPattern;
    @Parameter(defaultValue="origin/development", property="developmentBranchPattern", required=true)
    private String developmentBranchPattern;
    @Parameter(property="gitBranchExpression", required=false)
    private String gitBranchExpression;

    protected abstract void execute(GitBranchType var1, String var2, String var3) throws MojoExecutionException, MojoFailureException;

    protected String resolveExpression(String expression) {
        return this.resolver.resolveValue(expression, this.project.getProperties(), this.systemEnvVars);
    }

    private void logExecute(GitBranchType type, String gitBranch, String branchPattern) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Building for GitBranchType: " + type.name() + ". gitBranch: '" + gitBranch + "' branchPattern: '" + branchPattern + "'"));
        this.execute(type, gitBranch, branchPattern);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.gitBranchExpression == null) {
            this.gitBranchExpression = "${env.GIT_BRANCH}";
        }
        try {
            this.systemEnvVars = CommandLineUtils.getSystemEnvVars();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read System Envirionment Variables: ", (Exception)ioe);
        }
        String gitBranch = this.resolveExpression(this.gitBranchExpression);
        ExpansionBuffer eb = new ExpansionBuffer(gitBranch);
        if (!this.gitBranchExpression.equals(gitBranch) || this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved gitBranchExpression: '" + this.gitBranchExpression + " to '" + gitBranch + "'"));
        }
        if (!eb.hasMoreLegalPlaceholders()) {
            if (gitBranch.matches(this.masterBranchPattern)) {
                this.logExecute(GitBranchType.MASTER, gitBranch, this.masterBranchPattern);
            } else if (gitBranch.matches(this.releaseBranchPattern)) {
                this.logExecute(GitBranchType.RELEASE, gitBranch, this.releaseBranchPattern);
            } else if (gitBranch.matches(this.hotfixBranchPattern)) {
                this.logExecute(GitBranchType.HOTFIX, gitBranch, this.hotfixBranchPattern);
            } else if (gitBranch.matches(this.developmentBranchPattern)) {
                this.logExecute(GitBranchType.DEVELOPMENT, gitBranch, this.developmentBranchPattern);
            } else {
                this.logExecute(GitBranchType.OTHER, gitBranch, null);
            }
        } else {
            this.logExecute(GitBranchType.UNDEFINED, gitBranch, null);
        }
    }
}

