/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class PickerView
extends View {
    private int mViewHeight;
    private int mViewWidth;
    public static final float MARGIN_ALPHA = 3.0f;
    public static final float SPEED = 10.0f;
    private boolean isLoop = true;
    private List<String> mDataList;
    private int mCurrentSelectedIndex;
    private float mSelectedTextSize = 40.0f;
    private float mUnSelectedTextSize = 20.0f;
    private float mMaxTextAlpha = 255.0f;
    private float mMinTextAlpha = 96.0f;
    private int mPrimaryTextColor = 0x212121;
    private int mSecondTextColor = 0x757575;
    private float mLastDownY;
    private float mMoveLen = 0.0f;
    private boolean isInit = false;
    private onSelectListener mSelectListener;
    private boolean isScroll = true;
    private Timer timer;
    private MyTimerTask mTask;
    private Paint mSelectedPaint;
    private Paint mUnSelectedPaint;
    @SuppressLint(value={"HandlerLeak"})
    Handler mUpdateHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (Math.abs(PickerView.this.mMoveLen) < 10.0f) {
                PickerView.this.mMoveLen = 0.0f;
                if (PickerView.this.mTask != null) {
                    PickerView.this.mTask.cancel();
                    PickerView.this.mTask = null;
                    PickerView.this.performSelect();
                }
            } else {
                PickerView.this.mMoveLen = PickerView.this.mMoveLen - PickerView.this.mMoveLen / Math.abs(PickerView.this.mMoveLen) * 10.0f;
            }
            PickerView.this.invalidate();
        }
    };

    public PickerView(Context context) {
        this(context, null);
    }

    public PickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.timer = new Timer();
        this.mDataList = new ArrayList<String>();
        this.mSelectedPaint = this.newPaint();
        this.mUnSelectedPaint = this.newPaint();
    }

    private Paint newPaint() {
        Paint paint = new Paint(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextAlign(Paint.Align.CENTER);
        return paint;
    }

    public void setOnSelectListener(onSelectListener listener) {
        this.mSelectListener = listener;
    }

    public void setData(List<String> data) {
        this.mDataList = data;
        this.mCurrentSelectedIndex = data.size() / 4;
        this.invalidate();
    }

    public void setIsLoop(boolean loop) {
        this.isLoop = loop;
    }

    public void setScroll(boolean scroll) {
        this.isScroll = scroll;
    }

    public String getSelected() {
        return this.mDataList.get(this.mCurrentSelectedIndex);
    }

    public void setPrimaryTextColor(int primaryTextColor) {
        this.mPrimaryTextColor = primaryTextColor;
        this.invalidate();
    }

    public void setSecondTextColor(int secondTextColor) {
        this.mSecondTextColor = secondTextColor;
        this.invalidate();
    }

    public void setSelected(int selected) {
        this.mCurrentSelectedIndex = selected;
        if (this.isLoop) {
            int distance = this.mDataList.size() / 2 - this.mCurrentSelectedIndex;
            if (distance < 0) {
                for (int i = 0; i < -distance; ++i) {
                    this.moveHeadToTail();
                    --this.mCurrentSelectedIndex;
                }
            } else if (distance > 0) {
                for (int i = 0; i < distance; ++i) {
                    this.moveTailToHead();
                    ++this.mCurrentSelectedIndex;
                }
            }
        }
        this.invalidate();
    }

    public void setSelected(String selected) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            if (!this.mDataList.get(i).equals(selected)) continue;
            this.setSelected(i);
            break;
        }
    }

    private void moveHeadToTail() {
        if (this.isLoop) {
            String head = this.mDataList.get(0);
            this.mDataList.remove(0);
            this.mDataList.add(head);
        }
    }

    private void moveTailToHead() {
        if (this.isLoop) {
            String tail = this.mDataList.get(this.mDataList.size() - 1);
            this.mDataList.remove(this.mDataList.size() - 1);
            this.mDataList.add(0, tail);
        }
    }

    private void performSelect() {
        if (this.mSelectListener != null) {
            this.mSelectListener.onSelect(this);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mViewHeight = this.getMeasuredHeight();
        this.mViewWidth = this.getMeasuredWidth();
        this.mSelectedTextSize = (float)this.mViewHeight / 8.8f;
        this.mUnSelectedTextSize = this.mSelectedTextSize / 1.8f;
        this.isInit = true;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInit) {
            this.drawData(canvas);
        }
    }

    private void drawData(Canvas canvas) {
        float scale = this.parabola((float)this.mViewHeight / 4.0f, this.mMoveLen);
        float size = (this.mSelectedTextSize - this.mUnSelectedTextSize) * scale + this.mUnSelectedTextSize;
        this.mSelectedPaint.setColor(this.mPrimaryTextColor);
        this.mSelectedPaint.setTextSize(size);
        this.mSelectedPaint.setAlpha((int)((this.mMaxTextAlpha - this.mMinTextAlpha) * scale + this.mMinTextAlpha));
        float x = (float)((double)this.mViewWidth / 2.0);
        float y = (float)((double)this.mViewHeight / 2.0 + (double)this.mMoveLen);
        Paint.FontMetricsInt fmi = this.mSelectedPaint.getFontMetricsInt();
        float baseline = (float)((double)y - ((double)fmi.bottom / 2.0 + (double)fmi.top / 2.0));
        canvas.drawText(this.mDataList.get(this.mCurrentSelectedIndex), x, baseline, this.mSelectedPaint);
        int i = 1;
        while (this.mCurrentSelectedIndex - i >= 0) {
            this.drawOtherText(canvas, i, -1);
            ++i;
        }
        i = 1;
        while (this.mCurrentSelectedIndex + i < this.mDataList.size()) {
            this.drawOtherText(canvas, i, 1);
            ++i;
        }
    }

    private void drawOtherText(Canvas canvas, int position, int type) {
        float d = 3.0f * this.mUnSelectedTextSize * (float)position + (float)type * this.mMoveLen;
        float scale = this.parabola((float)this.mViewHeight / 4.0f, d);
        float size = (this.mSelectedTextSize - this.mUnSelectedTextSize) * scale + this.mUnSelectedTextSize;
        this.mUnSelectedPaint.setColor(this.mSecondTextColor);
        this.mUnSelectedPaint.setTextSize(size);
        this.mUnSelectedPaint.setAlpha((int)((this.mMaxTextAlpha - this.mMinTextAlpha) * scale + this.mMinTextAlpha));
        float y = (float)((double)this.mViewHeight / 2.0 + (double)((float)type * d));
        Paint.FontMetricsInt fmi = this.mUnSelectedPaint.getFontMetricsInt();
        float baseline = (float)((double)y - ((double)fmi.bottom / 2.0 + (double)fmi.top / 2.0));
        canvas.drawText(this.mDataList.get(this.mCurrentSelectedIndex + type * position), (float)((double)this.mViewWidth / 2.0), baseline, this.mUnSelectedPaint);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.doDown(event);
                break;
            }
            case 2: {
                this.mMoveLen += event.getY() - this.mLastDownY;
                if (this.mMoveLen > 3.0f * this.mUnSelectedTextSize / 2.0f) {
                    if (!this.isLoop && this.mCurrentSelectedIndex == 0) {
                        this.mLastDownY = event.getY();
                        this.invalidate();
                        return true;
                    }
                    if (!this.isLoop) {
                        --this.mCurrentSelectedIndex;
                    }
                    this.moveTailToHead();
                    this.mMoveLen -= 3.0f * this.mUnSelectedTextSize;
                } else if (this.mMoveLen < -3.0f * this.mUnSelectedTextSize / 2.0f) {
                    if (this.mCurrentSelectedIndex == this.mDataList.size() - 1) {
                        this.mLastDownY = event.getY();
                        this.invalidate();
                        return true;
                    }
                    if (!this.isLoop) {
                        ++this.mCurrentSelectedIndex;
                    }
                    this.moveHeadToTail();
                    this.mMoveLen += 3.0f * this.mUnSelectedTextSize;
                }
                this.mLastDownY = event.getY();
                this.invalidate();
                break;
            }
            case 1: {
                this.doUp(event);
            }
        }
        return true;
    }

    private void doDown(MotionEvent event) {
        if (this.mTask != null) {
            this.mTask.cancel();
            this.mTask = null;
        }
        this.mLastDownY = event.getY();
    }

    private void doMove(MotionEvent event) {
        this.mMoveLen += event.getY() - this.mLastDownY;
        if (this.mMoveLen > 3.0f * this.mUnSelectedTextSize / 2.0f) {
            this.moveTailToHead();
            this.mMoveLen -= 3.0f * this.mUnSelectedTextSize;
        } else if (this.mMoveLen < -3.0f * this.mUnSelectedTextSize / 2.0f) {
            this.moveHeadToTail();
            this.mMoveLen += 3.0f * this.mUnSelectedTextSize;
        }
        this.mLastDownY = event.getY();
        this.invalidate();
    }

    private void doUp(MotionEvent event) {
        if ((double)Math.abs(this.mMoveLen) < 1.0E-4) {
            this.mMoveLen = 0.0f;
            return;
        }
        if (this.mTask != null) {
            this.mTask.cancel();
            this.mTask = null;
        }
        this.mTask = new MyTimerTask(this.mUpdateHandler);
        this.timer.schedule((TimerTask)this.mTask, 0L, 10L);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return this.isScroll && super.dispatchTouchEvent(event);
    }

    private float parabola(float zero, float x) {
        float f = (float)(1.0 - Math.pow(x / zero, 2.0));
        return f < 0.0f ? 0.0f : f;
    }

    class MyTimerTask
    extends TimerTask {
        Handler mHandler;

        MyTimerTask(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void run() {
            this.mHandler.sendMessage(this.mHandler.obtainMessage());
        }
    }

    public static interface onSelectListener {
        public void onSelect(PickerView var1);
    }
}

