/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.dzenm.helper.R;

public class GridPhotoLayout
extends ViewGroup {
    private int mChildVerticalSpace;
    private int mChildHorizontalSpace;
    private int mColumnCount = 3;
    private int mChildWidth;
    private int mChildHeight;

    public GridPhotoLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.GridPhotoLayout);
        this.mChildVerticalSpace = attributes.getDimensionPixelSize(R.styleable.GridPhotoLayout_margin_child, 0);
        this.mChildHorizontalSpace = attributes.getDimensionPixelSize(R.styleable.GridPhotoLayout_margin_child, 0);
        this.mColumnCount = attributes.getInt(R.styleable.GridPhotoLayout_columnCount, 3);
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount > 0) {
            this.mChildHeight = this.mChildWidth = (w - (this.mColumnCount - 1) * this.mChildHorizontalSpace) / this.mColumnCount;
            int vw = w;
            if (childCount < this.mColumnCount) {
                vw = childCount * (this.mChildHeight + this.mChildVerticalSpace);
            }
            int rowCount = childCount / this.mColumnCount + (childCount % this.mColumnCount == 0 ? 0 : 1);
            int vh = rowCount * this.mChildHeight + (rowCount > 0 ? rowCount - 1 : 0) * this.mChildVerticalSpace;
            this.setMeasuredDimension(vw, vh);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int left = i % this.mColumnCount * (this.mChildWidth + this.mChildHorizontalSpace);
            int top = i / this.mColumnCount * (this.mChildHeight + this.mChildVerticalSpace);
            child.layout(left, top, left + this.mChildWidth, top + this.mChildHeight);
        }
    }
}

