/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.List;

public class EditTextHelper
implements TextWatcher {
    private View managerView;
    private List<TextView> textViews;
    private static final float TRANSLUCENT = 0.5f;
    private static final float OPAQUE = 1.0f;

    public EditTextHelper(@Nullable View view) {
        if (view == null) {
            throw new IllegalArgumentException("the view is empty");
        }
        this.managerView = view;
    }

    public void addView(TextView ... view) {
        if (this.textViews == null) {
            this.textViews = Arrays.asList(view);
        } else {
            this.textViews.addAll(Arrays.asList(view));
        }
        for (TextView textView : this.textViews) {
            textView.addTextChangedListener((TextWatcher)this);
        }
        this.afterTextChanged(null);
    }

    public void removeView(TextView ... views) {
        if (this.textViews == null) {
            return;
        }
        if (this.textViews.isEmpty()) {
            return;
        }
        for (TextView textView : this.textViews) {
            textView.removeTextChangedListener((TextWatcher)this);
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public synchronized void afterTextChanged(Editable editable) {
        for (TextView textView : this.textViews) {
            if ("".equals(textView.getText().toString())) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private void setEnabled(boolean enabled) {
        this.managerView.setEnabled(enabled);
        this.managerView.setAlpha(enabled ? 1.0f : 0.5f);
    }
}

