/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.dzenm.helper.R;

public class EditText
extends AppCompatEditText
implements View.OnFocusChangeListener,
TextWatcher {
    private Drawable clearDrawable;
    private boolean isCloseDrawable = false;

    public void setShakeAnimation() {
        this.startAnimation(this.shakeAnimation(2));
    }

    public Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }

    public void setCloseDrawable(boolean closeDrawable) {
        this.isCloseDrawable = closeDrawable;
        this.setClearIconVisible(false);
    }

    public EditText(Context context) {
        this(context, null);
    }

    public EditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public EditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.clearDrawable = this.getCompoundDrawables()[2];
        if (this.clearDrawable == null) {
            this.clearDrawable = new BitmapDrawable(null, this.createBitmap(R.drawable.ic_delete, context));
        }
        this.clearDrawable.setBounds(0, 0, this.clearDrawable.getIntrinsicWidth(), this.clearDrawable.getIntrinsicHeight());
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.getCompoundDrawables()[2] != null && event.getAction() == 1) {
            boolean touchAble;
            boolean bl = touchAble = event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.clearDrawable.getIntrinsicWidth()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchAble) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    protected void setClearIconVisible(boolean visible) {
        Drawable right = !this.isCloseDrawable ? (visible ? this.clearDrawable : null) : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.setClearIconVisible(s.length() > 0);
    }

    public void afterTextChanged(Editable editable) {
    }

    private Bitmap createBitmap(int resources, Context context) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resources);
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)this.getCurrentHintTextColor());
        return this.drawableToBitamp(wrappedDrawable);
    }

    private Bitmap drawableToBitamp(Drawable drawable2) {
        int w = drawable2.getIntrinsicWidth();
        int h = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w, h);
        drawable2.draw(canvas);
        return bitmap;
    }
}

