/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.toast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.dzenm.helper.R;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;

public class ToastHelper {
    @SuppressLint(value={"StaticFieldLeak"})
    private static ToastHelper sToast;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Prompt sPrompt;
    private static boolean isShowRepeat;
    private static Drawable sBackground;
    private static Drawable sCustomizeBackground;
    private static int sGravity;
    private static int sCustomizeGravity;
    private static int sOffset;
    private static int sCustomizeOffset;
    private static boolean isCustomize;

    private ToastHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToastHelper getInstance() {
        if (sToast != null) return sToast;
        Class<ToastHelper> clazz = ToastHelper.class;
        synchronized (ToastHelper.class) {
            if (sToast != null) return sToast;
            sToast = new ToastHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sToast;
        }
    }

    public ToastHelper init(Context context) {
        sContext = context;
        return this;
    }

    public static ToastHelper customize() {
        isCustomize = true;
        return sToast;
    }

    public ToastHelper setBackground(Drawable background) {
        if (isCustomize) {
            sCustomizeBackground = background;
        } else {
            sBackground = background;
        }
        return sToast;
    }

    public ToastHelper setGravity(int gravity, int offset) {
        if (isCustomize) {
            sCustomizeGravity = gravity;
            sCustomizeOffset = offset;
        } else {
            sGravity = gravity;
            sOffset = offset;
        }
        return sToast;
    }

    public ToastHelper setOnce(boolean once) {
        isShowRepeat = !once;
        return sToast;
    }

    public static void show(int resId) {
        ToastHelper.show(sContext.getString(resId));
    }

    public static void show(CharSequence text) {
        ToastHelper.show(text, 0, 0, -1);
    }

    public static void show(CharSequence text, int resId) {
        ToastHelper.show(text, resId, 0);
    }

    public static void show(CharSequence text, int resId, int duration) {
        ToastHelper.show(text, resId, duration, 1);
    }

    public static void show(CharSequence text, int resId, int duration, int showImage) {
        if (isShowRepeat) {
            if (sPrompt != null) {
                sPrompt.cancel();
            }
            sPrompt = new Prompt(sContext);
        } else if (sPrompt == null) {
            sPrompt = new Prompt(sContext);
        }
        if (isCustomize) {
            if (sCustomizeBackground != null) {
                ToastHelper.sPrompt.setBackground(ToastHelper.sCustomizeBackground);
            }
        } else if (sBackground != null) {
            ToastHelper.sPrompt.setBackground(ToastHelper.sBackground);
        }
        if (isCustomize) {
            if (sCustomizeGravity != 0) {
                ToastHelper.sPrompt.setGravity(ToastHelper.sCustomizeGravity, ToastHelper.sCustomizeOffset);
            }
        } else if (sGravity != 0) {
            ToastHelper.sPrompt.setGravity(ToastHelper.sGravity, ToastHelper.sOffset);
        }
        if (isCustomize) {
            sCustomizeBackground = null;
            sCustomizeGravity = 0;
            sCustomizeOffset = 0;
            isCustomize = false;
        }
        ToastHelper.sPrompt.showToast(text, resId, duration, showImage);
    }

    static {
        isShowRepeat = true;
        isCustomize = false;
    }

    private static class Prompt
    extends Toast {
        private static final int TYPE_HIDE = -1;
        private static final int TYPE_SHOW = 1;
        private ImageView mImageView;
        private TextView mTextView;
        private LinearLayout mLinearLayout;
        private Drawable mBackground = DrawableHelper.solid(R.color.colorTranslucentDarkGray).radius(16.0f).build();

        private Prompt(Context context) {
            super(context);
        }

        private Prompt setBackground(Drawable background) {
            this.mBackground = background;
            return this;
        }

        private Prompt setGravity(int gravity, int offset) {
            sPrompt.setGravity(gravity, offset, 0);
            return this;
        }

        private Prompt showToast(CharSequence text, int resId, int duration, int showImage) {
            sPrompt.setView(this.initView(sContext));
            sPrompt.setDuration(duration);
            this.mTextView.setText(text);
            this.mLinearLayout.setBackground(this.mBackground);
            if (showImage == -1) {
                this.mImageView.setVisibility(8);
            } else if (showImage == 1) {
                this.mImageView.setImageResource(resId);
                Drawable drawable2 = this.mImageView.getDrawable();
                if (!(drawable2 instanceof VectorDrawable)) {
                    ((Animatable)drawable2).start();
                }
            }
            sPrompt.show();
            return this;
        }

        private View initView(Context context) {
            LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-1, -2);
            this.mTextView = new TextView(context);
            this.mTextView.setTextColor(context.getResources().getColor(17170443));
            this.mTextView.setLayoutParams((ViewGroup.LayoutParams)textParams);
            int size = OsHelper.dp2px(16.0f);
            LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams(size, size);
            imgParams.setMargins(0, 0, OsHelper.dp2px(8.0f), 0);
            this.mImageView = new ImageView(context);
            this.mImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imgParams);
            this.mLinearLayout = new LinearLayout(context);
            this.mLinearLayout.setGravity(17);
            int paddingVertical = OsHelper.dp2px(12.0f);
            int paddingHorizontal = OsHelper.dp2px(16.0f);
            this.mLinearLayout.setPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
            this.mLinearLayout.setOrientation(0);
            this.mLinearLayout.addView((View)this.mImageView);
            this.mLinearLayout.addView((View)this.mTextView);
            return this.mLinearLayout;
        }
    }
}

