/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.popup;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.dzenm.helper.dialog.ViewHolder;
import com.dzenm.helper.popup.PopupHelper;

class PopupController {
    private Activity mActivity;
    private PopupHelper mPopupWindow;

    PopupController(Activity activity, PopupHelper popupWindow) {
        this.mActivity = activity;
        this.mPopupWindow = popupWindow;
    }

    void setView(View view) {
        this.mPopupWindow.setContentView(view);
    }

    void setAnimationStyle(int animationStyle) {
        this.mPopupWindow.setAnimationStyle(animationStyle);
    }

    void setOutsideTouchable(boolean touchable) {
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.mPopupWindow.setOutsideTouchable(touchable);
        this.mPopupWindow.setFocusable(touchable);
    }

    void setBackground(Drawable background) {
        this.mPopupWindow.getContentView().setBackground(background);
    }

    void setElevation(int elevation) {
        this.mPopupWindow.setElevation(elevation);
    }

    PopupHelper getPopupWindow() {
        return this.mPopupWindow;
    }

    void setParentBackgroundAlpha(float alpha) {
        Window window = this.mActivity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.alpha = alpha;
        window.setAttributes(layoutParams);
    }

    @SuppressLint(value={"NewApi"})
    void create() {
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setIgnoreCheekPress();
        this.mPopupWindow.setAttachedInDecor(false);
        this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                PopupController.this.setParentBackgroundAlpha(1.0f);
            }
        });
        this.mPopupWindow.getContentView().measure(0, 0);
    }

    static class Params {
        public Activity mActivity;
        public View mPopupView;
        public int mAnimationStyle;
        public int mElevation;
        public float parentBackgroundAlpha;
        public Drawable mBackground;
        public boolean mTouchable;
        public PopupHelper.OnViewHolderCallback mOnViewHolderCallback;

        public Params(Activity activity) {
            this.mActivity = activity;
        }

        @SuppressLint(value={"NewApi"})
        void apply(PopupController controller) {
            if (this.mPopupView == null) {
                throw new NullPointerException("PopupWindow's view is null");
            }
            controller.setView(this.mPopupView);
            controller.setParentBackgroundAlpha(this.parentBackgroundAlpha);
            controller.setBackground(this.mBackground);
            controller.setAnimationStyle(this.mAnimationStyle);
            controller.setElevation(this.mElevation);
            controller.setOutsideTouchable(this.mTouchable);
            this.mOnViewHolderCallback.onCallback(ViewHolder.create(this.mPopupView), controller.getPopupWindow());
            controller.create();
        }
    }
}

