/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.photo;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import com.dzenm.helper.file.FileHelper;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;

public class PhotoHelper {
    private final String TAG = PhotoHelper.class.getSimpleName() + "|";
    @SuppressLint(value={"FieldLeak"})
    private static volatile PhotoHelper sPhotoHelper;
    private Activity mActivity;
    private Uri mGraphUri;
    private Uri mCropUri;
    private int mAspectX = 1;
    private int mAspectY = 1;
    private int mOutputWidth = 800;
    private int mOutputHeight = 800;
    private OnSelectPhotoListener mOnSelectPhotoListener;

    private PhotoHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoHelper getInstance() {
        if (sPhotoHelper != null) return sPhotoHelper;
        Class<PhotoHelper> clazz = PhotoHelper.class;
        synchronized (PhotoHelper.class) {
            if (sPhotoHelper != null) return sPhotoHelper;
            sPhotoHelper = new PhotoHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sPhotoHelper;
        }
    }

    public PhotoHelper with(Activity activity) {
        this.mActivity = activity;
        this.mOutputHeight = 0;
        this.mOutputWidth = 0;
        this.mAspectY = 0;
        this.mAspectX = 0;
        return this;
    }

    public PhotoHelper ratio(int x, int y) {
        this.mAspectX = x;
        this.mAspectY = y;
        return this;
    }

    public PhotoHelper size(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
        return this;
    }

    public PhotoHelper setOnSelectPhotoListener(OnSelectPhotoListener onSelectPhotoListener) {
        this.mOnSelectPhotoListener = onSelectPhotoListener;
        return this;
    }

    public void camera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File file = this.createTempFile("/photo");
        if (file == null) {
            return;
        }
        if (intent.resolveActivity(this.mActivity.getPackageManager()) != null) {
            this.mGraphUri = FileHelper.getInstance().getUri(file);
            intent.addFlags(64);
            intent.putExtra("output", (Parcelable)this.mGraphUri);
            this.mActivity.startActivityForResult(intent, 1);
        } else {
            this.mOnSelectPhotoListener.onError("\u6253\u5f00\u76f8\u673a\u5931\u8d25");
        }
    }

    public void gallery() {
        Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
        this.mActivity.startActivityForResult(intent, 2);
    }

    public void crop(Uri uri) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        if (OsHelper.isNougat()) {
            intent.setDataAndType(uri, "image/*");
            intent.addFlags(3);
        } else {
            intent.setDataAndType(uri, "image/*");
        }
        intent.putExtra("scale", true);
        intent.putExtra("circleCrop", true);
        intent.putExtra("crop", true);
        intent.putExtra("aspectX", this.mAspectX);
        intent.putExtra("aspectY", this.mAspectY);
        intent.putExtra("outputX", this.mOutputWidth);
        intent.putExtra("outputY", this.mOutputHeight);
        intent.putExtra("noFaceDetection", true);
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent.putExtra("return-data", false);
        this.mCropUri = Uri.fromFile((File)this.createTempFile("/crop"));
        intent.putExtra("output", (Parcelable)this.mCropUri);
        Intent intentBc = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intentBc.setData(this.mCropUri);
        this.mActivity.sendBroadcast(intentBc);
        List resInfoList = this.mActivity.getPackageManager().queryIntentActivities(intent, 65536);
        if (!resInfoList.isEmpty()) {
            for (Object object : resInfoList) {
                ResolveInfo resolveInfo = (ResolveInfo)object;
                String packageName = resolveInfo.activityInfo.packageName;
                this.mActivity.grantUriPermission(packageName, this.mCropUri, 2);
            }
        }
        this.mActivity.startActivityForResult(intent, 3);
    }

    public Bitmap convertToBitmap(Uri imageUri) {
        String[] filePathColumns = new String[]{"_data"};
        Cursor cursor = this.mActivity.getContentResolver().query(imageUri, filePathColumns, null, null, null);
        assert (cursor != null);
        cursor.moveToFirst();
        int columnIndex = cursor.getColumnIndex(filePathColumns[0]);
        String imagePath = cursor.getString(columnIndex);
        cursor.close();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 2;
        int minLen = Math.min(height, width);
        if (minLen > 100) {
            float ratio = (float)minLen / 100.0f;
            inSampleSize = (int)ratio;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = inSampleSize;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    public void onPhotoResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            Logger.d(this.TAG + "\u62cd\u7167\u540e\u7684\u56fe\u7247uri: " + this.mGraphUri);
            if (this.mOnSelectPhotoListener.onGraph(this, this.mGraphUri)) {
                this.crop(this.mGraphUri);
            }
        } else if (requestCode == 2 && resultCode == -1) {
            if (data != null) {
                String path = this.getRealFilePath(data.getData());
                Logger.d(this.TAG + "\u9009\u62e9\u56fe\u5e93\u540e\u7684\u56fe\u7247\u8def\u5f84: " + path);
                if (this.mOnSelectPhotoListener.onGallery(this, path)) {
                    this.crop(FileHelper.getInstance().getUri(new File(path)));
                }
            } else {
                this.mOnSelectPhotoListener.onError("\u56fe\u7247\u4e0d\u5b58\u5728");
            }
        } else if (requestCode == 3 && resultCode == -1) {
            Logger.d(this.TAG + "\u88c1\u526a\u540e\u7684\u56fe\u7247uri: " + this.mCropUri);
            if (this.mOnSelectPhotoListener.onCrop(this, this.mCropUri)) {
                String filePath = this.getRealFilePath(this.mCropUri);
                File file = new File(filePath);
                Logger.d(this.TAG + "\u5220\u9664\u88c1\u526a\u56fe\u7247\u7684\u6587\u4ef6\u8def\u5f84: " + file.getPath());
                FileHelper.getInstance().delete(file.getParent());
            }
        } else if (resultCode == 0) {
            Logger.d(this.TAG + "\u56de\u8c03\u5931\u8d25: " + this.mGraphUri + this.mCropUri);
            this.mCropUri = null;
            this.mGraphUri = null;
            Logger.d(this.TAG + "\u56de\u8c03\u5931\u8d25: " + this.mGraphUri + this.mCropUri);
        }
    }

    private File createTempFile(String folder) {
        File direct = FileHelper.getInstance().getFolder(folder);
        if (!direct.exists()) {
            direct.mkdirs();
        }
        try {
            return File.createTempFile("temp_", ".jpeg", direct);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bitmap convertToBitmap(String path, int w, int h) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        int width = opts.outWidth;
        int height = opts.outHeight;
        float scaleWidth = 0.0f;
        float scaleHeight = 0.0f;
        if (width > w || height > h) {
            scaleWidth = (float)width / (float)w;
            scaleHeight = (float)height / (float)h;
        }
        opts.inJustDecodeBounds = false;
        float scale = Math.max(scaleWidth, scaleHeight);
        opts.inSampleSize = (int)scale;
        WeakReference<Bitmap> weak = new WeakReference<Bitmap>(BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts));
        return Bitmap.createScaledBitmap((Bitmap)((Bitmap)weak.get()), (int)w, (int)h, (boolean)true);
    }

    public Bitmap convertToBitmap(String path) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
    }

    public void deleteUriBitmap(Uri uri) {
        if (uri.toString().startsWith("content://")) {
            this.mActivity.getContentResolver().delete(uri, null, null);
        } else {
            File file = new File(this.getRealFilePath(uri));
            if (file.exists() && file.isFile()) {
                file.delete();
            }
        }
    }

    public String getRealFilePath(Uri uri) {
        return FileHelper.getInstance().getRealFilePath(uri);
    }

    public static interface OnPhotoListener {
        public boolean onGraph(PhotoHelper var1, Uri var2);

        public boolean onGallery(PhotoHelper var1, String var2);

        public boolean onCrop(PhotoHelper var1, Uri var2);

        public void onError(String var1);
    }

    public static abstract class OnSelectPhotoListener
    implements OnPhotoListener {
        @Override
        public boolean onGraph(PhotoHelper helper, Uri uri) {
            return true;
        }

        @Override
        public boolean onGallery(PhotoHelper helper, String filePath) {
            return true;
        }

        @Override
        public boolean onCrop(PhotoHelper helper, Uri uri) {
            return true;
        }

        @Override
        public void onError(String msg) {
        }
    }
}

