/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.permission;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.dzenm.helper.log.Logger;

public final class PermissionSetting {
    public static final String TAG = PermissionSetting.class.getSimpleName() + "|";
    private static final String HUAWEI_PACKAGE = "com.huawei.systemmanager";
    private static final String HUAWEI_UI_PERMISSION = "com.huawei.permissionmanager.ui.MainActivity";
    private static final String HUAWEI_UI_SYSTEM = "com.huawei.systemmanager.addviewmonitor.AddViewMonitorActivity";
    private static final String HUAWEI_UI_NOTIFICATION = "com.huawei.notificationmanager.ui.NotificationManagmentActivity";
    private static final String MIUI_INTENT = "miui.intent.action.APP_PERM_EDITOR";
    private static final String MIUI_PACKAGE = "com.miui.securitycenter";
    private static final String MIUI_UI_APP_PERMISSION = "com.miui.permcenter.permissions.AppPermissionsEditorActivity";
    private static final String MIUI_UI_PERMISSION = "com.miui.permcenter.permissions.PermissionsEditorActivity";
    private static final String OPPO_PACKAGE_COLOR = "com.color.safecenter";
    private static final String OPPO_PACKAGE_COLOR_OS = "com.coloros.safecenter";
    private static final String OPPO_PACKAGE_OPPO = "com.oppo.safe";
    private static final String OPPO_UI_PERMISSION = "com.color.safecenter.permission.floatwindow.FloatWindowListActivity";
    private static final String OPPO_UI_SYS = "com.coloros.safecenter.sysfloatwindow.FloatWindowListActivity";
    private static final String OPPO_UI_SAFE = "com.oppo.safe.permission.PermissionAppListActivity";
    private static final String VIVO_PACKAGE = "com.iqoo.secure";
    private static final String VIVO_UI_SECURE_PHONE = "com.iqoo.secure.ui.phoneoptimize.FloatWindowManager";
    private static final String VIVO_UI_SAFE_PERMISSION = "com.iqoo.secure.safeguard.SoftPermissionDetailActivity";
    private static final String MEIZU_INTENT = "com.meizu.safe.security.SHOW_APPSEC";
    private static final String MEIZU_PACKAGE = "com.meizu.safe";
    private static final String MEIZU_UI_PERMISSION = "com.meizu.safe.security.AppSecActivity";
    private static final String DEFAULT_PACKAGE = "packageName";

    static String mark() {
        return Build.MANUFACTURER.toLowerCase();
    }

    public static Intent normal(Activity activity) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
        return intent;
    }

    public static Intent huawei(Activity activity) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(HUAWEI_PACKAGE, HUAWEI_UI_PERMISSION));
        if (PermissionSetting.isEmptyIntent(activity, intent)) {
            intent.setComponent(new ComponentName(HUAWEI_PACKAGE, HUAWEI_UI_SYSTEM));
            if (PermissionSetting.isEmptyIntent(activity, intent)) {
                intent.setComponent(new ComponentName(HUAWEI_PACKAGE, HUAWEI_UI_NOTIFICATION));
            }
        }
        return intent;
    }

    public static Intent xiaomi(Activity activity) {
        Intent intent = new Intent(MIUI_INTENT);
        intent.putExtra("extra_pkgname", activity.getPackageName());
        if (PermissionSetting.isEmptyIntent(activity, intent)) {
            intent.setPackage(MIUI_PACKAGE);
            if (PermissionSetting.isEmptyIntent(activity, intent)) {
                intent.setClassName(MIUI_PACKAGE, MIUI_UI_APP_PERMISSION);
                if (PermissionSetting.isEmptyIntent(activity, intent)) {
                    intent.setClassName(MIUI_PACKAGE, MIUI_UI_PERMISSION);
                }
            }
        }
        return intent;
    }

    public static Intent oppo(Activity activity) {
        Intent intent = new Intent();
        intent.putExtra(DEFAULT_PACKAGE, activity.getPackageName());
        if (PermissionSetting.isEmptyIntent(activity, intent)) {
            intent.setClassName(OPPO_PACKAGE_COLOR, OPPO_UI_PERMISSION);
            if (PermissionSetting.isEmptyIntent(activity, intent)) {
                intent.setClassName(OPPO_PACKAGE_COLOR_OS, OPPO_UI_SYS);
                if (PermissionSetting.isEmptyIntent(activity, intent)) {
                    intent.setClassName(OPPO_PACKAGE_OPPO, OPPO_UI_SAFE);
                }
            }
        }
        return intent;
    }

    public static Intent vivo(Activity activity) {
        Intent intent = new Intent();
        intent.setClassName(VIVO_PACKAGE, VIVO_UI_SECURE_PHONE);
        intent.putExtra(DEFAULT_PACKAGE, activity.getPackageName());
        if (PermissionSetting.isEmptyIntent(activity, intent)) {
            intent.setComponent(new ComponentName(VIVO_PACKAGE, VIVO_UI_SAFE_PERMISSION));
        }
        return intent;
    }

    public static Intent meizu(Activity activity) {
        Intent intent = new Intent(MEIZU_INTENT);
        intent.putExtra(DEFAULT_PACKAGE, activity.getPackageName());
        intent.setComponent(new ComponentName(MEIZU_PACKAGE, MEIZU_UI_PERMISSION));
        return intent;
    }

    public static void openSetting(Activity activity, boolean isNewTask) {
        Intent intent = null;
        intent = PermissionSetting.mark().equals("huawei") ? PermissionSetting.huawei(activity) : (PermissionSetting.mark().equals("xiaomi") ? PermissionSetting.xiaomi(activity) : (PermissionSetting.mark().equals("oppo") ? PermissionSetting.oppo(activity) : (PermissionSetting.mark().equals("vivo") ? PermissionSetting.vivo(activity) : (PermissionSetting.mark().equals("meizu") ? PermissionSetting.meizu(activity) : PermissionSetting.normal(activity)))));
        if (isNewTask) {
            intent.addFlags(0x10000000);
        }
        Logger.d(TAG + "\u5f53\u524d\u624b\u673a\u5382\u5546: " + PermissionSetting.mark());
        activity.startActivityForResult(intent, 101);
    }

    private static boolean isEmptyIntent(Activity activity, Intent intent) {
        return activity.getPackageManager().queryIntentActivities(intent, 65536).isEmpty();
    }
}

