/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.os;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.dzenm.helper.os.OsHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ScreenHelper {
    public static int getWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public static int getDiagonal() {
        return (int)Math.sqrt(Math.pow(ScreenHelper.getWidth(), 2.0) + Math.pow(ScreenHelper.getHeight(), 2.0));
    }

    public static Bitmap snapShotWithStatusBar(View view) {
        ScreenHelper.setDrawingCacheView(view);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight());
        view.destroyDrawingCache();
        return bitmap;
    }

    public static Bitmap snapShotWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        ScreenHelper.setDrawingCacheView(view);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)0, (int)ScreenHelper.getWidth(), (int)ScreenHelper.getHeight());
        view.destroyDrawingCache();
        return bitmap;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        ScreenHelper.setDrawingCacheView(view);
        Rect frame = new Rect();
        view.getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)statusBarHeight, (int)ScreenHelper.getWidth(), (int)(ScreenHelper.getHeight() - statusBarHeight));
        view.destroyDrawingCache();
        return bitmap;
    }

    private static void setDrawingCacheView(View view) {
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
    }

    public static void copy(Context context, CharSequence text) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"text/plain", (CharSequence)text);
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
        }
    }

    public static CharSequence paste(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboardManager == null) {
            return "";
        }
        ClipData clipData = clipboardManager.getPrimaryClip();
        return clipData == null ? "" : clipData.getItemAt(0).coerceToText(context);
    }

    public static boolean hideSoftInput(Activity activity) {
        View view = activity.getCurrentFocus();
        if (view == null) {
            return false;
        }
        return ((InputMethodManager)activity.getSystemService("input_method")).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void getFocusAndHideSoftInput(EditText editText) {
        if (OsHelper.isLollipop()) {
            editText.setShowSoftInputOnFocus(false);
        } else {
            Class<EditText> editClass = EditText.class;
            try {
                Method method = editClass.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)editText, editClass);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean showSoftInput(EditText editText) {
        return ((InputMethodManager)editText.getContext().getSystemService("input_method")).showSoftInput((View)editText, 0);
    }

    public static boolean hideSoftInput(EditText editText) {
        return ((InputMethodManager)editText.getContext().getSystemService("input_method")).hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    public static void setCursorDrawable(EditText editText, int drawable2) {
        try {
            Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
            f.setAccessible(true);
            f.set(editText, drawable2);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static String getHexColor(Context context, int id2) {
        StringBuilder sb = new StringBuilder();
        int color2 = context.getResources().getColor(id2);
        sb.append("#");
        sb.append(Integer.toHexString(Color.alpha((int)color2)));
        sb.append(Integer.toHexString(Color.red((int)color2)));
        sb.append(Integer.toHexString(Color.green((int)color2)));
        sb.append(Integer.toHexString(Color.blue((int)color2)));
        return sb.toString();
    }

    public static int getAlphaHexColor(Context context, int id2, int value) {
        String color2 = ScreenHelper.getHexColor(context, id2);
        int index = 1;
        if (color2.length() == 9) {
            index = 3;
        }
        int r = Integer.parseInt(color2.substring(index, index + 2), 16);
        int g = Integer.parseInt(color2.substring(index + 2, index + 4), 16);
        int b = Integer.parseInt(color2.substring(index + 4, index + 6), 16);
        return Color.argb((int)value, (int)r, (int)g, (int)b);
    }

    public static int getLineMaxNumber(String text, TextPaint textPaint, int maxWidth) {
        if (null == text || "".equals(text)) {
            return 0;
        }
        StaticLayout sl = new StaticLayout((CharSequence)text, textPaint, maxWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        return sl.getLineEnd(0);
    }
}

