/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.os;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.PermissionChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public final class OsHelper {
    private static final String KEY_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";
    private static final String KEY_VERSION_OPPO = "ro.build.version.opporom";
    private static final String KEY_VERSION_SMARTISAN = "ro.smartisan.version";
    private static final String KEY_VERSION_VIVO = "ro.vivo.os.version";
    private static String sName;
    private static String sVersion;

    public static boolean isEmui() {
        return OsHelper.check("EMUI");
    }

    public static boolean isMiui() {
        return OsHelper.check("MIUI");
    }

    public static boolean isVivo() {
        return OsHelper.check("VIVO");
    }

    public static boolean isOppo() {
        return OsHelper.check("OPPO");
    }

    public static boolean isFlyme() {
        return OsHelper.check("FLYME");
    }

    public static boolean is360() {
        return OsHelper.check("QIKU") || OsHelper.check("360");
    }

    public static boolean isSmartisan() {
        return OsHelper.check("SMARTISAN");
    }

    public static String getName() {
        if (sName == null) {
            OsHelper.check("");
        }
        return sName;
    }

    public static String getVersion() {
        if (sVersion == null) {
            OsHelper.check("");
        }
        return sVersion;
    }

    public static boolean check(String rom) {
        if (sName != null) {
            return sName.equals(rom);
        }
        sVersion = OsHelper.getProp(KEY_VERSION_MIUI);
        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
            sName = "MIUI";
        } else {
            sVersion = OsHelper.getProp(KEY_VERSION_EMUI);
            if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                sName = "EMUI";
            } else {
                sVersion = OsHelper.getProp(KEY_VERSION_OPPO);
                if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                    sName = "OPPO";
                } else {
                    sVersion = OsHelper.getProp(KEY_VERSION_VIVO);
                    if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                        sName = "VIVO";
                    } else {
                        sVersion = OsHelper.getProp(KEY_VERSION_SMARTISAN);
                        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                            sName = "SMARTISAN";
                        } else {
                            sVersion = Build.DISPLAY;
                            if (sVersion.toUpperCase().contains("FLYME")) {
                                sName = "FLYME";
                            } else {
                                sVersion = "unknown";
                                sName = Build.MANUFACTURER.toUpperCase();
                            }
                        }
                    }
                }
            }
        }
        return sName.equals(rom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProp(String name) {
        String line = null;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + name);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }

    public static String getAppName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized long getVersionCode(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Bitmap getIcon(Context context) {
        ApplicationInfo applicationInfo;
        PackageManager packageManager = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
            e.printStackTrace();
        }
        Drawable drawable2 = packageManager.getApplicationIcon(applicationInfo);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        return bitmapDrawable.getBitmap();
    }

    public static boolean install(Activity activity, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        if (OsHelper.isNougat()) {
            intent.addFlags(1);
        }
        intent.addFlags(0x10000000);
        if (intent.resolveActivity(activity.getPackageManager()) != null) {
            activity.startActivity(intent);
            return true;
        }
        return false;
    }

    public static boolean getTargetSdkVersion(Context context) {
        return context.getApplicationInfo().targetSdkVersion > 23;
    }

    public static List<String> getManifestPermissions(Context context) {
        try {
            return Arrays.asList(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isExistInManifest(Context context, String permission2) {
        List<String> manifestPermissions = OsHelper.getManifestPermissions(context);
        if (manifestPermissions == null && manifestPermissions.isEmpty()) {
            throw new NullPointerException("AndroidManifest permission is null");
        }
        if (manifestPermissions.equals(permission2)) {
            return true;
        }
        throw new NullPointerException("AndroidManifest's permission is not found");
    }

    public static boolean isGrant(Context context, String permission2) {
        if (OsHelper.getTargetSdkVersion(context)) {
            return PermissionChecker.checkPermission((Context)context, (String)permission2, (int)Binder.getCallingPid(), (int)Binder.getCallingUid(), (String)context.getPackageName()) == 0;
        }
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static boolean isRationale(Activity activity, String permission2) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
    }

    public static boolean isInstallPermission(Context context) {
        if (OsHelper.isOreo()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    public static boolean isOverlaysPermission(Context context) {
        if (OsHelper.isMarshmallow()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    public static boolean isNotificationEnabled(Context context) {
        boolean isEnabled;
        try {
            isEnabled = NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
        }
        catch (Exception e) {
            isEnabled = false;
            e.printStackTrace();
        }
        return isEnabled;
    }

    public static void openNotificationSetting(Context context) {
        Intent intent = new Intent();
        try {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            if (OsHelper.isOreo()) {
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", context.getApplicationInfo().uid);
            } else if (OsHelper.isLollipop()) {
                intent.putExtra("app_package", context.getPackageName());
                intent.putExtra("app_uid", context.getApplicationInfo().uid);
            } else {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
            }
        }
        catch (Exception e) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean isKitkat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean isLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean isNougat() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public static boolean isOreo() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public static int dp2px(float value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static int getDisplayWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getDisplayHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public static int getDisplayWidth(Activity activity) {
        return OsHelper.getDisplayMetrics((Activity)activity).widthPixels;
    }

    public static int getDisplayHeight(Activity activity) {
        return OsHelper.getDisplayMetrics((Activity)activity).heightPixels;
    }

    public static DisplayMetrics getDisplayMetrics(Activity activity) {
        DisplayMetrics metric = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getRealMetrics(metric);
        return metric;
    }
}

