/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.base.AbsBaseActivity;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.net.NetBroadcast;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetHelper {
    private static String TAG;
    private Context mContext;
    private static volatile NetBroadcast sNetBroadcast;
    private boolean isInitial = false;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile NetHelper sNetHelper;

    private NetHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetHelper getInstance() {
        if (sNetHelper != null) return sNetHelper;
        Class<NetHelper> clazz = NetHelper.class;
        synchronized (NetHelper.class) {
            if (sNetHelper != null) return sNetHelper;
            sNetHelper = new NetHelper();
            sNetBroadcast = NetBroadcast.getInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sNetHelper;
        }
    }

    public NetHelper init(Context context) {
        if (!this.isInitial) {
            TAG = context.getClass().getSimpleName() + "|";
            this.mContext = context;
            this.isInitial = true;
            Logger.i(TAG + "network broadcast init");
        }
        return this;
    }

    public NetHelper setOnNetworkChangeListener(AbsBaseActivity AbsBaseActivity2) {
        sNetBroadcast.setOnNetworkChangeListener(AbsBaseActivity2);
        return this;
    }

    public NetHelper register(Context context) {
        this.init(context);
        this.register();
        return this;
    }

    private NetHelper register() {
        if (!sNetBroadcast.isRegister()) {
            sNetBroadcast.registerNetwork(this.mContext);
        } else {
            Logger.i(TAG + "network broadcast is already register");
        }
        return this;
    }

    public NetHelper unregister() {
        if (sNetBroadcast.isRegister()) {
            sNetBroadcast.unregisterNetwork(this.mContext);
        } else {
            Logger.i(TAG + "network broadcast is not register");
        }
        return this;
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeInfo = manager.getActiveNetworkInfo();
        return activeInfo != null && activeInfo.isConnected();
    }

    public static boolean isWifiConnected(Context context) {
        boolean isConnected = false;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getNetworkInfo(1);
            isConnected = info.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }

    public static boolean isMobileConnected(Context context) {
        boolean isConnected = false;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getNetworkInfo(0);
            isConnected = info.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }

    @RequiresApi(api=23)
    public static boolean isConnectNet(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
        return networkCapabilities.hasCapability(16);
    }

    public static String getIPAddress(Context context) {
        NetworkInfo info = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface ni = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr = ni.getInetAddresses();
                        while (enumIpAddr.hasMoreElements()) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            Logger.d(TAG + "\u83b7\u53d6\u79fb\u52a8\u7f51\u7edcIPv4\u5730\u5740: " + inetAddress.getHostAddress());
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    return null;
                }
            } else if (info.getType() == 1) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) {
                    return null;
                }
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                Logger.d(TAG + "\u83b7\u53d6Wi-Fi\u7f51\u7edcIPv4\u5730\u5740: " + wifiInfo.getIpAddress());
                return NetHelper.intIP2StringIP(wifiInfo.getIpAddress());
            }
        } else {
            Logger.i(TAG + "\u5f53\u524d\u65e0\u7f51\u7edc\u8fde\u63a5,\u8bf7\u5728\u8bbe\u7f6e\u4e2d\u6253\u5f00\u7f51\u7edc");
        }
        return null;
    }

    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
    }

    public static void setNetworkSetting(final Context context) {
        InfoDialog.newInstance((AppCompatActivity)context).setTitle("\u7f51\u7edc\u5f02\u5e38\u63d0\u793a").setMessage("\u7f51\u7edc\u8fde\u63a5\u4e0d\u53ef\u7528,\u662f\u5426\u8fdb\u884c\u8bbe\u7f6e?").setButtonText("\u8bbe\u7f6e", "\u53d6\u6d88").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                if (confirm) {
                    Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                    intent.addFlags(0x10000000);
                    context.startActivity(intent);
                }
                return true;
            }
        }).show();
    }

    public static void setNetworkError(Context context) {
        InfoDialog.newInstance((AppCompatActivity)context).setTitle("\u7f51\u7edc\u5f02\u5e38\u63d0\u793a").setMessage("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u518d\u8bd5\u4e00\u6b21?").setButtonText("\u786e\u5b9a").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                return true;
            }
        }).show();
    }

    public static interface OnNetworkChangeListener {
        public void onNetwork(boolean var1);
    }
}

