/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.log;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.dzenm.helper.date.DateHelper;
import com.dzenm.helper.file.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class Logger {
    private static final String TAG = Logger.class.getSimpleName() + "|";
    private static final String SUFFIX = ".txt";
    private static boolean isDebug = true;
    private static String logcatPath;
    private LogDumper mLogDumper;
    private int mPID = android.os.Process.myPid();
    private static String mTag;
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    public static final int WTF = 6;
    public static final int ONTHING = 7;
    private static int sLevel;
    private static volatile Logger instance;

    private Logger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getInstance() {
        if (instance != null) return instance;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (instance != null) return instance;
            instance = new Logger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Logger setDebug(boolean isDebug) {
        Logger.isDebug = isDebug;
        return this;
    }

    public static boolean getDebug() {
        return isDebug;
    }

    public Logger setLevel(int level) {
        sLevel = level;
        return this;
    }

    public Logger setTag(String tag) {
        mTag = tag;
        return this;
    }

    public static void v(String msg) {
        if (sLevel <= 1 && isDebug) {
            Log.v((String)mTag, (String)msg);
        }
    }

    public static void d(String msg) {
        if (sLevel <= 2 && isDebug) {
            Log.d((String)mTag, (String)msg);
        }
    }

    public static void i(String msg) {
        if (sLevel <= 3 && isDebug) {
            Log.i((String)mTag, (String)msg);
        }
    }

    public static void w(String msg) {
        if (sLevel <= 4 && isDebug) {
            Log.w((String)mTag, (String)msg);
        }
    }

    public static void e(String msg) {
        if (sLevel <= 5 && isDebug) {
            Log.e((String)mTag, (String)msg);
        }
    }

    public static void wtf(String msg) {
        if (sLevel <= 6 && isDebug) {
            Log.wtf((String)mTag, (String)msg);
        }
    }

    public Logger init() {
        logcatPath = FileHelper.getInstance().getFolder("/log").getAbsolutePath();
        if (TextUtils.isEmpty((CharSequence)logcatPath)) {
            logcatPath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "log";
        }
        Logger.d(TAG + "\u65e5\u5fd7\u5b58\u50a8\u76ee\u5f55: " + logcatPath);
        return this;
    }

    public Logger start() {
        if (this.mLogDumper == null) {
            this.mLogDumper = new LogDumper(String.valueOf(this.mPID), logcatPath);
        }
        if (!this.mLogDumper.isAlive()) {
            this.mLogDumper.start();
        }
        Logger.i(TAG + "\u5f00\u59cb\u4fdd\u5b58\u65e5\u5fd7");
        return this;
    }

    public Logger stop() {
        if (this.mLogDumper != null) {
            this.mLogDumper.stopLogs();
            this.mLogDumper = null;
            Logger.i(TAG + "\u505c\u6b62\u8f93\u51fa\u65e5\u5fd7");
        }
        return this;
    }

    public Logger all() {
        this.mLogDumper.all();
        Logger.i(TAG + "\u6253\u5370\u6240\u6709\u7684\u65e5\u5fd7\u4fe1\u606f");
        return this;
    }

    public Logger tag() {
        this.mLogDumper.tag();
        Logger.i(TAG + "\u6253\u5370\u53ea\u5e26tag\u7684\u65e5\u5fd7\u4fe1\u606f");
        return this;
    }

    public Logger v() {
        this.mLogDumper.v();
        return this;
    }

    public Logger d() {
        this.mLogDumper.d();
        return this;
    }

    public Logger i() {
        this.mLogDumper.i();
        return this;
    }

    public Logger w() {
        this.mLogDumper.w();
        return this;
    }

    public Logger e() {
        this.mLogDumper.e();
        return this;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        return "Couldn't find a correct type for the object";
    }

    static {
        mTag = "DZY";
        sLevel = 1;
        instance = null;
    }

    private class LogDumper
    extends Thread {
        private Process logcatProcess;
        private BufferedReader mBufferedReader;
        private FileOutputStream mFileOutputStream;
        private boolean mRunning = true;
        private String mCmds;
        private String mPID;

        public LogDumper(String pid, String dir) {
            this.mPID = pid;
            try {
                this.mFileOutputStream = new FileOutputStream(new File(dir, DateHelper.getCurrentTimeMillis() + Logger.SUFFIX));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (isDebug) {
                this.tag();
            } else {
                this.all();
            }
        }

        private LogDumper all() {
            this.mCmds = "logcat |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper tag() {
            this.mCmds = "logcat -s " + mTag;
            return this;
        }

        private LogDumper v() {
            this.mCmds = "logcat *:e *:v |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper d() {
            this.mCmds = "logcat *:e *:d |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper i() {
            this.mCmds = "logcat *:e *:i |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper w() {
            this.mCmds = "logcat *:e *:w |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper e() {
            this.mCmds = "logcat *:e |grep\"(" + this.mPID + ")\"";
            return this;
        }

        private LogDumper stopLogs() {
            this.mRunning = false;
            return this;
        }

        @Override
        public void run() {
            super.run();
            try {
                String line;
                this.logcatProcess = Runtime.getRuntime().exec(this.mCmds);
                this.mBufferedReader = new BufferedReader(new InputStreamReader(this.logcatProcess.getInputStream()), 1024);
                while (this.mRunning && (line = this.mBufferedReader.readLine()) != null && this.mRunning) {
                    if (line.length() == 0 || this.mFileOutputStream == null || !line.contains(this.mPID)) continue;
                    this.mFileOutputStream.write(("| " + DateHelper.getCurrentTimeMillis() + " | " + line + "\n").getBytes());
                }
                this.mBufferedReader.close();
                this.mFileOutputStream.close();
                this.logcatProcess.destroy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.logcatProcess != null) {
                    this.logcatProcess.destroy();
                    this.logcatProcess = null;
                }
                if (this.mBufferedReader != null) {
                    try {
                        this.mBufferedReader.close();
                        this.mBufferedReader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mFileOutputStream != null) {
                    try {
                        this.mFileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.mFileOutputStream = null;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Level {
    }
}

