/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.draw;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import com.dzenm.helper.R;
import com.dzenm.helper.draw.IDrawable;
import com.dzenm.helper.os.OsHelper;

public class ShapeHelper
implements IDrawable<Drawable, View> {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ShapeHelper sShapeHelper;
    private Context mContext;
    private int mDrawableStyle = 0;
    private int mShape;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mColor;
    private float mTopLeftRadius = 0.0f;
    private float mTopRightRadius = 0.0f;
    private float mBottomRightRadius = 0.0f;
    private float mBottomLeftRadius = 0.0f;
    private float mStroke;
    private int mStrokeColor;
    private int[] mBounds;
    private int[] mGradientColors;
    private int mGradientType = 2;
    private float mGradientRadius;
    private GradientDrawable.Orientation mGradientOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
    private int mState;
    private Drawable mSelectorDrawable;
    private Drawable mNormalDrawable;
    private int mSelectorTextColor;
    private int mNormalTextColor;
    private int mRippleColor;
    private Drawable mRippleDrawable;
    private boolean isCustomizeColor;
    private boolean isCustomizeRadius;
    private boolean isCustomizeStroke;
    private boolean isCustomizeBounds;
    private boolean isCustomizeSelectorTextColor;
    private boolean isCustomizeGradient;

    private ShapeHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ShapeHelper getInstance() {
        if (sShapeHelper != null) return sShapeHelper;
        Class<ShapeHelper> clazz = ShapeHelper.class;
        synchronized (ShapeHelper.class) {
            if (sShapeHelper != null) return sShapeHelper;
            sShapeHelper = new ShapeHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sShapeHelper;
        }
    }

    ShapeHelper init(Context context) {
        this.mContext = context;
        return this;
    }

    public ShapeHelper shape(int shape) {
        this.mShape = shape;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper size(int width, int height) {
        this.mWidth = this.dp2px(width);
        this.mHeight = this.dp2px(height);
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper width(int width) {
        this.size(width, -1);
        return this;
    }

    public ShapeHelper height(int height) {
        this.size(-1, height);
        return this;
    }

    public ShapeHelper solid(@ColorRes int colorResId) {
        this.mColor = this.getColor(colorResId);
        this.isCustomizeColor = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper solid(String color2) {
        this.mColor = Color.parseColor((String)color2);
        this.isCustomizeColor = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radius(float radius) {
        this.radius(radius, radius, radius, radius);
        return this;
    }

    public ShapeHelper radiusTL(float tl) {
        this.mTopLeftRadius = tl;
        this.isCustomizeRadius = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radiusTR(float tr) {
        this.mTopRightRadius = tr;
        this.isCustomizeRadius = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radiusBR(float br) {
        this.mBottomRightRadius = br;
        this.isCustomizeRadius = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radiusBL(float bl) {
        this.mBottomLeftRadius = bl;
        this.isCustomizeRadius = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radius(float tl, float tr, float br, float bl) {
        this.radius(new float[]{tl, tr, br, bl});
        return this;
    }

    public ShapeHelper radius(float[] radii) {
        this.mTopLeftRadius = radii[0];
        this.mTopRightRadius = radii[1];
        this.mBottomRightRadius = radii[2];
        this.mBottomLeftRadius = radii[3];
        this.isCustomizeRadius = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper stroke(float stroke, @ColorRes int color2) {
        this.mStroke = stroke;
        this.mStrokeColor = this.getColor(color2);
        this.isCustomizeStroke = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper bound(int padding) {
        this.bound(new int[]{padding, padding, padding, padding});
        return this;
    }

    public ShapeHelper bound(int l, int t, int r, int b) {
        this.bound(new int[]{l, t, r, b});
        return this;
    }

    public ShapeHelper bound(int[] padding) {
        this.mBounds = padding;
        this.isCustomizeBounds = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper orientation(GradientDrawable.Orientation orientation) {
        this.mGradientOrientation = orientation;
        this.mGradientType = 0;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper radialRadius(int gradientRadius) {
        this.mGradientRadius = gradientRadius;
        this.mGradientType = 1;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper gradient(int ... colorsResId) {
        if (colorsResId.length > 1) {
            this.mGradientColors = new int[colorsResId.length];
            for (int i = 0; i < colorsResId.length; ++i) {
                this.mGradientColors[i] = this.getColor(colorsResId[i]);
            }
        }
        this.isCustomizeGradient = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper gradient(String ... colors) {
        if (colors.length > 1) {
            this.mGradientColors = new int[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.mGradientColors[i] = Color.parseColor((String)colors[i]);
            }
        }
        this.isCustomizeGradient = true;
        this.mDrawableStyle = 1;
        return this;
    }

    public ShapeHelper pressed(String pressedColor) {
        this.pressed("#FFFFFFFF", pressedColor);
        return this;
    }

    public ShapeHelper pressed(@ColorRes int pressedColor) {
        this.pressed(17170445, pressedColor);
        return this;
    }

    public ShapeHelper pressed(String normalColor, String pressedColor) {
        float topLeftRadius = this.mTopLeftRadius;
        float topRightRadius = this.mTopRightRadius;
        float bottomRightRadius = this.mBottomRightRadius;
        float bottomLeftRadius = this.mBottomLeftRadius;
        this.pressed(ShapeHelper.getInstance().solid(normalColor).radius(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build(), ShapeHelper.getInstance().solid(pressedColor).radius(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build());
        return this;
    }

    public ShapeHelper pressed(@ColorRes int normalColor, @ColorRes int pressedColor) {
        float topLeftRadius = this.mTopLeftRadius;
        float topRightRadius = this.mTopRightRadius;
        float bottomRightRadius = this.mBottomRightRadius;
        float bottomLeftRadius = this.mBottomLeftRadius;
        this.pressed(ShapeHelper.getInstance().solid(normalColor).radius(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build(), ShapeHelper.getInstance().solid(pressedColor).radius(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build());
        return this;
    }

    public ShapeHelper pressed(Drawable normalDrawable, Drawable pressedDrawable) {
        this.state(16842919, normalDrawable, pressedDrawable);
        return this;
    }

    public ShapeHelper state(int state, Drawable normalDrawable, Drawable pressedDrawable) {
        this.mState = state;
        this.mNormalDrawable = normalDrawable;
        this.mSelectorDrawable = pressedDrawable;
        this.mDrawableStyle = 2;
        return this;
    }

    public ShapeHelper textColor(int normalColorResId, int selectorColorResId) {
        this.mNormalTextColor = this.getColor(normalColorResId);
        this.mSelectorTextColor = this.getColor(selectorColorResId);
        this.mDrawableStyle = 2;
        this.isCustomizeSelectorTextColor = true;
        return this;
    }

    public ShapeHelper textColor(String normalColor, String selectorColor) {
        this.mNormalTextColor = Color.parseColor((String)normalColor);
        this.mSelectorTextColor = Color.parseColor((String)selectorColor);
        this.mDrawableStyle = 2;
        this.isCustomizeSelectorTextColor = true;
        return this;
    }

    public ShapeHelper ripple() {
        this.ripple(17170443, R.color.colorTranslucentLightGray);
        return this;
    }

    public ShapeHelper ripple(@ColorRes int normalColor) {
        this.ripple(normalColor, R.color.colorHint);
        return this;
    }

    public ShapeHelper ripple(String normalColor) {
        this.ripple(normalColor, "#E0E0E0");
        return this;
    }

    public ShapeHelper ripple(String normalColor, String pressedColor) {
        this.mRippleColor = Color.parseColor((String)pressedColor);
        this.mRippleDrawable = ShapeHelper.getInstance().solid(normalColor).radius(this.mTopLeftRadius, this.mTopRightRadius, this.mBottomRightRadius, this.mBottomLeftRadius).build();
        this.mDrawableStyle = 3;
        return this;
    }

    public ShapeHelper ripple(@ColorRes int normalColor, @ColorRes int pressedColor) {
        this.mRippleColor = pressedColor;
        this.mRippleDrawable = ShapeHelper.getInstance().solid(normalColor).radius(this.mTopLeftRadius, this.mTopRightRadius, this.mBottomRightRadius, this.mBottomLeftRadius).build();
        this.mDrawableStyle = 3;
        return this;
    }

    @Override
    public void into(View view) {
        if (this.isCustomizeSelectorTextColor) {
            int[] colors = new int[]{this.mSelectorTextColor, this.mNormalTextColor};
            int[][] states = new int[][]{{this.mState}, {-this.mState}};
            ((TextView)view).setTextColor(new ColorStateList((int[][])states, colors));
        }
        view.setBackground(this.build());
    }

    @Override
    public Drawable build() {
        if (this.mDrawableStyle == 1) {
            return this.createShape();
        }
        if (this.mDrawableStyle == 2) {
            return this.createSelector();
        }
        if (this.mDrawableStyle == 3) {
            return this.createRipple();
        }
        return null;
    }

    private void reset() {
        this.mColor = 0;
        this.mTopLeftRadius = 0.0f;
        this.mTopRightRadius = 0.0f;
        this.mBottomRightRadius = 0.0f;
        this.mBottomLeftRadius = 0.0f;
        this.mStroke = 0.0f;
        this.mStrokeColor = 0;
        this.mBounds = new int[]{0, 0, 0, 0};
        this.mGradientType = 2;
        this.mGradientRadius = 0.0f;
        this.mGradientOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
        this.isCustomizeColor = false;
        this.isCustomizeRadius = false;
        this.isCustomizeStroke = false;
        this.isCustomizeBounds = false;
        this.isCustomizeGradient = false;
        this.isCustomizeSelectorTextColor = false;
        this.mDrawableStyle = 0;
    }

    private GradientDrawable createShape() {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(this.mShape);
        if (this.isCustomizeColor) {
            drawable2.setColor(this.mColor);
        }
        if (this.isCustomizeRadius) {
            float[] radII = new float[]{this.dp2px(this.mTopLeftRadius), this.dp2px(this.mTopLeftRadius), this.dp2px(this.mTopRightRadius), this.dp2px(this.mTopRightRadius), this.dp2px(this.mBottomRightRadius), this.dp2px(this.mBottomRightRadius), this.dp2px(this.mBottomLeftRadius), this.dp2px(this.mBottomLeftRadius)};
            drawable2.setCornerRadii(radII);
        }
        if (this.isCustomizeStroke) {
            drawable2.setStroke(this.dp2px(this.mStroke), this.mStrokeColor);
        }
        if (this.isCustomizeBounds) {
            drawable2.setBounds(this.dp2px(this.mBounds[0]), this.dp2px(this.mBounds[1]), this.dp2px(this.mBounds[2]), this.dp2px(this.mBounds[3]));
        }
        if (this.isCustomizeGradient) {
            if (this.mGradientType == 0) {
                drawable2.setOrientation(this.mGradientOrientation);
            } else if (this.mGradientType == 1) {
                drawable2.setGradientRadius((float)this.dp2px(this.mGradientRadius));
            }
            drawable2.setGradientType(this.mGradientType);
            drawable2.setColors(this.mGradientColors);
        } else {
            drawable2.setUseLevel(true);
        }
        drawable2.setSize(this.mWidth, this.mHeight);
        this.reset();
        return drawable2;
    }

    private StateListDrawable createSelector() {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{this.mState}, this.mSelectorDrawable);
        drawable2.addState(new int[]{-this.mState}, this.mNormalDrawable);
        this.reset();
        return drawable2;
    }

    private RippleDrawable createRipple() {
        RippleDrawable rd = new RippleDrawable(this.mContext.getResources().getColorStateList(this.mRippleColor), this.mRippleDrawable, null);
        this.reset();
        return rd;
    }

    private int dp2px(float value) {
        return OsHelper.dp2px(value);
    }

    private int getColor(int id2) {
        return this.mContext.getResources().getColor(id2);
    }
}

