/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.draw;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.ColorRes;
import com.dzenm.helper.draw.ShapeHelper;

public class DrawableHelper {
    private DrawableHelper() {
    }

    public static ShapeHelper init(Context context) {
        return ShapeHelper.getInstance().init(context);
    }

    public static ShapeHelper shape(int shape) {
        return ShapeHelper.getInstance().shape(shape);
    }

    public static ShapeHelper size(int width, int height) {
        return ShapeHelper.getInstance().size(width, height);
    }

    public static ShapeHelper width(int width) {
        return ShapeHelper.getInstance().width(width);
    }

    public static ShapeHelper height(int height) {
        return ShapeHelper.getInstance().height(height);
    }

    public static ShapeHelper solid(@ColorRes int colorRedId) {
        return ShapeHelper.getInstance().solid(colorRedId);
    }

    public static ShapeHelper solid(String color2) {
        return ShapeHelper.getInstance().solid(color2);
    }

    public static ShapeHelper radius(float radius) {
        return ShapeHelper.getInstance().radius(radius);
    }

    public static ShapeHelper radiusTL(float tl) {
        return ShapeHelper.getInstance().radiusTL(tl);
    }

    public static ShapeHelper radiusTR(float tr) {
        return ShapeHelper.getInstance().radiusTR(tr);
    }

    public static ShapeHelper radiusBR(float br) {
        return ShapeHelper.getInstance().radiusBR(br);
    }

    public static ShapeHelper radiusBL(float bl) {
        return ShapeHelper.getInstance().radiusBL(bl);
    }

    public static ShapeHelper radius(float tl, float tr, float br, float bl) {
        return ShapeHelper.getInstance().radius(tl, tr, br, bl);
    }

    public static ShapeHelper radius(float[] radius) {
        return ShapeHelper.getInstance().radius(radius);
    }

    public static ShapeHelper stroke(int stroke, int color2) {
        return ShapeHelper.getInstance().stroke(stroke, color2);
    }

    public static ShapeHelper bound(int padding) {
        return ShapeHelper.getInstance().bound(padding);
    }

    public static ShapeHelper bound(int l, int t, int r, int b) {
        return ShapeHelper.getInstance().bound(l, t, r, b);
    }

    public static ShapeHelper bound(int[] padding) {
        return ShapeHelper.getInstance().bound(padding);
    }

    public static ShapeHelper orientation(GradientDrawable.Orientation orientation) {
        return ShapeHelper.getInstance().orientation(orientation);
    }

    public static ShapeHelper radialRadius(int gradientRadius) {
        return ShapeHelper.getInstance().radialRadius(gradientRadius);
    }

    public static ShapeHelper gradient(int ... colorsResId) {
        return ShapeHelper.getInstance().gradient(colorsResId);
    }

    public static ShapeHelper gradient(String ... colors) {
        return ShapeHelper.getInstance().gradient(colors);
    }

    public static ShapeHelper pressed(String pressedColor) {
        return ShapeHelper.getInstance().pressed(pressedColor);
    }

    public static ShapeHelper pressed(@ColorRes int pressedColor) {
        return ShapeHelper.getInstance().pressed(pressedColor);
    }

    public static ShapeHelper pressed(String normalColor, String pressedColor) {
        return ShapeHelper.getInstance().pressed(normalColor, pressedColor);
    }

    public static ShapeHelper pressed(@ColorRes int normalColor, @ColorRes int pressedColor) {
        return ShapeHelper.getInstance().pressed(normalColor, pressedColor);
    }

    public static ShapeHelper pressed(Drawable normalDrawable, Drawable pressedDrawable) {
        return ShapeHelper.getInstance().pressed(normalDrawable, pressedDrawable);
    }

    public static ShapeHelper state(int state, Drawable normalDrawable, Drawable pressedDrawable) {
        return ShapeHelper.getInstance().state(state, normalDrawable, pressedDrawable);
    }

    public static ShapeHelper textColor(@ColorRes int normalColorResId, @ColorRes int selectorColorResId) {
        return ShapeHelper.getInstance().textColor(normalColorResId, selectorColorResId);
    }

    public static ShapeHelper textColor(String normalColor, String selectorColor) {
        return ShapeHelper.getInstance().textColor(normalColor, selectorColor);
    }

    public static ShapeHelper ripple() {
        return ShapeHelper.getInstance().ripple();
    }

    public static ShapeHelper ripple(@ColorRes int normalColor) {
        return ShapeHelper.getInstance().ripple(normalColor);
    }

    public static ShapeHelper ripple(String normalColor) {
        return ShapeHelper.getInstance().ripple(normalColor);
    }

    public static ShapeHelper ripple(String normalColor, String pressedColor) {
        return ShapeHelper.getInstance().ripple(normalColor, pressedColor);
    }

    public static ShapeHelper ripple(@ColorRes int normalColor, @ColorRes int pressedColor) {
        return ShapeHelper.getInstance().ripple(normalColor, pressedColor);
    }
}

