/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.download;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.Message;
import android.text.TextUtils;
import com.dzenm.helper.file.FileHelper;
import com.dzenm.helper.file.SPHelper;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.task.WeakHandler;
import com.dzenm.helper.toast.ToastHelper;
import java.io.File;

public class DownloadHelper {
    private static final String TAG = DownloadHelper.class.getSimpleName() + "|";
    private static final long DOWNLOAD_DEFAULT_ID = 0L;
    private static final long DOWNLOAD_ERROR_ID = -1L;
    private static final int DOWNLOAD_PROGRESS = 1001;
    private static final int DOWNLOAD_FAILED = 1002;
    private static final String DOWNLOAD_PREF = "download_helper_pref";
    private Context mContext;
    private DownloadReceiver mDownloadReceiver;
    private DownloadManager mDownloadManager;
    private long mDownloadId;
    private OnDownloadListener mOnDownloadListener;
    private String mUrl;
    private String mFilePath;
    private String mFileName;
    private String mVersionName = "1";
    private boolean isRunningDownload = false;
    private boolean isDefaultPath = true;
    private int mNotificationType = 1;
    @SuppressLint(value={"HandlerLeak"})
    private final WeakHandler mHandler = new WeakHandler(this.mContext){

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1001) {
                long[] fileSize = (long[])msg.obj;
                int current = (int)(100L * fileSize[0] / fileSize[1]);
                if (DownloadHelper.this.mOnDownloadListener != null) {
                    DownloadHelper.this.mOnDownloadListener.onProgress(fileSize[1], fileSize[0], current);
                }
            } else if (msg.what == 1002) {
                DownloadHelper.this.removeDownloadManager();
                DownloadHelper.this.setDownloadFailed((String)msg.obj);
            }
        }
    };
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            DownloadHelper.this.getDownloadManagerQueryStatus();
            DownloadHelper.this.mHandler.post(DownloadHelper.this.mRunnable);
        }
    };
    private long mDownloadValue = 0L;
    private int mStatus = 1001;

    public static DownloadHelper newInstance(Context context) {
        return new DownloadHelper(context);
    }

    public DownloadHelper(Context context) {
        this.mContext = context;
        this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
        this.mDownloadReceiver = new DownloadReceiver();
        this.mFileName = OsHelper.getAppName(context) + ".apk";
        this.mFilePath = FileHelper.getInstance().getFolder("/apk").getPath();
    }

    public DownloadHelper setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public DownloadHelper setFilePath(String filePath) {
        this.mFilePath = filePath;
        this.isDefaultPath = false;
        return this;
    }

    public DownloadHelper setFileName(String fileName) {
        this.mFileName = fileName;
        return this;
    }

    public DownloadHelper setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    public String getFilePath() {
        return this.mFilePath + File.separator + this.mVersionName + File.separator + this.mFileName;
    }

    public DownloadHelper setNotificationType(int notificationType) {
        this.mNotificationType = notificationType;
        return this;
    }

    public DownloadHelper setOnDownloadListener(OnDownloadListener onDownloadListener) {
        this.mOnDownloadListener = onDownloadListener;
        return this;
    }

    public boolean isRunningDownload() {
        return this.isRunningDownload;
    }

    public void startDownload() {
        this.checkPermissionAndDownloadFile();
    }

    private void checkPermissionAndDownloadFile() {
        if (OsHelper.isGrant(this.mContext, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            String filePath;
            if (this.isDefaultPath) {
                this.mFilePath = this.mFilePath + File.separator + this.mVersionName;
            }
            if (!TextUtils.isEmpty((CharSequence)(filePath = (String)SPHelper.getInstance().get(DOWNLOAD_PREF, this.mVersionName, "")))) {
                File file = new File(filePath);
                if (file.exists() && file.isFile()) {
                    Logger.d(TAG + "\u5df2\u4e0b\u8f7d\u8fc7\u6587\u4ef6, \u7248\u672c\u53f7: " + this.mVersionName + ", \u6587\u4ef6\u8def\u5f84" + filePath);
                    this.apkFileDownloadSuccessCallback(this.mContext, FileHelper.getInstance().getUri(file));
                } else {
                    this.downloadFile();
                }
            } else {
                this.downloadFile();
            }
        } else {
            this.setDownloadFailed("\u672a\u5f00\u542f\u5b58\u50a8\u6743\u9650\uff0c \u8bf7\u5148\u6253\u5f00\u5b58\u50a8\u6743\u9650");
        }
    }

    public void cancel() {
        this.removeDownloadManager();
    }

    private void registerDownloadBroadcast() {
        if (!this.isRunningDownload) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.DOWNLOAD_COMPLETE");
            intentFilter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
            this.mContext.registerReceiver((BroadcastReceiver)this.mDownloadReceiver, intentFilter);
            this.isRunningDownload = true;
        }
    }

    private void unregisterDownloadBroadcas() {
        if (this.isRunningDownload) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mDownloadReceiver);
            this.isRunningDownload = false;
        }
    }

    private boolean isDownloadManager() {
        String packageName = "com.android.providers.downloads";
        int state = this.mContext.getPackageManager().getApplicationEnabledSetting(packageName);
        if (state == 2 || state == 3 || state == 4) {
            try {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.parse((String)("package:" + packageName)));
                this.mContext.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                this.mContext.startActivity(intent);
            }
            return false;
        }
        return true;
    }

    private void downloadFile() {
        this.registerDownloadBroadcast();
        if (this.isDownloadManager()) {
            if (this.mDownloadId != 0L) {
                this.removeTask(this.mDownloadId);
            }
            Logger.i(TAG + "\u5df2\u6ce8\u518c\u4e0b\u8f7d\u76d1\u542c\u5e7f\u64ad, \u5f00\u59cb\u4e0b\u8f7d...");
            this.mHandler.post(this.mRunnable);
            this.mDownloadId = this.enqueue(this.getRequest(this.mUrl));
            Logger.i(TAG + "\u4e0b\u8f7d\u4efb\u52a1Download ID: " + this.mDownloadId);
        } else {
            this.loadBrowserDownload();
        }
    }

    private void loadBrowserDownload() {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)this.mUrl));
        this.mContext.startActivity(intent);
        Logger.i(TAG + "\u5df2\u6ce8\u518c\u4e0b\u8f7d\u76d1\u542c\u5e7f\u64ad, \u8c03\u7528\u6d4f\u89c8\u5668\u4e0b\u8f7d...");
    }

    private void removeTask(Long downloadId) {
        try {
            this.mDownloadManager.remove(new long[]{downloadId});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private Long enqueue(DownloadManager.Request request) {
        try {
            return this.mDownloadManager.enqueue(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.removeDownloadManager();
            this.setDownloadFailed("\u627e\u4e0d\u5230\u4e0b\u8f7d\u6587\u4ef6");
            return -1L;
        }
    }

    private void removeDownloadManager() {
        this.mHandler.removeCallbacks(this.mRunnable);
        this.unregisterDownloadBroadcas();
        Logger.i(TAG + "\u79fb\u9664\u4e0b\u8f7d\u4efb\u52a1, \u79fb\u9664\u8fdb\u5ea6\u67e5\u8be2, \u53d6\u6d88\u6ce8\u518c\u4e0b\u8f7d\u76d1\u542c\u5e7f\u64ad");
    }

    private DownloadManager.Request getRequest(String url) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        Logger.d(TAG + "\u4e0b\u8f7d\u6587\u4ef6\u7684url:" + url);
        if (TextUtils.isEmpty((CharSequence)this.mFilePath)) {
            this.mFilePath = Environment.DIRECTORY_DOWNLOADS;
            request.setDestinationInExternalFilesDir(this.mContext, this.mFilePath, this.mFileName);
        } else {
            File file = new File(this.mFilePath, this.mFileName);
            Uri uri = Uri.fromFile((File)file);
            request.setDestinationUri(uri);
        }
        Logger.d(TAG + "\u4e0b\u8f7d\u6587\u4ef6\u5b58\u50a8\u76ee\u5f55: " + this.mFilePath);
        request.setAllowedNetworkTypes(3);
        request.setMimeType("application/vnd.android.package-archive").setTitle((CharSequence)this.mFileName).setVisibleInDownloadsUi(true).setNotificationVisibility(this.mNotificationType).setAllowedOverRoaming(true).allowScanningByMediaScanner();
        if (this.mOnDownloadListener != null) {
            this.mOnDownloadListener.onPrepared(request);
        }
        return request;
    }

    private void getDownloadManagerQueryStatus() {
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId});
        Cursor cursor = this.mDownloadManager.query(query);
        if (cursor == null) {
            return;
        }
        if (!cursor.moveToFirst()) {
            return;
        }
        String msg = "\u4e0b\u8f7d\u5931\u8d25:";
        int status = cursor.getInt(cursor.getColumnIndexOrThrow("status"));
        if (status == 1) {
            if (this.mStatus != status) {
                Logger.i(TAG + "\u7b49\u5f85\u4e0b\u8f7d");
                this.mStatus = status;
            }
        } else if (status == 2) {
            long downloadSoFar = cursor.getLong(cursor.getColumnIndex("bytes_so_far"));
            long downloadTotalSize = cursor.getLong(cursor.getColumnIndex("total_size"));
            if (downloadTotalSize == -1L) {
                return;
            }
            if (this.mDownloadValue == downloadSoFar) {
                return;
            }
            Logger.i(TAG + "\u6b63\u5728\u4e0b\u8f7d\u8fdb\u5ea6: " + downloadSoFar);
            Logger.i(TAG + "\u603b\u6587\u4ef6\u5927\u5c0f: " + downloadTotalSize);
            Message message = Message.obtain();
            message.what = 1001;
            long[] fileSize = new long[]{downloadSoFar, downloadTotalSize};
            message.obj = fileSize;
            this.mHandler.sendMessage(message);
            this.mDownloadValue = downloadSoFar;
        } else if (status == 4) {
            if (this.mStatus != status) {
                this.mStatus = status;
                String title = cursor.getString(cursor.getColumnIndex("title"));
                int reason = cursor.getInt(cursor.getColumnIndex("reason"));
                if (reason == 3) {
                    msg = title + ": \u7b49\u5f85\u8fde\u63a5Wi-Fi\u7f51\u7edc";
                } else if (reason == 2) {
                    msg = title + ": \u7b49\u5f85\u8fde\u63a5\u7f51\u7edc";
                } else if (reason == 1) {
                    msg = title + ": \u7b49\u5f85\u91cd\u8bd5...";
                }
            }
            Logger.e(TAG + "\u4e0b\u8f7d\u6682\u505c: " + msg);
            this.removeDownloadManager();
        } else if (status == 8) {
            if (this.mStatus != status) {
                Logger.i(TAG + "\u4e0b\u8f7d\u6210\u529f");
                this.mStatus = status;
            }
        } else if (status == 16) {
            if (this.mStatus == status) {
                return;
            }
            this.mStatus = status;
            int reason = cursor.getInt(cursor.getColumnIndex("reason"));
            if (reason == 1001) {
                msg = "\u6587\u4ef6\u9519\u8bef";
            } else if (reason == 1002) {
                msg = "\u672a\u5904\u7406\u7684HTTP\u9519\u8bef\u7801";
            } else if (reason == 1004) {
                msg = "\u6570\u636e\u63a5\u6536\u6216\u5904\u7406\u9519\u8bef";
            } else if (reason == 1005) {
                msg = "\u91cd\u5b9a\u5411\u9519\u8bef";
            } else if (reason == 1006) {
                msg = "\u5b58\u50a8\u7a7a\u95f4\u4e0d\u8db3";
            } else if (reason == 1007) {
                msg = "\u8bbe\u5907\u672a\u627e\u5230";
            } else if (reason == 1008) {
                msg = "\u6062\u590d\u4e0b\u8f7d\u5931\u8d25";
            } else if (reason == 1009) {
                msg = "\u6587\u4ef6\u5df2\u5b58\u5728";
            } else if (reason == 1000) {
                msg = "\u672a\u77e5\u9519\u8bef";
            }
            Logger.e(TAG + "\u4e0b\u8f7d\u5931\u8d25: " + msg);
            Message message = Message.obtain();
            message.what = 1002;
            message.obj = msg;
            this.mHandler.sendMessage(message);
        }
        if (!cursor.isClosed()) {
            cursor.close();
        }
    }

    private void setDownloadFailed(String msg) {
        if (this.mOnDownloadListener == null) {
            ToastHelper.show(msg);
        } else {
            this.mOnDownloadListener.onFailed(msg);
        }
    }

    private void verifyDownloadFile(Context context, long id2) {
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        Uri uri = downloadManager.getUriForDownloadedFile(id2);
        Logger.d(TAG + "\u63a5\u6536\u4e0b\u8f7d\u6587\u4ef6\u7684ID: " + id2);
        Logger.d(TAG + "\u63a5\u6536\u4e0b\u8f7d\u6587\u4ef6uri: " + uri);
        if (uri != null) {
            String type = downloadManager.getMimeTypeForDownloadedFile(id2);
            SPHelper.getInstance().put(DOWNLOAD_PREF, this.mFileName, id2);
            SPHelper.getInstance().put(DOWNLOAD_PREF, this.mVersionName, FileHelper.getInstance().getRealFilePath(uri));
            if ("application/vnd.android.package-archive".equals(type)) {
                this.apkFileDownloadSuccessCallback(context, uri);
            } else {
                this.fileDownloadSuccessCallback(uri);
            }
        } else {
            this.setDownloadFailed("\u4e0b\u8f7d\u5931\u8d25, \u7f51\u7edc\u9519\u8bef");
        }
        this.mDownloadId = 0L;
        this.removeDownloadManager();
    }

    private void apkFileDownloadSuccessCallback(Context context, Uri uri) {
        if (!OsHelper.install((Activity)context, uri)) {
            Logger.d(TAG + "\u5b89\u88c5\u5931\u8d25");
            this.setDownloadFailed("\u5b89\u88c5\u5931\u8d25");
        } else {
            Logger.d(TAG + "\u8fdb\u5165\u5b89\u88c5APK");
        }
        this.fileDownloadSuccessCallback(uri);
    }

    private void fileDownloadSuccessCallback(Uri uri) {
        if (this.mOnDownloadListener != null) {
            this.mOnDownloadListener.onSuccess(uri, "application/vnd.android.package-archive");
        }
    }

    public static interface OnDownloadListener {
        public void onPrepared(DownloadManager.Request var1);

        public void onProgress(long var1, long var3, int var5);

        public void onSuccess(Uri var1, String var2);

        public void onFailed(String var1);
    }

    private class DownloadReceiver
    extends BroadcastReceiver {
        private DownloadReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DOWNLOAD_COMPLETE".equals(intent.getAction())) {
                long id2 = intent.getLongExtra("extra_download_id", -1L);
                if (id2 == DownloadHelper.this.mDownloadId) {
                    DownloadHelper.this.verifyDownloadFile(context, id2);
                }
            } else if ("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED".equals(intent.getAction())) {
                Intent intentView = new Intent("android.intent.action.VIEW_DOWNLOADS");
                intentView.setFlags(0x10000000);
                context.startActivity(intentView);
            }
        }
    }
}

