/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.download;

import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.toast.ToastHelper;
import java.io.File;

public class DownloadFileHelper {
    private static final String TAG = DownloadFileHelper.class.getSimpleName() + "|";
    private static final long DOWNLOAD_DEFAULT_ID = 0L;
    private static final long DOWNLOAD_ERROR_ID = -1L;
    private Context mContext;
    private DownloadReceiver mDownloadReceiver;
    private DownloadManager mDownloadManager;
    private long mDownloadId;
    private String mFilePath;
    private String mUrl;
    private boolean isShowRunningNotification = true;
    private OnDownloadListener mOnDownloadListener;

    public DownloadFileHelper(Context context) {
        this.mContext = context;
        this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
    }

    public static DownloadFileHelper newInstance(Context context) {
        return new DownloadFileHelper(context);
    }

    public DownloadFileHelper setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public DownloadFileHelper setFileFolder(String filePath) {
        this.mFilePath = filePath;
        return this;
    }

    public DownloadFileHelper setOnDownloadListener(OnDownloadListener onDownloadListener) {
        this.mOnDownloadListener = onDownloadListener;
        return this;
    }

    public DownloadFileHelper setShowRunningNotification(boolean showRunningNotification) {
        this.isShowRunningNotification = showRunningNotification;
        return this;
    }

    public DownloadFileHelper download() {
        if (OsHelper.isGrant(this.mContext, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.registerDownloadBroadcast();
            if (this.isDownloadManager()) {
                if (this.mDownloadId != 0L) {
                    this.clearCurrentTask(this.mDownloadId);
                }
                this.mDownloadId = this.showNotification();
            } else {
                this.setDownloadFailed("\u8bf7\u5f00\u542f\u4e0b\u8f7d\u7ba1\u7406\u5668");
            }
        } else {
            this.setDownloadFailed("\u672a\u5f00\u542f\u5b58\u50a8\u6743\u9650\uff0c \u8bf7\u5148\u6253\u5f00\u5b58\u50a8\u6743\u9650");
        }
        return this;
    }

    private void registerDownloadBroadcast() {
        this.mDownloadReceiver = new DownloadReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DOWNLOAD_COMPLETE");
        intentFilter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
        this.mContext.registerReceiver((BroadcastReceiver)this.mDownloadReceiver, intentFilter);
    }

    private void unregisterDownloadBroadcast() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mDownloadReceiver);
    }

    private boolean isDownloadManager() {
        String packageName = "com.android.providers.downloads";
        int state = this.mContext.getPackageManager().getApplicationEnabledSetting(packageName);
        if (state == 2 || state == 3 || state == 4) {
            try {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.parse((String)("package:" + packageName)));
                this.mContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                Intent intent = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
                this.mContext.startActivity(intent);
            }
            return false;
        }
        return true;
    }

    private void setDownloadFailed(String msg) {
        if (this.mOnDownloadListener != null) {
            this.mOnDownloadListener.onFailed(msg);
        } else {
            ToastHelper.show(msg);
        }
    }

    private Long showNotification() {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.mUrl));
        request.setAllowedNetworkTypes(3).setNotificationVisibility(1);
        request.setDestinationInExternalFilesDir(this.mContext, Environment.DIRECTORY_DOWNLOADS, OsHelper.getAppName(this.mContext) + ".apk");
        String appName = OsHelper.getAppName(this.mContext) + ".apk";
        File file = new File(this.mFilePath, appName);
        Logger.d(TAG + "\u4e0b\u8f7d\u6587\u4ef6\u5b58\u50a8\u7684\u76ee\u5f55:" + file.getAbsolutePath());
        Uri uri = Uri.fromFile((File)file);
        Logger.d(TAG + "\u4e0b\u8f7d\u6587\u4ef6\u7684uri:" + uri);
        request.setDestinationUri(uri);
        request.setShowRunningNotification(this.isShowRunningNotification);
        request.setTitle((CharSequence)appName).setMimeType("application/vnd.android.package-archive").allowScanningByMediaScanner();
        request.setVisibleInDownloadsUi(true);
        try {
            return this.mDownloadManager.enqueue(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setDownloadFailed("\u627e\u4e0d\u5230\u4e0b\u8f7d\u6587\u4ef6");
            return -1L;
        }
    }

    private void clearCurrentTask(Long downloadId) {
        try {
            this.mDownloadManager.remove(new long[]{downloadId});
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    public static interface OnDownloadListener {
        public void onSuccess(Uri var1);

        public void onFailed(String var1);
    }

    private class DownloadReceiver
    extends BroadcastReceiver {
        private DownloadReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DOWNLOAD_COMPLETE")) {
                long id2 = intent.getLongExtra("extra_download_id", -1L);
                if (DownloadFileHelper.this.mDownloadId == id2) {
                    this.installApk(context, id2);
                }
            } else if (intent.getAction().equals("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED")) {
                Intent viewDownloadIntent = new Intent("android.intent.action.VIEW_DOWNLOADS");
                viewDownloadIntent.setFlags(0x10000000);
                context.startActivity(viewDownloadIntent);
            }
        }

        private void installApk(Context context, long downloadApkId) {
            DownloadManager manager = (DownloadManager)context.getSystemService("download");
            Uri downloadFileUri = manager.getUriForDownloadedFile(downloadApkId);
            if (downloadFileUri != null) {
                if (DownloadFileHelper.this.mOnDownloadListener != null) {
                    DownloadFileHelper.this.mOnDownloadListener.onSuccess(downloadFileUri);
                } else {
                    Intent install = new Intent("android.intent.action.VIEW");
                    install.setDataAndType(downloadFileUri, "application/vnd.android.package-archive");
                    if (Build.VERSION.SDK_INT >= 24) {
                        install.addFlags(1);
                    }
                    install.addFlags(0x10000000);
                    if (install.resolveActivity(context.getPackageManager()) != null) {
                        context.startActivity(install);
                    } else {
                        DownloadFileHelper.this.setDownloadFailed("\u81ea\u52a8\u5b89\u88c5\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5b89\u88c5");
                    }
                }
            } else {
                DownloadFileHelper.this.setDownloadFailed("\u4e0b\u8f7d\u5931\u8d25");
            }
            DownloadFileHelper.this.mDownloadId = 0L;
            DownloadFileHelper.this.unregisterDownloadBroadcast();
        }
    }
}

