/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.IdRes;

public class ViewHolder {
    private SparseArray<View> mViews;
    private View mConvertView;

    private ViewHolder(View view) {
        this.mConvertView = view;
        this.mViews = new SparseArray();
    }

    public static ViewHolder create(View view) {
        return new ViewHolder(view);
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public void setText(int viewId, String text) {
        TextView textView = (TextView)this.getView(viewId);
        textView.setText((CharSequence)text);
    }

    public String getText(int viewId) {
        TextView textView = (TextView)this.getView(viewId);
        return textView.getText().toString();
    }

    public void setVisible(int viewId, int visible) {
        this.getView(viewId).setVisibility(visible);
    }

    public int getVisible(int viewId) {
        return this.getView(viewId).getVisibility();
    }

    public void setTextColor(int viewId, int color2) {
        TextView textView = (TextView)this.getView(viewId);
        textView.setTextColor(color2);
    }

    public void setTextSize(int viewId, float size) {
        TextView textView = (TextView)this.getView(viewId);
        textView.setTextSize(size);
    }

    public void setBackground(int viewId, Drawable drawable2) {
        Object view = this.getView(viewId);
        view.setBackground(drawable2);
    }

    public void setBackgroundResource(int viewId, int resId) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(resId);
    }

    public void setBackgroundColor(int viewId, int color2) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color2);
    }

    public void setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
    }
}

