/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.view.ImageLoader;
import com.dzenm.helper.view.RatioImageView;

public class PreviewDialog
extends AbsDialogFragment
implements View.OnTouchListener {
    private static final int NONE = -1;
    private static final int MODE_DOWN = 0;
    private static final int MODE_POINT_DOWN = 1;
    private static final int STATUS_SCALE = 2;
    private static final int STATUS_ZOOM = 4;
    private ImageLoader mImageLoader;
    private Object mImage;
    private RatioImageView mImageView;
    private int mTouchDownX;
    private int mTouchDownY;
    private int mOffsetY;
    private int mOffsetX;
    private float mPointDistance = 0.0f;
    private PointF mMidPointF;
    private int mStatus = -1;
    private int mMode = -1;

    public static PreviewDialog newInstance(AppCompatActivity activity) {
        return new PreviewDialog(activity);
    }

    public PreviewDialog(AppCompatActivity activity) {
        super(activity);
    }

    public PreviewDialog loader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
        return this;
    }

    public PreviewDialog load(Object image) {
        this.mImage = image;
        return this;
    }

    @Override
    protected boolean isFullScreen() {
        return true;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initView() {
        this.getDialog().requestWindowFeature(1);
        RelativeLayout relativeLayout = new RelativeLayout((Context)this.mActivity);
        RelativeLayout.LayoutParams imageParams = new RelativeLayout.LayoutParams(-1, -2);
        imageParams.addRule(13);
        this.mImageView = new RatioImageView((Context)this.mActivity);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imageParams);
        relativeLayout.setOnTouchListener((View.OnTouchListener)this);
        relativeLayout.addView((View)this.mImageView);
        this.mView = relativeLayout;
        this.mBackground = DrawableHelper.solid(17170445).build();
        this.mDimAccount = 1.0f;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mImageLoader.onLoader(this.mImageView, this.mImage);
    }

    public boolean onTouch(View v, MotionEvent event) {
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 0: {
                this.mStatus = 0;
                this.mTouchDownX = (int)event.getX(0);
                this.mTouchDownY = (int)event.getY(0);
                break;
            }
            case 5: {
                this.mPointDistance = this.getPointDistance(event);
                if (!(this.mPointDistance > 40.0f)) break;
                this.mMidPointF = this.getPointMid(event);
                this.mStatus = 1;
                break;
            }
            case 2: {
                if (event.getPointerCount() != 1 || this.mStatus != 0 || this.mMode == 4) break;
                this.mOffsetX = (int)event.getX(0) - this.mTouchDownX;
                this.mOffsetY = (int)event.getY(0) - this.mTouchDownY;
                float offset = (float)this.mOffsetY / (float)OsHelper.getDisplayHeight();
                this.setImageDismissAnimator(this.mOffsetX, this.mOffsetY, this.mOffsetY > 0 ? this.mDimAccount - offset : this.mDimAccount);
                break;
            }
            case 1: 
            case 3: {
                if (event.getPointerCount() != 1) break;
                if ((double)this.mOffsetY > (double)OsHelper.getDisplayHeight() * 0.1) {
                    this.dismiss();
                    break;
                }
                this.setImageDismissAnimator(0, 0, this.mDimAccount);
                break;
            }
        }
        return true;
    }

    private void setImageScaleAnimator(float pivotX, float pivotY, float scale) {
        this.mImageView.setPivotX(pivotX);
        this.mImageView.setPivotY(pivotY);
        this.mImageView.setScaleX(scale);
        this.mImageView.setScaleY(scale);
    }

    private void setImageDismissAnimator(int translateX, int translateY, float scale) {
        this.mImageView.setTranslationX(translateX);
        this.mImageView.setTranslationY(translateY);
        this.mImageView.setScaleX(scale);
        this.mImageView.setScaleY(scale);
        this.getWindow().setDimAmount(scale);
    }

    private float getPointDistance(MotionEvent event) {
        float x = event.getX(1) - event.getX(0);
        float y = event.getY(1) - event.getY(0);
        return (float)Math.sqrt(x * x + y * y);
    }

    private PointF getPointMid(MotionEvent event) {
        float midX = (event.getX(0) + event.getX(1)) / 2.0f;
        float midY = (event.getY(0) + event.getY(1)) / 2.0f;
        return new PointF(midX, midY);
    }
}

