/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;

@SuppressLint(value={"ValidFragment"})
public class InfoDialog
extends AbsDialogFragment
implements View.OnClickListener {
    private String mTitle;
    private int mTitleIcon = -1;
    private String mMessage;
    private String mPositiveButtonText;
    private String mNegativeButtonText;
    private boolean isSingleButton = false;
    private int mPositiveButtonTextColor = -1;
    private int mNegativeButtonTextColor = -1;
    protected TextView tvMessage;
    protected TextView tvPositive;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (InfoDialog.this.tvMessage == null) {
                return;
            }
            if (InfoDialog.this.tvMessage.getLayout() == null) {
                return;
            }
            int lineCount = InfoDialog.this.tvMessage.getLayout().getLineCount();
            InfoDialog.this.tvMessage.setGravity(lineCount > 1 ? 0x800003 : 1);
        }
    };

    public static InfoDialog newInstance(AppCompatActivity activity) {
        return new InfoDialog(activity);
    }

    public InfoDialog setTitle(String title) {
        this.mTitle = title;
        return this;
    }

    public InfoDialog setTitle(int resId) {
        this.mTitle = this.getString(resId);
        return this;
    }

    public InfoDialog setTitleIcon(int titleIcon) {
        this.mTitleIcon = titleIcon;
        return this;
    }

    public InfoDialog setMessage(String message) {
        this.mMessage = message;
        return this;
    }

    public InfoDialog setMessage(int resId) {
        this.mMessage = this.getStrings(resId);
        return this;
    }

    public InfoDialog setButtonText(String positiveButtonText) {
        this.mPositiveButtonText = positiveButtonText;
        this.isSingleButton = true;
        return this;
    }

    public InfoDialog setButtonText(String positiveButtonText, String negativeButtonText) {
        this.mPositiveButtonText = positiveButtonText;
        this.mNegativeButtonText = negativeButtonText;
        this.isSingleButton = false;
        return this;
    }

    public InfoDialog setButtonTextColor(int positiveButtonTextColor, int negativeButtonTextColor) {
        this.mPositiveButtonTextColor = this.getColor(positiveButtonTextColor);
        this.mNegativeButtonTextColor = this.getColor(negativeButtonTextColor);
        return this;
    }

    public InfoDialog setButtonTextColor(int buttonTextColor) {
        this.mPositiveButtonTextColor = this.getColor(buttonTextColor);
        this.mNegativeButtonTextColor = this.getColor(buttonTextColor);
        return this;
    }

    public String getMessage() {
        return this.tvMessage.getText().toString();
    }

    public InfoDialog setMargin(int margin) {
        return (InfoDialog)((Object)super.setMargin(margin));
    }

    public InfoDialog setGravity(int gravity) {
        return (InfoDialog)((Object)super.setGravity(gravity));
    }

    public InfoDialog setAnimator(int animator) {
        return (InfoDialog)((Object)super.setAnimator(animator));
    }

    public InfoDialog setBackground(Drawable background) {
        return (InfoDialog)((Object)super.setBackground(background));
    }

    public InfoDialog setCenterWidth(int width) {
        return (InfoDialog)((Object)super.setCenterWidth(width));
    }

    public InfoDialog setPrimaryColor(int primaryColor) {
        return (InfoDialog)((Object)super.setPrimaryColor(primaryColor));
    }

    public InfoDialog setSecondaryColor(int secondaryColor) {
        return (InfoDialog)((Object)super.setSecondaryColor(secondaryColor));
    }

    public InfoDialog setTranslucent(boolean translucent) {
        return (InfoDialog)((Object)super.setTranslucent(translucent));
    }

    public InfoDialog setDimAccount(float dimAccount) {
        return (InfoDialog)((Object)super.setDimAccount(dimAccount));
    }

    public InfoDialog setCancel(boolean cancel) {
        return (InfoDialog)((Object)super.setCancel(cancel));
    }

    public InfoDialog setTouchInOutSideCancel(boolean cancel) {
        return (InfoDialog)((Object)super.setTouchInOutSideCancel(cancel));
    }

    public InfoDialog setDivide(boolean divide) {
        return (InfoDialog)((Object)super.setDivide(divide));
    }

    public InfoDialog setMaterialDesign(boolean materialDesign) {
        return (InfoDialog)((Object)super.setMaterialDesign(materialDesign));
    }

    public InfoDialog setRadiusCard(float radiusCard) {
        return (InfoDialog)((Object)super.setRadiusCard(radiusCard));
    }

    public InfoDialog setOnDialogClickListener(AbsDialogFragment.OnDialogClickListener onDialogClickListener) {
        return (InfoDialog)((Object)super.setOnDialogClickListener(onDialogClickListener));
    }

    public InfoDialog(AppCompatActivity activity) {
        super(activity);
    }

    @Override
    protected int layoutId() {
        return R.layout.dialog_info;
    }

    @Override
    protected void initView() {
        this.tvMessage = (TextView)this.findViewById(R.id.tv_message);
        this.tvPositive = (TextView)this.findViewById(R.id.tv_positive);
        TextView tvNegative = (TextView)this.findViewById(R.id.tv_negative);
        TextView tvTitle = (TextView)this.findViewById(R.id.tv_title);
        Object line_1 = this.findViewById(R.id.line_1);
        Object line_2 = this.findViewById(R.id.line_2);
        this.tvPositive.setOnClickListener((View.OnClickListener)this);
        tvNegative.setOnClickListener((View.OnClickListener)this);
        tvTitle.setTextColor(this.mPrimaryTextColor);
        this.tvMessage.setTextColor(this.mPrimaryTextColor);
        this.tvPositive.setTextColor(this.mSecondaryTextColor);
        tvNegative.setTextColor(this.mSecondaryTextColor);
        if (this.isMaterialDesign) {
            this.setMaterialDesignStyle(tvTitle, this.tvPositive, tvNegative);
        } else {
            this.setUnMaterialDesignStyle(tvTitle, this.tvPositive, tvNegative);
        }
        this.setSingleButtonAndTitleStyle(tvTitle, this.tvPositive, tvNegative, this.mTitle);
        this.setDivideStyle((View)line_1, (View)line_2);
        this.setDiyParamsStyle(tvNegative);
    }

    protected void setMaterialDesignStyle(TextView tvTitle, TextView tvPositive, TextView tvNegative) {
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.ll_button);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, OsHelper.dp2px(36.0f));
        layoutParams.gravity = 0x800005;
        int marginVertical = OsHelper.dp2px(8.0f);
        int marginHorizontal = OsHelper.dp2px(16.0f);
        layoutParams.setMargins(marginHorizontal, marginVertical, marginHorizontal, marginVertical);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.setOrientation(0);
        LinearLayout.LayoutParams positiveParams = new LinearLayout.LayoutParams(-2, -1);
        tvPositive.setLayoutParams((ViewGroup.LayoutParams)positiveParams);
        int paddingHorizontal = OsHelper.dp2px(16.0f);
        tvPositive.setPadding(paddingHorizontal, 0, paddingHorizontal, 0);
        tvPositive.setGravity(17);
        LinearLayout.LayoutParams negativeParams = new LinearLayout.LayoutParams(-2, -1);
        tvNegative.setLayoutParams((ViewGroup.LayoutParams)negativeParams);
        tvNegative.setPadding(paddingHorizontal, 0, paddingHorizontal, 0);
        tvNegative.setGravity(17);
        DrawableHelper.radius(2.0f).pressed(this.mPressedColor).into((View)tvPositive);
        DrawableHelper.radius(2.0f).pressed(this.mPressedColor).into((View)tvNegative);
        tvTitle.setGravity(0x800003);
        this.tvMessage.setGravity(0x800003);
        this.setTitleMargin(tvTitle, 20);
        this.setMessageMargin(8, 24);
        this.mCenterWidth = (int)((double)OsHelper.getDisplayWidth() * 0.9);
    }

    protected void setUnMaterialDesignStyle(TextView tvTitle, TextView tvPositive, TextView tvNegative) {
        tvTitle.setGravity(17);
        this.tvMessage.post(this.mRunnable);
        DrawableHelper.radiusBR(this.mRadiusCard).pressed(this.mPressedColor).into((View)tvPositive);
        DrawableHelper.radiusBL(this.mRadiusCard).pressed(this.mPressedColor).into((View)tvNegative);
        this.setTitleMargin(tvTitle, 24);
        this.setMessageMargin(16, 24);
    }

    protected void setDivideStyle(View line_1, View line_2) {
        int divideColor = this.isDefaultBackground ? R.color.colorDivideDark : 17170443;
        line_1.setVisibility(8);
        line_2.setVisibility(8);
        if (!this.isMaterialDesign && this.isDivide) {
            line_1.setVisibility(0);
            line_2.setVisibility(0);
            line_1.setBackgroundColor(this.getColor(divideColor));
            line_2.setBackgroundColor(this.getColor(divideColor));
        }
    }

    protected void setTitleMargin(TextView tvTitle, int topMargin) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)tvTitle.getLayoutParams();
        layoutParams.leftMargin = OsHelper.dp2px(24.0f);
        layoutParams.topMargin = OsHelper.dp2px(topMargin);
        layoutParams.rightMargin = OsHelper.dp2px(24.0f);
        tvTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void setMessageMargin(int topMargin, int bottomMargin) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.tvMessage.getLayoutParams();
        layoutParams.leftMargin = OsHelper.dp2px(24.0f);
        layoutParams.topMargin = OsHelper.dp2px(topMargin);
        layoutParams.rightMargin = OsHelper.dp2px(24.0f);
        layoutParams.bottomMargin = OsHelper.dp2px(bottomMargin);
        this.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void setSingleButtonAndTitleStyle(TextView tvTitle, TextView tvPositive, TextView tvNegative, String title) {
        if (this.isSingleButton) {
            tvNegative.setVisibility(8);
            if (!this.isMaterialDesign) {
                tvNegative.setVisibility(8);
                DrawableHelper.radiusBL(this.mRadiusCard).radiusBR(this.mRadiusCard).pressed(this.mPrimaryColor, this.mSecondaryColor).textColor(17170443, 17170443).into((View)tvPositive);
                this.setTitleMargin(tvTitle, 32);
                this.setMessageMargin(20, 32);
            }
        }
        if (null == title) {
            if (this.isMaterialDesign) {
                tvTitle.setText((CharSequence)this.getString(R.string.dialog_info));
            } else {
                this.setMessageMargin(40, 36);
                tvTitle.setVisibility(8);
                this.isDivide = true;
            }
        } else {
            tvTitle.setText((CharSequence)title);
        }
        if (this.mTitleIcon != -1 && !this.isMaterialDesign) {
            tvTitle.setVisibility(8);
            ImageView ivTitleIcon = (ImageView)this.findViewById(R.id.iv_title_icon);
            ivTitleIcon.setVisibility(0);
            ivTitleIcon.setImageResource(this.mTitleIcon);
            this.setMessageMargin(16, 24);
        }
    }

    protected void setDiyParamsStyle(TextView tvNegative) {
        if (!TextUtils.isEmpty((CharSequence)this.mMessage)) {
            this.tvMessage.setText((CharSequence)this.mMessage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPositiveButtonText)) {
            this.tvPositive.setText((CharSequence)this.mPositiveButtonText);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mNegativeButtonText)) {
            tvNegative.setText((CharSequence)this.mNegativeButtonText);
        }
        if (this.mPositiveButtonTextColor != -1) {
            this.tvPositive.setTextColor(this.mPositiveButtonTextColor);
        }
        if (this.mNegativeButtonTextColor != -1) {
            tvNegative.setTextColor(this.mNegativeButtonTextColor);
        }
    }

    public void onClick(View view) {
        if (this.mOnDialogClickListener != null) {
            if (view.getId() == R.id.tv_positive) {
                if (this.mOnDialogClickListener.onClick(this, true)) {
                    this.dismiss();
                }
            } else if (view.getId() == R.id.tv_negative) {
                if (this.mOnDialogClickListener == null) {
                    this.dismiss();
                } else if (this.mOnDialogClickListener.onClick(this, false)) {
                    this.dismiss();
                }
            }
        } else {
            this.dismiss();
        }
    }

    public static interface OnInfoClickListener
    extends AbsDialogFragment.OnDialogClickListener<InfoDialog> {
    }
}

