/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.view.EditText;

@SuppressLint(value={"ValidFragment"})
public class EditDialog
extends InfoDialog
implements TextWatcher {
    private EditText editText;

    public static EditDialog newInstance(AppCompatActivity activity) {
        return new EditDialog(activity);
    }

    public EditDialog(AppCompatActivity activity) {
        super(activity);
    }

    @Override
    public String getMessage() {
        return this.editText.getText().toString();
    }

    @Override
    protected void initView() {
        int color2;
        super.initView();
        this.editText = (EditText)((Object)this.findViewById(R.id.et_message));
        this.tvMessage.setVisibility(8);
        this.editText.setVisibility(0);
        if (this.isShowCenter()) {
            this.setEditTextMessageLayoutParams(this.isDivide ? 16 : 8, this.isDivide ? 24 : 16);
        } else {
            this.setEditTextMessageLayoutParams(this.isDivide ? 20 : 16, 32);
        }
        int n = color2 = this.isDefaultBackground ? R.color.colorDivideDark : 17170443;
        if (this.isMaterialDesign || !this.isDivide) {
            this.setEditUnderLineStyle(this.editText, this.getColor(color2));
        } else {
            DrawableHelper.solid(17170445).radius(2.0f).stroke(0.5f, color2).into((View)this.editText);
        }
        this.setEditCursorDrawable(this.editText, this.getColor(color2));
        this.editText.requestFocus();
        this.editText.setHint(R.string.dialog_edit_hint);
        this.editText.setSelection(this.editText.getText().length());
        this.editText.addTextChangedListener(this);
    }

    private void setEditUnderLineStyle(EditText editText, int color2) {
        editText.getBackground().mutate().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    private void setEditCursorDrawable(EditText editText, int color2) {
        GradientDrawable drawable2 = (GradientDrawable)this.mActivity.getDrawable(R.drawable.edit_cursor_drawable);
        assert (drawable2 != null);
        drawable2.setColor(color2);
        drawable2.setSize(OsHelper.dp2px(2.0f), -1);
        editText.setHintTextColor(this.mHintColor);
    }

    private void setEditTextMessageLayoutParams(int topMargin, int bottomMargin) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.editText.getLayoutParams();
        layoutParams.leftMargin = OsHelper.dp2px(20.0f);
        layoutParams.topMargin = OsHelper.dp2px(topMargin);
        layoutParams.rightMargin = OsHelper.dp2px(20.0f);
        layoutParams.bottomMargin = OsHelper.dp2px(bottomMargin);
        this.editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    protected void setSingleButtonAndTitleStyle(TextView tvTitle, TextView tvNegative, TextView tvPositive, String title) {
        super.setSingleButtonAndTitleStyle(tvTitle, tvNegative, tvPositive, title);
        if (title == null) {
            tvTitle.setText((CharSequence)this.getStrings(R.string.dialog_info));
            tvTitle.setVisibility(0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.editText.getText().toString().trim().length() == 0) {
            this.editText.setHint(R.string.dialog_edit_hint);
            this.tvPositive.setEnabled(false);
        } else {
            this.tvPositive.setEnabled(true);
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public static interface OnEditClickListener
    extends AbsDialogFragment.OnDialogClickListener<EditDialog> {
    }
}

