/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.dialog.ViewHolder;

@SuppressLint(value={"ValidFragment"})
public class DialogHelper
extends AbsDialogFragment {
    @LayoutRes
    private int mLayoutId;
    private boolean isUseBinding;
    private OnBindingListener mOnBindingListener;
    private OnConvertViewClickListener onConvertViewClickListener;

    public static DialogHelper newInstance(AppCompatActivity activity) {
        DialogHelper dialogHelper = new DialogHelper(activity);
        return dialogHelper;
    }

    public DialogHelper setOnConvertViewClickListener(OnConvertViewClickListener onConvertViewClickListener) {
        this.onConvertViewClickListener = onConvertViewClickListener;
        return this;
    }

    public DialogHelper setOnBindingListener(OnBindingListener onBindingListener) {
        this.mOnBindingListener = onBindingListener;
        return this;
    }

    public DialogHelper setLayout(@LayoutRes int layoutId) {
        this.mLayoutId = layoutId;
        return this;
    }

    public DialogHelper setUseDataBinding(boolean useBinding) {
        this.isUseBinding = useBinding;
        return this;
    }

    public DialogHelper(AppCompatActivity activity) {
        super(activity);
    }

    public DialogHelper setMargin(int margin) {
        return (DialogHelper)((Object)super.setMargin(margin));
    }

    public DialogHelper setGravity(int gravity) {
        return (DialogHelper)((Object)super.setGravity(gravity));
    }

    public DialogHelper setAnimator(int animator) {
        return (DialogHelper)((Object)super.setAnimator(animator));
    }

    public DialogHelper setBackground(Drawable background) {
        return (DialogHelper)((Object)super.setBackground(background));
    }

    public DialogHelper setCenterWidth(int width) {
        return (DialogHelper)((Object)super.setCenterWidth(width));
    }

    public DialogHelper setTranslucent(boolean translucent) {
        return (DialogHelper)((Object)super.setTranslucent(translucent));
    }

    public DialogHelper setCancel(boolean cancel) {
        return (DialogHelper)((Object)super.setCancel(cancel));
    }

    public DialogHelper setTouchInOutSideCancel(boolean cancel) {
        return (DialogHelper)((Object)super.setTouchInOutSideCancel(cancel));
    }

    public DialogHelper setRadiusCard(float radiusCard) {
        return (DialogHelper)((Object)super.setRadiusCard(radiusCard));
    }

    @Override
    protected boolean isUseViewHolder() {
        return true;
    }

    @Override
    protected int layoutId() {
        return this.mLayoutId;
    }

    @Override
    protected void convertView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.isUseBinding) {
            ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)this.layoutId(), (ViewGroup)container, (boolean)false);
            this.mView = binding.getRoot();
            if (this.mOnBindingListener != null) {
                this.mOnBindingListener.onBinding(binding, this);
            }
        } else {
            ViewHolder holder = ViewHolder.create(this.mView);
            if (this.onConvertViewClickListener != null) {
                this.onConvertViewClickListener.onConvertClick(holder, this);
            }
        }
    }

    public static interface OnConvertViewClickListener<T extends AbsDialogFragment> {
        public void onConvertClick(ViewHolder var1, T var2);
    }

    public static interface OnBindingListener<T extends AbsDialogFragment> {
        public void onBinding(ViewDataBinding var1, T var2);
    }
}

