/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.date.DateHelper;
import com.dzenm.helper.dialog.PickerDialog;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.view.PickerView;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@SuppressLint(value={"ValidFragment"})
public class DatePickerDialog
extends PickerDialog {
    public static final String DEFAULT_START_YEAR = "1970";
    public static final String DEFAULT_END_YEAR = "2100";
    private int mMinDay = 1;
    private int mJanuary = 1;
    private int mDecember = 12;
    private String mSeparator = "/";
    private int mStartYear;
    private int mStartMonth;
    private int mStartDay;
    private int mEndYear;
    private int mEndMonth;
    private int mEndDay;
    private Calendar mStartCalendar = Calendar.getInstance();
    private Calendar mEndCalendar = Calendar.getInstance();
    private Calendar mSelectCalendar;

    public static DatePickerDialog newInstance(AppCompatActivity activity) {
        return new DatePickerDialog(activity);
    }

    public DatePickerDialog setSeparator(String separator) {
        this.mSeparator = separator;
        return this;
    }

    public DatePickerDialog setRange(String startDate, String endDate) {
        this.mStartCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), startDate));
        this.mEndCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), endDate));
        return this;
    }

    public DatePickerDialog setRange(int startDateResId, int endDateResId) {
        this.mStartCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), this.getStrings(startDateResId)));
        this.mEndCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), this.getStrings(endDateResId)));
        return this;
    }

    public DatePickerDialog setTitle(int resId) {
        return (DatePickerDialog)super.setTitle(resId);
    }

    public DatePickerDialog setTitle(String title) {
        return (DatePickerDialog)super.setTitle(title);
    }

    public DatePickerDialog setLoop(boolean loop) {
        return (DatePickerDialog)super.setLoop(loop);
    }

    public DatePickerDialog setSelected(int resId) {
        return (DatePickerDialog)super.setSelected(resId);
    }

    public DatePickerDialog setSelected(String date) {
        return (DatePickerDialog)super.setSelected(date);
    }

    public DatePickerDialog setMargin(int margin) {
        return (DatePickerDialog)super.setMargin(margin);
    }

    public DatePickerDialog setGravity(int gravity) {
        return (DatePickerDialog)super.setGravity(gravity);
    }

    public DatePickerDialog setAnimator(int animator) {
        return (DatePickerDialog)super.setAnimator(animator);
    }

    public DatePickerDialog setBackground(Drawable background) {
        return (DatePickerDialog)super.setBackground(background);
    }

    public DatePickerDialog setCenterWidth(int width) {
        return (DatePickerDialog)super.setCenterWidth(width);
    }

    public DatePickerDialog setPrimaryColor(int primaryColor) {
        return (DatePickerDialog)super.setPrimaryColor(primaryColor);
    }

    public DatePickerDialog setSecondaryColor(int secondaryColor) {
        return (DatePickerDialog)super.setSecondaryColor(secondaryColor);
    }

    public DatePickerDialog setTranslucent(boolean translucent) {
        return (DatePickerDialog)super.setTranslucent(translucent);
    }

    public DatePickerDialog setCancel(boolean cancel) {
        return (DatePickerDialog)super.setCancel(cancel);
    }

    public DatePickerDialog setTouchInOutSideCancel(boolean cancel) {
        return (DatePickerDialog)super.setTouchInOutSideCancel(cancel);
    }

    public DatePickerDialog setDivide(boolean divide) {
        return (DatePickerDialog)super.setDivide(divide);
    }

    public DatePickerDialog setRadiusCard(float radiusCard) {
        return (DatePickerDialog)super.setRadiusCard(radiusCard);
    }

    public DatePickerDialog(AppCompatActivity activity) {
        super(activity);
        this.mStartCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), DEFAULT_START_YEAR + this.mSeparator + this.mJanuary + this.mSeparator + this.mMinDay));
        this.mEndCalendar.setTime(DateHelper.parseDate(DateHelper.pattern(this.mSeparator), DEFAULT_END_YEAR + this.mSeparator + this.mJanuary + this.mSeparator + this.mMinDay));
        this.mSelectCalendar = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.mData = new String[3];
        this.mData[0] = String.valueOf(calendar.get(1));
        this.mData[1] = String.valueOf(calendar.get(2) + 1);
        this.mData[2] = String.valueOf(calendar.get(5));
    }

    @Override
    protected void initialViewData() {
        if (!TextUtils.isEmpty((CharSequence)this.mSelectedData)) {
            this.mData = this.mSelectedData.split(this.mSeparator);
            for (int i = 0; i < this.mData.length; ++i) {
                this.mData[i] = String.valueOf(Integer.parseInt(this.mData[i]));
            }
        }
    }

    @Override
    protected void setPickerViewArrayList() {
        super.setPickerViewArrayList();
        this.mStartYear = this.mStartCalendar.get(1);
        this.mEndYear = this.mEndCalendar.get(1);
        this.mStartMonth = this.mStartCalendar.get(2) + 1;
        this.mEndMonth = this.mEndCalendar.get(2) + 1;
        this.mStartDay = this.mStartCalendar.get(5);
        this.mEndDay = this.mEndCalendar.get(5);
        if (this.mStartYear > this.mEndYear) {
            throw new NullPointerException("\u8d77\u59cb\u65f6\u95f4\u5e74\u4efd\u548c\u7ed3\u5c3e\u65f6\u95f4\u5e74\u4efd\u987a\u5e8f\u9519\u4e71");
        }
        this.getDataList(this.mPrimaryList, this.mStartYear, this.mEndYear);
        this.mSelectCalendar.set(1, Integer.parseInt(this.mData[0]));
        this.mSelectCalendar.set(2, Integer.parseInt(this.mData[1]) - 1);
        this.mSelectCalendar.set(5, Integer.parseInt(this.mData[2]));
        Logger.i("\u9ed8\u8ba4\u9009\u4e2d\u7684\u65e5\u671f: " + this.mData[0] + this.mSeparator + this.mData[1] + this.mSeparator + this.mData[2]);
        int year = this.mSelectCalendar.get(1);
        int month = this.mSelectCalendar.get(2) + 1;
        if (this.mStartYear == year) {
            this.getDataList(this.mSecondaryList, this.mStartMonth, this.mDecember);
            if (this.mStartMonth == month) {
                this.getDataList(this.mUnitList, this.mStartDay, this.mSelectCalendar.getActualMaximum(5));
            } else {
                this.getDataList(this.mUnitList, this.mMinDay, this.mSelectCalendar.getActualMaximum(5));
            }
        } else if (this.mEndYear == year) {
            this.getDataList(this.mSecondaryList, this.mJanuary, this.mEndMonth);
            if (this.mEndMonth == month) {
                this.getDataList(this.mUnitList, this.mMinDay, this.mEndDay);
            } else {
                this.getDataList(this.mUnitList, this.mMinDay, this.mSelectCalendar.getActualMaximum(5));
            }
        } else {
            this.getDataList(this.mSecondaryList, this.mJanuary, this.mDecember);
            this.getDataList(this.mUnitList, this.mMinDay, this.mSelectCalendar.getActualMaximum(5));
        }
    }

    private void getDataList(List<String> list, int start, int end) {
        list.clear();
        Logger.i("\u8d77\u70b9: " + DateHelper.formatUnit(start) + ", \u7ec8\u70b9: " + DateHelper.formatUnit(end));
        for (int i = start; i <= end; ++i) {
            list.add(DateHelper.formatUnit(i));
        }
    }

    @Override
    protected void setSelectedData() {
        this.pvPrimary.setSelected(DateHelper.formatUnit(this.mData[0]));
        this.pvSecondary.setSelected(DateHelper.formatUnit(this.mData[1]));
        this.pvUnit.setSelected(DateHelper.formatUnit(this.mData[2]));
    }

    @Override
    protected String getSelected() {
        return this.pvPrimary.getSelected() + this.mSeparator + this.pvSecondary.getSelected() + this.mSeparator + this.pvUnit.getSelected();
    }

    @Override
    public void onSelect(PickerView pickerView) {
        String text = pickerView.getSelected();
        if (pickerView.getId() == R.id.pv_primary) {
            this.mSelectCalendar.set(1, Integer.parseInt(text));
            this.resetMonthList();
        } else if (pickerView.getId() == R.id.pv_secondary) {
            this.mSelectCalendar.set(2, Integer.valueOf(text) - 1);
            this.resetDayList();
        } else if (pickerView.getId() == R.id.pv_unit) {
            this.mOnSelectedCallback.onFinish();
        }
    }

    private void resetMonthList() {
        int selectedYear = this.mSelectCalendar.get(1);
        if (selectedYear == this.mStartYear) {
            this.getDataList(this.mSecondaryList, this.mStartMonth, this.mDecember);
        } else if (selectedYear == this.mEndYear) {
            this.getDataList(this.mSecondaryList, this.mJanuary, this.mEndMonth);
        } else {
            this.getDataList(this.mSecondaryList, this.mJanuary, this.mDecember);
        }
        this.pvSecondary.setData(this.mSecondaryList);
        this.pvSecondary.setSelected(0);
        Logger.i("\u9009\u4e2d\u7684\u6708\u4efd\u6570\u636e: " + Integer.parseInt((String)this.mSecondaryList.get(0)));
        this.mSelectCalendar.set(2, Integer.parseInt((String)this.mSecondaryList.get(0)) - 1);
        this.executeAnimator(this.pvSecondary);
        this.pvSecondary.postDelayed(new Runnable(){

            @Override
            public void run() {
                DatePickerDialog.this.resetDayList();
            }
        }, 100L);
    }

    private void resetDayList() {
        int selectedYear = this.mSelectCalendar.get(1);
        int selectedMonth = this.mSelectCalendar.get(2) + 1;
        if (selectedYear == this.mStartYear && selectedMonth == this.mStartMonth) {
            this.getDataList(this.mUnitList, this.mStartDay, this.mSelectCalendar.getActualMaximum(5));
        } else if (selectedYear == this.mEndYear && selectedMonth == this.mEndMonth) {
            this.getDataList(this.mUnitList, this.mMinDay, this.mEndDay);
        } else {
            this.getDataList(this.mUnitList, this.mMinDay, this.mSelectCalendar.getActualMaximum(5));
        }
        this.pvUnit.setData(this.mUnitList);
        this.pvUnit.setSelected(0);
        Logger.i("\u9009\u4e2d\u7684\u65e5\u671f: " + Integer.parseInt((String)this.mUnitList.get(0)));
        this.mSelectCalendar.set(5, Integer.parseInt((String)this.mUnitList.get(0)));
        this.executeAnimator(this.pvUnit);
    }
}

