/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.app.AppCompatDialogFragment;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AnimatorHelper;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;

public abstract class AbsDialogFragment
extends AppCompatDialogFragment {
    protected static final float DEFAULT_RADIUS = 8.0f;
    protected static final float MATERIAL_RADIUS = 2.0f;
    protected AppCompatActivity mActivity;
    protected View mView;
    protected Drawable mBackground = DrawableHelper.solid(17170443).radius(8.0f).build();
    protected int mMargin = OsHelper.dp2px(10.0f);
    protected int mCenterWidth = OsHelper.getDisplayWidth() - 10 * this.mMargin;
    protected int mGravity = 17;
    protected int mAnimator = AnimatorHelper.shrink();
    protected int mPrimaryColor = R.color.colorDarkBlue;
    protected int mSecondaryColor = R.color.colorTranslucentDarkBlue;
    protected float mDimAccount = -1.0f;
    private boolean isTouchInOutSideCancel = false;
    protected int mPrimaryTextColor;
    protected int mSecondaryTextColor;
    protected int mHintColor;
    protected int mDivideColor;
    protected int mPressedColor;
    protected float mRadiusCard = 8.0f;
    protected boolean isDivide = false;
    protected boolean isMaterialDesign = false;
    protected boolean isDefaultBackground = true;
    protected boolean isDefaultGravity = true;
    protected boolean isDefaultMargin = true;
    protected boolean isDefaultAnimator = true;
    protected OnDialogClickListener mOnDialogClickListener;

    public <T extends AbsDialogFragment> T setMargin(int margin) {
        this.mMargin = OsHelper.dp2px(margin);
        this.isDefaultMargin = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setGravity(int gravity) {
        this.mGravity = gravity;
        this.isDefaultGravity = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setAnimator(int animator) {
        this.mAnimator = animator;
        this.isDefaultAnimator = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setBackground(Drawable background) {
        this.mBackground = background;
        this.isDefaultBackground = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setBackgroundRectangle() {
        this.setBackground(DrawableHelper.solid(17170443).build());
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setCenterWidth(int width) {
        this.mCenterWidth = width;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setPrimaryColor(int primaryColor) {
        this.mPrimaryColor = primaryColor;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setSecondaryColor(int secondaryColor) {
        this.mSecondaryColor = secondaryColor;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setTranslucent(boolean translucent) {
        this.mDimAccount = 0.0f;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setDimAccount(float dimAccount) {
        this.mDimAccount = dimAccount;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setOnDialogClickListener(OnDialogClickListener onDialogClickListener) {
        this.mOnDialogClickListener = onDialogClickListener;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setCancel(boolean cancel) {
        this.setCancelable(cancel);
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setTouchInOutSideCancel(boolean cancel) {
        this.isTouchInOutSideCancel = cancel;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setDivide(boolean divide) {
        this.isDivide = divide;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setMaterialDesign(boolean materialDesign) {
        this.isMaterialDesign = materialDesign;
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T setRadiusCard(float radiusCard) {
        this.mRadiusCard = radiusCard;
        if (this.isDefaultBackground) {
            this.mBackground = DrawableHelper.solid(17170443).radius(radiusCard).build();
        }
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T show() {
        this.show(AbsDialogFragment.class.getSimpleName());
        return (T)((Object)this);
    }

    public <T extends AbsDialogFragment> T show(String tag) {
        this.show(this.mActivity.getSupportFragmentManager(), tag);
        return (T)((Object)this);
    }

    public AbsDialogFragment() {
    }

    public AbsDialogFragment(AppCompatActivity activity) {
        this.mActivity = activity;
    }

    protected int layoutId() {
        return -1;
    }

    protected boolean isUseViewHolder() {
        return false;
    }

    protected void convertView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState2) {
    }

    protected void initView() {
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, this.isFullScreen() ? R.style.FullScreenTheme : R.style.AbsFragmentTheme);
    }

    protected boolean isFullScreen() {
        return false;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(1);
        if (this.layoutId() != -1) {
            this.mView = inflater.inflate(this.layoutId(), null);
        }
        this.setDefaultTextColor();
        if (this.isMaterialDesign) {
            this.mRadiusCard = 2.0f;
            if (this.isDefaultBackground) {
                this.mBackground = DrawableHelper.solid(17170443).radius(this.mRadiusCard).build();
            }
        }
        if (this.isUseViewHolder()) {
            this.convertView(inflater, container, savedInstanceState);
        } else {
            this.initView();
        }
        return this.mView;
    }

    private void setDefaultTextColor() {
        this.mPrimaryTextColor = this.getColor(this.isDefaultBackground ? R.color.colorPrimaryTextDark : R.color.colorPrimaryTextLight);
        this.mSecondaryTextColor = this.getColor(this.isDefaultBackground ? R.color.colorSecondaryTextDark : R.color.colorSecondaryTextLight);
        this.mHintColor = this.getColor(this.isDefaultBackground ? R.color.colorHintTextDark : R.color.colorHintTextLight);
        this.mDivideColor = this.getColor(this.isDefaultBackground ? R.color.colorDivideDark : R.color.colorDivideLight);
        this.mPressedColor = this.isDefaultBackground ? R.color.colorLightGray : R.color.colorTranslucentLightGray;
    }

    public <T extends View> T findViewById(@IdRes int id2) {
        return (T)this.mView.findViewById(id2);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        if (this.getDialog() != null) {
            try {
                this.getDialog().setOnShowListener(null);
                this.getDialog().setOnDismissListener(null);
                this.getDialog().setOnCancelListener(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onStart() {
        super.onStart();
        this.initializeDialogParams();
    }

    private void initializeDialogParams() {
        this.setDialogMargin(this.mView);
        this.setAnimatorStyle();
        this.setWindowProperty(this.getWindow());
    }

    private void setDialogMargin(View decorView) {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)decorView.getLayoutParams();
        this.setLayoutParams(layoutParams);
        decorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void setLayoutParams(ViewGroup.MarginLayoutParams layoutParams) {
        if (this.isFullScreen()) {
            layoutParams.width = OsHelper.getDisplayWidth();
        } else if (this.isShowCenter()) {
            layoutParams.width = this.mCenterWidth;
        } else {
            layoutParams.topMargin = 2 * this.mMargin;
            layoutParams.bottomMargin = this.mMargin;
            layoutParams.width = OsHelper.getDisplayWidth() - 2 * this.mMargin;
        }
    }

    protected void setAnimatorStyle() {
        if (this.isDefaultAnimator) {
            if (this.mGravity == 48) {
                this.mAnimator = AnimatorHelper.top();
            } else if (this.mGravity == 80) {
                this.mAnimator = AnimatorHelper.bottom();
            }
        }
    }

    protected void setWindowProperty(Window window) {
        this.getDialog().setCanceledOnTouchOutside(this.isTouchInOutSideCancel);
        WindowManager.LayoutParams attributes = window.getAttributes();
        this.setDialogGravity(attributes);
        window.setAttributes(attributes);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(this.getColor(17170445)));
        window.setWindowAnimations(this.mAnimator);
        this.mView.setBackground(this.mBackground);
        window.clearFlags(131080);
        window.setSoftInputMode(2);
        if (this.isFullScreen()) {
            window.setLayout(-1, OsHelper.getDisplayHeight((Activity)this.mActivity));
        }
        if (this.mDimAccount != -1.0f) {
            window.setDimAmount(this.mDimAccount);
        }
    }

    protected Window getWindow() {
        Dialog dialog = this.getDialog();
        if (dialog == null) {
            return this.mActivity.getWindow();
        }
        Window window = this.getDialog().getWindow();
        if (window == null) {
            return this.mActivity.getWindow();
        }
        return window;
    }

    protected void setDialogGravity(WindowManager.LayoutParams layoutParams) {
        layoutParams.gravity = this.mGravity;
    }

    protected boolean isShowCenter() {
        return this.mGravity == 17;
    }

    protected String getStrings(int id2) {
        return this.mActivity.getResources().getString(id2);
    }

    protected int getColor(int id2) {
        return this.mActivity.getResources().getColor(id2);
    }

    protected float getDimension(int id2) {
        return this.mActivity.getResources().getDimension(id2);
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }

    public static interface OnDialogClickListener<T extends AbsDialogFragment> {
        public boolean onClick(T var1, boolean var2);
    }
}

