/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.app.AppCompatDialog;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AnimatorHelper;
import com.dzenm.helper.draw.DrawableHelper;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.os.ScreenHelper;

public abstract class AbsDialog
extends AppCompatDialog {
    protected static final float DEFAULT_RADIUS = 8.0f;
    protected View mView;
    protected Drawable mBackground = DrawableHelper.radius(8.0f).build();
    protected int mMargin = OsHelper.dp2px(10.0f);
    protected int mCenterWidth = OsHelper.getDisplayWidth() - 10 * this.mMargin;
    protected int mGravity = 17;
    protected int mAnimator = AnimatorHelper.shrink();
    protected int mPrimaryColor = R.color.colorDarkBlue;
    protected int mSecondaryColor = R.color.colorTranslucentDarkBlue;
    protected boolean isTranslucent = false;
    private boolean isTouchInOutSideCancel = false;
    protected float mRadiusCard = 8.0f;
    protected boolean isDivide = false;
    protected boolean isDefaultBackground = true;
    protected boolean isDefaultGravity = true;
    protected boolean isDefaultMargin = true;
    protected boolean isDefaultAnimator = true;
    protected OnDialogClickListener mOnDialogClickListener;

    public <T extends AbsDialog> T setMargin(int margin) {
        this.mMargin = margin;
        this.isDefaultMargin = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setGravity(int gravity) {
        this.mGravity = gravity;
        this.isDefaultGravity = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setAnimator(int animator) {
        this.mAnimator = animator;
        this.isDefaultAnimator = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setBackground(Drawable background) {
        this.mBackground = background;
        this.isDefaultBackground = false;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setBackgroundRectangle() {
        this.setBackground(DrawableHelper.solid(17170443).build());
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setTranslucent(boolean translucent) {
        this.isTranslucent = translucent;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setCancel(boolean cancel) {
        this.setCancelable(cancel);
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setTouchOutsideCancel(boolean cancel) {
        this.setCanceledOnTouchOutside(cancel);
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setDivide(boolean divide) {
        this.isDivide = divide;
        return (T)((Object)this);
    }

    public <T extends AbsDialog> T setOnDialogClickListener(OnDialogClickListener onDialogClickListener) {
        this.mOnDialogClickListener = onDialogClickListener;
        return (T)((Object)this);
    }

    public void show() {
        Window window = this.getWindow();
        this.setDialogSize(window);
        this.setStyle();
        this.setWindowProperty(window);
        super.show();
        this.afterShowSetting(window);
    }

    public AbsDialog(@NonNull Context context) {
        this(context, R.style.BaseDialog);
    }

    public AbsDialog(Context context, int theme) {
        super(context, theme);
        this.setCanceledOnTouchOutside(false);
        this.create();
    }

    protected int layoutId() {
        return 0;
    }

    protected void initView() {
    }

    protected void setStyle() {
        if (this.isDefaultMargin) {
            if (this.mGravity == 48) {
                if (this.isDefaultBackground) {
                    this.mBackground = DrawableHelper.radiusBR(8.0f).radiusBL(8.0f).build();
                }
            } else if (this.mGravity == 80 && this.isDefaultBackground) {
                this.mBackground = DrawableHelper.radiusTL(8.0f).radiusTR(8.0f).build();
            }
        }
        if (this.isDefaultAnimator) {
            if (this.mGravity == 48) {
                this.mAnimator = AnimatorHelper.top();
            } else if (this.mGravity == 80) {
                this.mAnimator = AnimatorHelper.bottom();
            }
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.layoutId() != 0) {
            this.mView = LayoutInflater.from((Context)this.getContext()).inflate(this.layoutId(), null);
            this.setContentView(this.mView);
        }
        this.initView();
    }

    public <T extends View> T findViewById(@IdRes int id2) {
        return (T)this.mView.findViewById(id2);
    }

    private void setDialogSize(Window window) {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mView.getLayoutParams();
        window.setLayout(-2, -2);
        WindowManager.LayoutParams windowAttributes = window.getAttributes();
        if (this.isShowCenter()) {
            this.setCenterDialogLayoutParams(windowAttributes);
        } else {
            this.setDialogLayoutParams(layoutParams);
            this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        window.setAttributes(windowAttributes);
    }

    protected void setDialogLayoutParams(ViewGroup.MarginLayoutParams layoutParams) {
        layoutParams.topMargin = OsHelper.dp2px(this.mMargin);
        layoutParams.bottomMargin = OsHelper.dp2px(this.mMargin);
        layoutParams.width = ScreenHelper.getWidth() - 2 * OsHelper.dp2px(this.mMargin);
    }

    protected void setCenterDialogLayoutParams(WindowManager.LayoutParams windowAttributes) {
        if (!this.isPromptDialog()) {
            windowAttributes.width = ScreenHelper.getWidth() - 10 * OsHelper.dp2px(this.mMargin);
        }
    }

    protected boolean isPromptDialog() {
        return false;
    }

    protected void setWindowProperty(Window window) {
        window.setGravity(this.mGravity);
        window.setWindowAnimations(this.mAnimator);
        this.mView.setBackground(this.mBackground);
    }

    protected void afterShowSetting(Window window) {
        window.clearFlags(131080);
        window.setSoftInputMode(2);
        if (this.isTranslucent) {
            if (Build.VERSION.SDK_INT > 14) {
                window.setDimAmount(0.0f);
            } else {
                window.clearFlags(2);
            }
        }
    }

    protected String getString(int id2) {
        return this.getContext().getResources().getString(id2);
    }

    protected int getColor(int id2) {
        return this.getContext().getResources().getColor(id2);
    }

    protected boolean isShowCenter() {
        return this.mGravity == 17;
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }

    public static interface OnDialogClickListener<T extends AbsDialog> {
        public boolean onClick(T var1, boolean var2);
    }
}

