/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import java.util.ArrayList;
import java.util.List;

public class FragmentHelper {
    private AppCompatActivity mActivity;
    private Fragment mFragment;
    private List<Fragment> mFragments;
    private int mResourceID;

    public static FragmentHelper newInstance() {
        return new FragmentHelper();
    }

    public FragmentHelper with(AppCompatActivity activity) {
        this.mActivity = activity;
        return this;
    }

    public FragmentHelper with(Fragment fragment) {
        this.mFragment = fragment;
        return this;
    }

    public FragmentHelper container(int resourceID) {
        this.mResourceID = resourceID;
        return this;
    }

    public void addToStack(@NonNull List<Fragment> fragments) {
        this.mFragments = new ArrayList<Fragment>();
        FragmentTransaction transaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        for (Fragment f : fragments) {
            if (f.isAdded()) continue;
            this.mFragments.add(f);
            transaction.add(this.mResourceID, f).hide(f);
        }
        transaction.commitAllowingStateLoss();
    }

    public int size() {
        return this.mFragments.size();
    }

    public Fragment get(int position) {
        return this.mFragments.get(position);
    }

    public void show(Fragment currentFragment) {
        FragmentTransaction transaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isShow(i) && this.get(i) != currentFragment) {
                transaction.hide(this.get(i));
                continue;
            }
            transaction.show(currentFragment);
        }
        transaction.commitAllowingStateLoss();
    }

    public void showChild(Fragment currentFragment) {
        FragmentTransaction transaction = this.mFragment.getChildFragmentManager().beginTransaction();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isShow(i) && this.get(i) != currentFragment) {
                transaction.hide(this.get(i));
                continue;
            }
            transaction.show(currentFragment);
        }
        transaction.commitAllowingStateLoss();
    }

    private boolean isShow(int position) {
        return this.get(position).isAdded() && (this.get(position).isVisible() || !this.get(position).isHidden());
    }

    public FragmentHelper hide() {
        FragmentTransaction transaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isShow(i)) continue;
            transaction.hide(this.get(i));
        }
        transaction.commitAllowingStateLoss();
        return this;
    }
}

