/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareUltralight;
import android.widget.TextView;
import com.dzenm.helper.base.AbsBaseActivity;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.log.Logger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;

public abstract class AbsNfcActivity
extends AbsBaseActivity {
    private static final boolean isDebug = true;
    private static final boolean isAppend = false;
    private static final boolean isShowDialog = false;
    protected TextView mTextView;
    private NfcAdapter mNfcAdapter;
    protected Tag mTag;
    private PendingIntent mPendingIntent;
    @SuppressLint(value={"SimpleDateFormat"})
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    protected void onStart() {
        super.onStart();
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        this.mPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, this.getClass()).addFlags(0x20000000), (int)0);
    }

    protected void onResume() {
        super.onResume();
        this.isNfcAvailable(this.mNfcAdapter);
    }

    private void isNfcAvailable(NfcAdapter nfcAdapter) {
        if (nfcAdapter == null) {
            this.unavailableNfc();
        } else {
            this.availableNfc(nfcAdapter);
        }
    }

    protected void unavailableNfc() {
        this.log("\u8be5\u8bbe\u5907\u4e0d\u652f\u6301\u652f\u6301NFC\u529f\u80fd");
    }

    protected void availableNfc(NfcAdapter nfcAdapter) {
        this.log("\u8be5\u8bbe\u5907\u652f\u6301NFC");
        if (!nfcAdapter.isEnabled()) {
            this.getDefaultDialogSetting("NFC\u529f\u80fd\u672a\u6253\u5f00, \u4e0d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd, \u8bf7\u8fdb\u5165NFC\u8bbe\u7f6e\u9875\u9762\u624b\u52a8\u6253\u5f00?").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

                @Override
                public boolean onClick(InfoDialog infoDialog, boolean b) {
                    if (b) {
                        Intent intent = new Intent("android.settings.NFC_SETTINGS");
                        AbsNfcActivity.this.startActivity(intent);
                    } else {
                        AbsNfcActivity.this.finish();
                    }
                    return true;
                }
            }).show();
        } else {
            this.log("\u8bf7\u5c06NFC\u8bbe\u5907\u9760\u8fd1\u624b\u673a\u80cc\u9762");
            nfcAdapter.enableForegroundDispatch((Activity)this, this.mPendingIntent, null, (String[][])null);
        }
    }

    protected void onNewIntent(Intent intent) {
        this.mTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        String uid = this.byteArrayToHex(this.mTag.getId());
        this.getNfcUid(uid);
    }

    protected String byteArrayToHex(byte[] bytes) {
        String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        String out = "";
        for (byte aByte : bytes) {
            int in = aByte & 0xFF;
            int i = in >> 4 & 0xF;
            out = out + hex[i];
            i = in & 0xF;
            out = out + hex[i];
        }
        return out;
    }

    protected void getNfcUid(String uid) {
    }

    protected void onPause() {
        super.onPause();
        if (this.mNfcAdapter != null) {
            this.mNfcAdapter.disableForegroundDispatch((Activity)this);
        }
    }

    protected String parseTextRecord(NdefRecord ndefRecord) {
        if (ndefRecord.getTnf() != 1) {
            this.log("\u4e0d\u652f\u6301NDEF\u683c\u5f0f");
            return null;
        }
        if (!Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
            this.log("Nfc\u5185\u5b58\u7a7a\u95f4\u4e0d\u8db3");
            return null;
        }
        try {
            byte[] payload = ndefRecord.getPayload();
            String textEncoding = (payload[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
            int languageCodeLength = payload[0] & 0x3F;
            String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
            return new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    protected void isExistMifareUltralight() {
        boolean hasMifareUltralight = false;
        String[] techList = this.mTag.getTechList();
        this.log("tech list is: " + techList.length);
        for (String tech : techList) {
            if (tech.indexOf("MifareUltralight") < 0) continue;
            hasMifareUltralight = true;
            break;
        }
        if (!hasMifareUltralight) {
            this.log("\u4e0d\u652f\u6301MifareUltralight\u7684\u6570\u636e\u683c\u5f0f");
            return;
        }
        this.log("\u652f\u6301MifareUltralight\u7684\u6570\u636e\u683c\u5f0f");
    }

    protected String readMifareUltralightData() {
        MifareUltralight mifareUltralight = MifareUltralight.get((Tag)this.mTag);
        try {
            mifareUltralight.connect();
            byte[] bytes = mifareUltralight.readPages(4);
            mifareUltralight.close();
            return new String(bytes, Charset.forName("GB2312"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void writeMifareUltralightData(String data) {
        if (data.length() < 22) {
            this.log("\u5185\u5b58\u7a7a\u95f4\u4e0d\u8db3");
            return;
        }
        MifareUltralight mifareUltralight = MifareUltralight.get((Tag)this.mTag);
        try {
            mifareUltralight.connect();
            for (int i = 0; i < data.length(); i += 2) {
                String s = data.substring(i, i + 2);
                byte[] datas = s.getBytes(Charset.forName("GB2312"));
                mifareUltralight.writePage(4 + i, datas);
            }
            this.log("\u5199\u5165\u6210\u529f");
            mifareUltralight.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void showDialog(String message) {
        this.getDefaultDialogSetting(message).setButtonText("\u786e\u5b9a").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                return true;
            }
        }).show();
    }

    private InfoDialog getDefaultDialogSetting(String message) {
        return InfoDialog.newInstance(this).setTitle("").setMessage(message);
    }

    protected void log(String text) {
        Logger.d(this.getTime() + ": " + text + "\n");
        if (this.mTextView == null) {
            return;
        }
        this.mTextView.setText((CharSequence)text);
    }

    protected String getTime() {
        return this.simpleDateFormat.format(System.currentTimeMillis());
    }
}

