/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.fragment.app.Fragment;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.StatusBarHelper;

public abstract class AbsBaseFragment<A extends Activity>
extends Fragment {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName() + "| ";
    protected A mActivity;
    protected View mRootView;

    protected int layoutId() {
        return -1;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        Logger.d(this.TAG + "onAttach");
        this.mActivity = this.requireActivity();
    }

    public A getAttachActivity() {
        return this.mActivity;
    }

    private View inflaterView(@Nullable LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.layoutId() != -1 && inflater != null) {
            if (this.isDataBinding()) {
                ViewDataBinding v = DataBindingUtil.inflate((LayoutInflater)inflater, (int)this.layoutId(), (ViewGroup)container, (boolean)false);
                this.mRootView = v.getRoot();
                this.initializeView(savedInstanceState, v);
            } else {
                this.mRootView = inflater.inflate(this.layoutId(), container, false);
                this.initializeView(savedInstanceState, null);
            }
        }
        return this.mRootView;
    }

    protected boolean isDataBinding() {
        return false;
    }

    public void initializeView(@Nullable Bundle savedInstanceState, @Nullable ViewDataBinding viewDataBinding) {
    }

    public void setToolbar(Toolbar toolbar) {
        if (toolbar == null) {
            return;
        }
        AppCompatActivity activity = (AppCompatActivity)this.mActivity;
        activity.setSupportActionBar(toolbar);
    }

    public void setToolbarWithImmersiveStatusBar(Toolbar toolbar, @ColorRes int color2) {
        this.setToolbar(toolbar);
        StatusBarHelper.setFragmentToolbarColor(this.mActivity, toolbar, color2);
    }

    public void setToolbarWithGradientStatusBar(Toolbar toolbar, Drawable drawable2) {
        this.setToolbar(toolbar);
        toolbar.setBackground(drawable2);
        StatusBarHelper.setDrawable(this.mActivity, drawable2);
    }

    @Nullable
    public View onCreateView(@Nullable LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.logD(this.TAG + "onCreateView");
        return this.inflaterView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.logD(this.TAG + "onViewCreated");
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.logD(this.TAG + "onActivityCreated");
    }

    protected <T extends View> T findViewById(int id2) {
        return (T)this.mRootView.findViewById(id2);
    }

    protected void startActivity(Class clazz) {
        Intent intent = new Intent(this.mActivity, clazz);
        this.startActivity(intent);
    }

    public void logV(String msg) {
        Logger.v(this.TAG + msg);
    }

    public void logD(String msg) {
        Logger.d(this.TAG + msg);
    }

    public void logI(String msg) {
        Logger.i(this.TAG + msg);
    }

    public void logW(String msg) {
        Logger.w(this.TAG + msg);
    }

    public void logE(String msg) {
        Logger.e(this.TAG + msg);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mRootView = null;
    }
}

