/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.drawerlayout.widget.DrawerLayout;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.PromptDialog;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.net.NetHelper;
import com.dzenm.helper.os.ActivityHelper;
import com.dzenm.helper.os.ScreenHelper;
import com.dzenm.helper.os.StatusBarHelper;
import com.dzenm.helper.permission.PermissionManager;
import com.dzenm.helper.photo.PhotoHelper;

public abstract class AbsBaseActivity
extends AppCompatActivity
implements NetHelper.OnNetworkChangeListener {
    private final String TAG = this.getClass().getSimpleName() + "| ";
    private boolean mNetworkAvailable = false;
    private PromptDialog mPromptDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityHelper.getInstance().add((Activity)this);
        this.getWindow().requestFeature(12);
        this.mPromptDialog = PromptDialog.newInstance((Context)this);
        if (this.layoutId() != -1) {
            if (this.isDataBinding()) {
                ViewDataBinding v = DataBindingUtil.setContentView((Activity)this, (int)this.layoutId());
                this.initializeView(savedInstanceState, v);
            } else {
                this.setContentView(this.layoutId());
                this.initializeView(savedInstanceState, null);
            }
        }
    }

    protected int layoutId() {
        return -1;
    }

    protected boolean isDataBinding() {
        return false;
    }

    protected void initializeView(@Nullable Bundle savedInstanceState, @Nullable ViewDataBinding viewDataBinding) {
    }

    public void setToolbar(Toolbar toolbar) {
        if (toolbar == null) {
            return;
        }
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() == null) {
            return;
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbsBaseActivity.this.onHomeClick();
            }
        });
    }

    public void setToolbarWithImmersiveStatusBar(Toolbar toolbar, @ColorRes int color2) {
        this.setToolbar(toolbar);
        StatusBarHelper.setStatusBarWithToolbarStyle((Activity)this, (View)toolbar, color2);
    }

    public void setToolbarWithGradientStatusBar(Toolbar toolbar, Drawable drawable2) {
        this.setToolbar(toolbar);
        toolbar.setBackground(drawable2);
        StatusBarHelper.setDrawable((Activity)this, drawable2);
    }

    public void addDrawerLayoutToggle(DrawerLayout drawerLayout, Toolbar toolbar, String title) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setTitle((CharSequence)title);
        }
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle((Activity)this, drawerLayout, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        drawerLayout.addDrawerListener((DrawerLayout.DrawerListener)toggle);
        toggle.syncState();
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    protected void onHomeClick() {
        this.finish();
    }

    public void show(boolean isShow) {
        if (isShow) {
            if (this.mPromptDialog.isShowing()) {
                return;
            }
            this.mPromptDialog.showLoading(1003);
        } else {
            if (!this.mPromptDialog.isShowing()) {
                return;
            }
            this.mPromptDialog.dismiss();
        }
    }

    public PromptDialog getPromptDialog() {
        return this.mPromptDialog;
    }

    public boolean isNetworkAvailable() {
        return this.mNetworkAvailable;
    }

    public void findNetworkAvailable() {
        NetHelper.getInstance().setOnNetworkChangeListener(this);
    }

    protected void onConnectNetwork() {
    }

    protected void onUnConnectNetWork() {
        NetHelper.setNetworkSetting((Context)this);
    }

    protected void moveTaskToBack() {
        if (!this.moveTaskToBack(false)) {
            super.onBackPressed();
        }
    }

    @Override
    public void onNetwork(boolean connect) {
        this.mNetworkAvailable = connect;
        if (connect) {
            this.onConnectNetwork();
        } else {
            this.onUnConnectNetWork();
        }
    }

    public void finish() {
        ScreenHelper.hideSoftInput((Activity)this);
        super.finish();
        ActivityHelper.getInstance().finish((Activity)this);
    }

    public void logV(String msg) {
        Logger.v(this.TAG + msg);
    }

    public void logD(String msg) {
        Logger.d(this.TAG + msg);
    }

    public void logI(String msg) {
        Logger.i(this.TAG + msg);
    }

    public void logW(String msg) {
        Logger.w(this.TAG + msg);
    }

    public void logE(String msg) {
        Logger.e(this.TAG + msg);
    }

    protected void onDestroy() {
        super.onDestroy();
        ActivityHelper.getInstance().remove((Activity)this);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionManager.getInstance().onPermissionResult(requestCode, permissions, grantResults);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        PermissionManager.getInstance().onSettingResult(requestCode, resultCode, data);
        PhotoHelper.getInstance().onPhotoResult(requestCode, resultCode, data);
    }
}

