/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.dzenm.helper.R;
import com.dzenm.helper.os.OsHelper;

public class RatioImageView
extends AppCompatImageView {
    private int[] mCornerRadius = new int[4];
    private boolean isCircle;
    private Paint mPaint;
    private int mForegroundColor;
    private float mRatio;

    public void setCircle(boolean circle) {
        this.isCircle = circle;
    }

    public void setRatio(float ratio) {
        this.mRatio = ratio;
    }

    public void setForegroundColor(int foregroundColor) {
        this.mForegroundColor = foregroundColor;
    }

    public RatioImageView(Context context) {
        this(context, null);
    }

    public RatioImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RatioImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.RatioImageView);
        this.mRatio = t.getFloat(R.styleable.RatioImageView_ratio, 1.0f);
        this.mForegroundColor = t.getColor(R.styleable.RatioImageView_foregroundColor, -4342339);
        this.isCircle = t.getBoolean(R.styleable.RatioImageView_isCircle, false);
        this.mCornerRadius[2] = this.mCornerRadius[3] = (int)t.getDimension(R.styleable.RatioImageView_cornerRadius, (float)this.dp2px(8.0f));
        this.mCornerRadius[1] = this.mCornerRadius[3];
        this.mCornerRadius[0] = this.mCornerRadius[3];
        this.mCornerRadius[0] = (int)t.getDimension(R.styleable.RatioImageView_top_left_cornerRadius, (float)this.dp2px(8.0f));
        this.mCornerRadius[1] = (int)t.getDimension(R.styleable.RatioImageView_top_right_cornerRadius, (float)this.dp2px(8.0f));
        this.mCornerRadius[2] = (int)t.getDimension(R.styleable.RatioImageView_bottom_left_cornerRadius, (float)this.dp2px(8.0f));
        this.mCornerRadius[3] = (int)t.getDimension(R.styleable.RatioImageView_top_left_cornerRadius, (float)this.dp2px(8.0f));
        t.recycle();
        this.mPaint = new Paint();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mRatio != 0.0f) {
            float height = (float)width / this.mRatio;
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)height), (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                Drawable drawable2 = this.getDrawable();
                if (drawable2 == null || !this.isClickable()) break;
                drawable2.mutate().setColorFilter(this.mForegroundColor, PorterDuff.Mode.MULTIPLY);
                break;
            }
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                Drawable drawableUp = this.getDrawable();
                if (drawableUp == null || !this.isClickable()) break;
                drawableUp.mutate().clearColorFilter();
            }
        }
        return super.onTouchEvent(event);
    }

    public void draw(Canvas canvas) {
        int w = this.getWidth();
        int h = this.getHeight();
        canvas.saveLayer(this.getRectF(), null, 31);
        super.draw(canvas);
        this.mPaint.reset();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        canvas.drawPath(this.getTargetPath(w, h), this.mPaint);
        canvas.restore();
    }

    private Path getTargetPath(int w, int h) {
        Path path = this.getOriginImagePath();
        Path targetPath = new Path();
        if (this.isCircle) {
            float radius = (float)Math.min(w, h) / 2.0f;
            targetPath.addCircle((float)w / 2.0f, (float)h / 2.0f, radius, Path.Direction.CW);
        } else {
            targetPath.addRoundRect(this.getRectF(), this.getRadii(0.0f), Path.Direction.CW);
        }
        path.op(targetPath, Path.Op.DIFFERENCE);
        return path;
    }

    private Path getOriginImagePath() {
        Path imagePath = new Path();
        imagePath.addRect(this.getRectF(), Path.Direction.CW);
        return imagePath;
    }

    private float[] getRadii(float strokeWidth) {
        float[] radii = new float[8];
        for (int i = 0; i < this.mCornerRadius.length; ++i) {
            float f = (float)this.mCornerRadius[i] - strokeWidth / 2.0f;
            radii[2 * i + 1] = f;
            radii[2 * i] = f;
        }
        return radii;
    }

    private RectF getRectF() {
        return new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    private int dp2px(float dp) {
        return OsHelper.dp2px(dp);
    }
}

