/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.dzenm.helper.R;
import com.dzenm.helper.os.OsHelper;

public class ProgressBar
extends View {
    private int mProgressHeight;
    private int mProgressColor;
    private int mProgressValue;
    private int mMaxValue;
    private int mTextSize;
    private float mTextPadding;
    private String mText;
    private boolean isTextStatic;
    private Paint mPaintRemainingValue = new Paint();
    private Paint mPaintProgressValue = new Paint();
    private Paint mPaintText = new Paint();
    private Rect mTextBound = new Rect();

    public ProgressBar(Context context) {
        this(context, null);
    }

    public ProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.ProgressBar);
        this.mProgressHeight = (int)t.getDimension(R.styleable.ProgressBar_progressHeight, (float)this.dp2px(4));
        this.mTextSize = (int)t.getDimension(R.styleable.ProgressBar_textSize, 36.0f);
        this.mMaxValue = t.getInteger(R.styleable.ProgressBar_maxValue, 100);
        this.mProgressColor = t.getColor(R.styleable.ProgressBar_progressColor, this.getResources().getColor(17170450));
        this.isTextStatic = t.getBoolean(R.styleable.ProgressBar_textStatic, true);
        this.mProgressValue = 0;
        this.mText = this.mProgressValue + "%";
        this.mTextPadding = this.dp2px(4);
        t.recycle();
    }

    public void setCurrentValue(int currentValue) {
        if (currentValue > this.mMaxValue) {
            return;
        }
        this.mProgressValue = currentValue;
        this.invalidate();
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        this.invalidate();
    }

    public void draw(Canvas canvas) {
        float endRemaining;
        float startRemaining;
        float startText;
        super.draw(canvas);
        this.setPaint();
        int offsetTop = (this.getHeight() - this.mProgressHeight) / 2;
        float percentageValue = ((float)(this.getMeasuredWidth() - this.getTextWidth()) - (this.isTextStatic ? this.mTextPadding : 2.0f * this.mTextPadding)) * (float)this.mProgressValue / (float)this.mMaxValue;
        this.setPaint(this.mPaintProgressValue, this.mProgressColor);
        canvas.drawLine(0.0f, (float)offsetTop, percentageValue, (float)offsetTop, this.mPaintProgressValue);
        if (this.isTextStatic) {
            startText = this.getMeasuredWidth() - this.getTextWidth();
            startRemaining = percentageValue;
            endRemaining = startText - this.mTextPadding;
        } else {
            startText = percentageValue + this.mTextPadding;
            startRemaining = percentageValue + (float)this.getTextWidth() + 2.0f * this.mTextPadding;
            endRemaining = this.getMeasuredWidth();
        }
        canvas.drawText(this.mText, startText, (float)(offsetTop + (this.mTextBound.height() >> 1)), this.mPaintText);
        this.setPaint(this.mPaintRemainingValue, this.getResources().getColor(R.color.colorLightGray));
        canvas.drawLine(startRemaining, (float)offsetTop, endRemaining, (float)offsetTop, this.mPaintRemainingValue);
    }

    private void setPaint() {
        this.mPaintText.setAntiAlias(true);
        this.mPaintText.setColor(this.mProgressColor);
        this.mPaintText.setTextSize((float)this.mTextSize);
        this.mText = this.mProgressValue + "%";
        this.mPaintText.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBound);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.measureWidth(this.getSuggestedMinimumWidth(), widthMeasureSpec);
        int height = this.measureHeight(this.getSuggestedMinimumHeight(), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureWidth(int defaultWidth, int measureSpec) {
        int width = defaultWidth;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == Integer.MIN_VALUE) {
            width = specSize;
        } else if (specMode == 0x40000000) {
            width = specSize;
        } else if (specMode == 0) {
            width = Math.max(defaultWidth, specSize);
        }
        return width;
    }

    private int measureHeight(int defaultHeight, int measureSpec) {
        int height = defaultHeight;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == Integer.MIN_VALUE) {
            height = specSize;
        } else if (specMode == 0x40000000) {
            height = specSize;
        } else if (specMode == 0) {
            height = Math.max(defaultHeight, specSize);
        }
        return height;
    }

    private void setPaint(Paint paint, int color2) {
        paint.setAntiAlias(true);
        paint.setColor(color2);
        paint.setStyle(Paint.Style.FILL);
        paint.setStrokeWidth((float)this.mProgressHeight);
    }

    private int getTextWidth() {
        Paint paint = new Paint();
        paint.setTextSize((float)this.mTextSize);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBound);
        return this.mTextBound.width() + 2;
    }

    private int dp2px(int value) {
        return OsHelper.dp2px(value);
    }
}

