/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.dzenm.helper.R;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.view.ImageLoader;
import com.dzenm.helper.view.LayoutTransitionHelper;
import com.dzenm.helper.view.RatioImageView;
import java.util.List;

public class PhotoLayout
extends GridLayout {
    private static final String TAG = PhotoLayout.class.getSimpleName() + "|";
    private static final int DEFAULT_TOTAL_NUMBER = 3;
    private static final int DEFAULT_COLUMN_NUMBER = 3;
    private static final int EMPTY_IMAGE = 1001;
    private int mTotalNumber;
    private int mColumnNumber;
    private RatioImageView mEmptyRatioImageView;
    private int mImageWidth;
    private int mImageHeight;
    private int mCurrentPosition = 0;
    private int mMargin;
    private int mDeleteSize;
    private boolean isPreview;
    private int mDefaultIcon;
    private int mDeleteIcon;
    private OnLoadPhotoListener mOnLoadPhotoListener;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private ImageLoader mImageLoader;

    public void setTotalNumber(int totalNumber) {
        this.mTotalNumber = totalNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.mColumnNumber = columnNumber;
        this.invalidateGridView();
    }

    public void setMargin(int margin) {
        this.mMargin = OsHelper.dp2px(margin);
        this.invalidateGridView();
    }

    public void setOnPhotoListener(OnLoadPhotoListener listener) {
        this.mOnLoadPhotoListener = listener;
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
        this.invalidateGridView();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    public void load(List lists) {
        this.setTotalNumber(lists.size());
        for (Object object : lists) {
            this.load(object);
        }
    }

    public void load(final Object object) {
        this.post(new Runnable(){

            @Override
            public void run() {
                PhotoLayout.this.newRatioImageView(object);
            }
        });
    }

    public void remove(View view) {
        this.removeRatioImageView(view);
    }

    private void newRatioImageView(Object object) {
        if (this.mCurrentPosition < this.mTotalNumber) {
            RatioImageView imageView = this.addRatioImageView(this.mCurrentPosition);
            this.mImageLoader.onLoader(imageView, object);
        }
    }

    public PhotoLayout(Context context) {
        this(context, null);
    }

    public PhotoLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhotoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PhotoLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.PhotoLayout, defStyleAttr, defStyleRes);
        this.mTotalNumber = t.getInteger(R.styleable.PhotoLayout_totalNumber, 3);
        this.mColumnNumber = t.getInteger(R.styleable.PhotoLayout_columnNumber, 3);
        this.mMargin = (int)t.getDimension(R.styleable.PhotoLayout_margin, (float)OsHelper.dp2px(2.0f));
        this.isPreview = t.getBoolean(R.styleable.PhotoLayout_isPreview, false);
        this.mDeleteSize = (int)t.getDimension(R.styleable.PhotoLayout_deleteSize, (float)OsHelper.dp2px(16.0f));
        this.mDeleteIcon = t.getResourceId(R.styleable.PhotoLayout_deleteIcon, R.drawable.ic_delete_picture);
        this.mDefaultIcon = t.getResourceId(R.styleable.PhotoLayout_defaultIcon, R.drawable.ic_add);
        t.recycle();
        this.setLayoutTransition(LayoutTransitionHelper.scaleViewAnimator((View)this));
        this.invalidateGridView();
    }

    private void initializeView() {
        if (!this.isPreview && this.mEmptyRatioImageView != null) {
            this.removeView((View)this.mEmptyRatioImageView);
            this.mEmptyRatioImageView = null;
        }
        this.setColumnCount(this.mColumnNumber);
        int rowCount = this.mCurrentPosition + 1 / this.mColumnNumber;
        this.setRowCount(this.mCurrentPosition + 1 == this.mTotalNumber ? rowCount : rowCount + 1);
        this.mImageWidth = this.mImageHeight = (this.getWidth() - 6 * this.mMargin) / this.getColumnCount();
        if (!this.isPreview && this.mEmptyRatioImageView == null && this.getChildCount() == 0) {
            this.mEmptyRatioImageView = this.createEmptyRatioImageView(this.mImageWidth, this.mImageHeight, this.mMargin);
            this.addView((View)this.mEmptyRatioImageView);
        }
    }

    private void invalidateGridView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                PhotoLayout.this.initializeView();
            }
        });
    }

    private RatioImageView createEmptyRatioImageView(int width, int height, int margin) {
        RatioImageView imageView = new RatioImageView(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(width, height);
        layoutParams.setMargins(margin, margin, margin, margin);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setPivotX(0.0f);
        imageView.setPivotY(0.0f);
        imageView.setImageResource(this.mDefaultIcon);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PhotoLayout.this.mOnLoadPhotoListener != null) {
                    PhotoLayout.this.mOnLoadPhotoListener.onLoad(PhotoLayout.this);
                }
            }
        });
        BackGHelper.pressed(R.color.colorLightGray, R.color.colorHint).into((View)imageView);
        return imageView;
    }

    private RatioImageView addRatioImageView(int position) {
        if (this.isPreview && this.mEmptyRatioImageView != null && this.getChildCount() >= 1) {
            this.mEmptyRatioImageView.setVisibility(8);
        }
        RatioImageView imageView = this.createRatioImageView(position);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.mImageWidth, this.mImageHeight);
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        layoutParams.setMargins(this.mMargin, this.mMargin, this.mMargin, this.mMargin);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        relativeLayout.setPivotX(0.0f);
        relativeLayout.setPivotY(0.0f);
        relativeLayout.addView((View)imageView);
        if (!this.isPreview) {
            relativeLayout.addView((View)this.createDeleteView(relativeLayout, position));
        }
        Logger.d(TAG + "\u5f53\u524dImageView\u6240\u5728\u7684\u4f4d\u7f6e: " + position);
        this.addView((View)relativeLayout, position);
        ++this.mCurrentPosition;
        this.setEmptyRatioImageViewVisible(false);
        return imageView;
    }

    private RatioImageView createRatioImageView(final int currentPosition) {
        RatioImageView imageView = new RatioImageView(this.getContext());
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.mImageWidth, this.mImageHeight));
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setTag(R.id.photo_layout_image_id, currentPosition);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.d(TAG + "click position is " + currentPosition);
                if (PhotoLayout.this.mOnItemClickListener != null) {
                    PhotoLayout.this.mOnItemClickListener.onItemClick(view, currentPosition);
                }
            }
        });
        imageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                Logger.d(TAG + "click position is " + currentPosition);
                if (PhotoLayout.this.mOnItemLongClickListener != null) {
                    PhotoLayout.this.mOnItemLongClickListener.onItemLongClick(view, currentPosition);
                }
                return false;
            }
        });
        return imageView;
    }

    private RatioImageView createDeleteView(final RelativeLayout relativeLayout, final int currentPosition) {
        RatioImageView imageView = new RatioImageView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.mDeleteSize, this.mDeleteSize);
        layoutParams.addRule(21);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setImageResource(this.mDeleteIcon);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.d(TAG + "click position is " + currentPosition);
                PhotoLayout.this.remove((View)relativeLayout);
            }
        });
        return imageView;
    }

    private void removeRatioImageView(View view) {
        this.removeView(view);
        --this.mCurrentPosition;
        this.setEmptyRatioImageViewVisible(true);
    }

    private void setEmptyRatioImageViewVisible(boolean visible) {
        int count;
        int n = count = visible ? this.getChildCount() : this.mCurrentPosition;
        if (count == this.mTotalNumber && !this.isPreview) {
            this.mEmptyRatioImageView.setVisibility(visible ? 0 : 8);
        }
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(View var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    public static interface OnLoadPhotoListener {
        public void onLoad(PhotoLayout var1);
    }
}

