/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.view;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.dzenm.helper.R;
import com.dzenm.helper.view.OnTextChangeListener;

public class EditTextChangeHelper
implements OnTextChangeListener,
View.OnFocusChangeListener {
    private EditText[] mEditTexts;
    private String[] mTexts;
    private int backgroundError = R.drawable.bg_red_border;
    private int backgroundNormal = R.drawable.bg_gray_border;

    public static EditTextChangeHelper newInstance() {
        return new EditTextChangeHelper();
    }

    public EditTextChangeHelper setEditText(EditText ... editTexts) {
        for (EditText edit : editTexts) {
            edit.addTextChangedListener((TextWatcher)new CustomEditText(edit, this));
            edit.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        }
        this.mEditTexts = editTexts;
        return this;
    }

    public EditTextChangeHelper setText(String ... texts) {
        this.mTexts = texts;
        return this;
    }

    public boolean verify(boolean reset) {
        for (int i = 0; i < this.mEditTexts.length; ++i) {
            EditText editText = this.mEditTexts[i];
            String text = null;
            if (this.mTexts != null) {
                text = this.mTexts[i];
            }
            if (reset) {
                this.verify(false, editText, text);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)editText.getText().toString())) {
                this.verify(true, editText, text);
                return false;
            }
            this.verify(false, editText, text);
        }
        return true;
    }

    private void verify(boolean error, EditText editText, String texts) {
        this.setBackgroundState(error, editText);
        if (!TextUtils.isEmpty((CharSequence)texts)) {
            editText.setHint((CharSequence)texts);
        }
        if (error) {
            editText.requestFocus();
        }
    }

    @Override
    public void onTextChanged(EditText editText, CharSequence s) {
        this.setBackgroundState(s.length() == 0, editText);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        for (EditText editText : this.mEditTexts) {
            if (editText != v) {
                this.setBackgroundState(false, editText);
                continue;
            }
            this.setBackgroundState(hasFocus && ((TextView)v).getText().length() == 0, editText);
        }
    }

    private void setBackgroundState(boolean state, EditText editText) {
        editText.setBackgroundResource(state ? this.backgroundError : this.backgroundNormal);
    }

    private class CustomEditText
    implements TextWatcher {
        OnTextChangeListener mOnTextChangeListener;
        EditText mEditText;

        private CustomEditText(EditText editText, OnTextChangeListener onTextChangeListener) {
            this.mEditText = editText;
            this.mOnTextChangeListener = onTextChangeListener;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            this.mOnTextChangeListener.onTextChanged(this.mEditText, s);
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

