/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.toast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.dzenm.helper.R;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.os.OsHelper;

public class Toa {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Toa sToast;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Prompt sPrompt;
    private static boolean isShowRepeat;
    private static Drawable sBackground;
    private static Drawable sCustomizeBackground;
    private static int sGravity;
    private static int sCustomizeGravity;
    private static int sOffset;
    private static int sCustomizeOffset;
    private static boolean isCustomize;

    private Toa() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Toa getInstance() {
        if (sToast != null) return sToast;
        Class<Toa> clazz = Toa.class;
        synchronized (Toa.class) {
            if (sToast != null) return sToast;
            sToast = new Toa();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sToast;
        }
    }

    public Toa init(Context context) {
        sContext = context;
        return this;
    }

    public static Toa customize() {
        isCustomize = true;
        return sToast;
    }

    public Toa setBackground(Drawable background) {
        if (isCustomize) {
            sCustomizeBackground = background;
        } else {
            sBackground = background;
        }
        return sToast;
    }

    public Toa setGravity(int gravity, int offset) {
        if (isCustomize) {
            sCustomizeGravity = gravity;
            sCustomizeOffset = offset;
        } else {
            sGravity = gravity;
            sOffset = offset;
        }
        return sToast;
    }

    public Toa setOnce(boolean once) {
        isShowRepeat = !once;
        return sToast;
    }

    public static void show(int resId) {
        Toa.show(sContext.getString(resId));
    }

    public static void show(CharSequence text) {
        Toa.show(text, 0, 0, -1);
    }

    public static void show(CharSequence text, int resId) {
        Toa.show(text, resId, 0);
    }

    public static void show(CharSequence text, int resId, int duration) {
        Toa.show(text, resId, duration, 1);
    }

    public static void show(CharSequence text, int resId, int duration, int showImage) {
        if (isShowRepeat) {
            if (sPrompt != null) {
                sPrompt.cancel();
            }
            sPrompt = new Prompt(sContext);
        } else if (sPrompt == null) {
            sPrompt = new Prompt(sContext);
        }
        if (isCustomize) {
            if (sCustomizeBackground != null) {
                Toa.sPrompt.setBackground(Toa.sCustomizeBackground);
            }
        } else if (sBackground != null) {
            Toa.sPrompt.setBackground(Toa.sBackground);
        }
        if (isCustomize) {
            if (sCustomizeGravity != 0) {
                Toa.sPrompt.setGravity(Toa.sCustomizeGravity, Toa.sCustomizeOffset);
            }
        } else if (sGravity != 0) {
            Toa.sPrompt.setGravity(Toa.sGravity, Toa.sOffset);
        }
        if (isCustomize) {
            sCustomizeBackground = null;
            sCustomizeGravity = 0;
            sCustomizeOffset = 0;
            isCustomize = false;
        }
        Toa.sPrompt.showToast(text, resId, duration, showImage);
    }

    static {
        isShowRepeat = true;
        isCustomize = false;
    }

    private static class Prompt
    extends Toast {
        private static final int TYPE_HIDE = -1;
        private static final int TYPE_SHOW = 1;
        private ImageView mImageView;
        private TextView mTextView;
        private LinearLayout mLinearLayout;
        private Drawable mBackground = BackGHelper.solid(R.color.colorTranslucentDarkGray).radius(16.0f).build();

        private Prompt(Context context) {
            super(context);
        }

        private Prompt setBackground(Drawable background) {
            this.mBackground = background;
            return this;
        }

        private Prompt setGravity(int gravity, int offset) {
            sPrompt.setGravity(gravity, offset, 0);
            return this;
        }

        private Prompt showToast(CharSequence text, int resId, int duration, int showImage) {
            sPrompt.setView(this.initView(sContext));
            sPrompt.setDuration(duration);
            this.mTextView.setText(text);
            this.mLinearLayout.setBackground(this.mBackground);
            if (showImage == -1) {
                this.mImageView.setVisibility(8);
            } else if (showImage == 1) {
                this.mImageView.setImageResource(resId);
                Drawable drawable2 = this.mImageView.getDrawable();
                if (!(drawable2 instanceof VectorDrawable)) {
                    ((Animatable)drawable2).start();
                }
            }
            sPrompt.show();
            return this;
        }

        private View initView(Context context) {
            LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-1, -2);
            this.mTextView = new TextView(context);
            this.mTextView.setTextColor(context.getResources().getColor(17170443));
            this.mTextView.setLayoutParams((ViewGroup.LayoutParams)textParams);
            int size = OsHelper.dp2px(16.0f);
            LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams(size, size);
            imgParams.setMargins(0, 0, OsHelper.dp2px(8.0f), 0);
            this.mImageView = new ImageView(context);
            this.mImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imgParams);
            this.mLinearLayout = new LinearLayout(context);
            this.mLinearLayout.setGravity(17);
            int paddingVertical = OsHelper.dp2px(12.0f);
            int paddingHorizontal = OsHelper.dp2px(16.0f);
            this.mLinearLayout.setPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
            this.mLinearLayout.setOrientation(0);
            this.mLinearLayout.addView((View)this.mImageView);
            this.mLinearLayout.addView((View)this.mTextView);
            return this.mLinearLayout;
        }
    }
}

