/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.share;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import com.dzenm.helper.file.FileHelper;
import com.dzenm.helper.log.Logger;
import java.io.File;

public class ShareHelper {
    public static final int REQUEST_CODE = 1001;
    private Activity mActivity;
    private String mType = "text/plain";
    private String mMessage;
    private Uri mUri;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ShareHelper sShareHelper;
    private OnShareListener mOnShareListener;

    public static ShareHelper newInstance(Activity activity) {
        return new ShareHelper();
    }

    private ShareHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShareHelper getInstance() {
        if (sShareHelper != null) return sShareHelper;
        Class<ShareHelper> clazz = ShareHelper.class;
        synchronized (ShareHelper.class) {
            if (sShareHelper != null) return sShareHelper;
            sShareHelper = new ShareHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sShareHelper;
        }
    }

    public ShareHelper with(Activity activity) {
        this.mActivity = activity;
        return this;
    }

    public ShareHelper setText(String text) {
        this.mMessage = text;
        this.mType = "text/plain";
        return this;
    }

    public ShareHelper setImage(String parent, String child) {
        this.setFile(parent, child, "image/*");
        return this;
    }

    public ShareHelper setVideo(String parent, String child) {
        this.setFile(parent, child, "video/*");
        return this;
    }

    public ShareHelper setFile(String parent, String child) {
        this.setFile(parent, child, "*/*");
        return this;
    }

    private ShareHelper setFile(String parent, String child, String type) {
        File file = new File(Environment.getExternalStorageDirectory() + File.separator + parent, child);
        if (file.isDirectory()) {
            Logger.i("file is a directory");
            return this;
        }
        if (!file.exists()) {
            Logger.i("file is not exists");
            return this;
        }
        this.mUri = FileHelper.getInstance().getUri(file);
        Logger.d("share file's uri is: " + this.mUri);
        this.mType = type;
        return this;
    }

    public void share() {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType(this.mType);
        this.setIntentExtra(intent);
        this.mActivity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"), 1001);
    }

    public ShareHelper setOnShareListener(OnShareListener onShareListener) {
        this.mOnShareListener = onShareListener;
        return this;
    }

    private void setIntentExtra(Intent intent) {
        if (this.mType.equals("text/plain")) {
            intent.putExtra("android.intent.extra.TEXT", this.mMessage);
        } else if (this.mType.equals("image/*") || this.mType.equals("video/*") || this.mType.equals("*/*")) {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)this.mUri);
            intent.setFlags(3);
        }
    }

    public void onShareResult(int requestCode, int resultCode) {
        if (requestCode == 1001) {
            this.mOnShareListener.onResult(resultCode == -1);
        }
    }

    public static interface OnShareListener {
        public void onResult(boolean var1);
    }
}

