/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.popup;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.ViewHolder;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.popup.PopupController;

public class PopupHelper
extends PopupWindow {
    private final PopupController controller;

    private PopupHelper(Activity activity) {
        this(activity, (AttributeSet)null);
    }

    private PopupHelper(Activity activity, AttributeSet attrs) {
        this(activity, attrs, 0);
    }

    private PopupHelper(Activity activity, AttributeSet attrs, int defStyleAttr) {
        super((Context)activity, attrs, defStyleAttr);
        this.controller = new PopupController(activity, this);
    }

    public static interface OnViewHolderCallback {
        public void onCallback(ViewHolder var1, PopupHelper var2);
    }

    public static class Builder {
        private final PopupController.Params params;

        public static Builder newInstance(Activity activity) {
            return new Builder(activity);
        }

        public Builder(Activity activity) {
            this.params = new PopupController.Params(activity);
            this.params.mBackground = BackGHelper.solid(17170443).radius(8.0f).build();
            this.params.parentBackgroundAlpha = 0.6f;
            this.params.mTouchable = true;
            this.params.mAnimationStyle = R.style.BasePopup_Fade_Vertical_Animator;
        }

        public Builder setView(int resId) {
            this.params.mPopupView = LayoutInflater.from((Context)this.params.mActivity).inflate(resId, null, false);
            return this;
        }

        public Builder setView(View view) {
            this.params.mPopupView = view;
            return this;
        }

        public Builder setAnimationStyle(int animationStyle) {
            this.params.mAnimationStyle = animationStyle;
            return this;
        }

        public Builder setOutsideTouchable(boolean touchable) {
            this.params.mTouchable = touchable;
            return this;
        }

        public Builder setBackground(Drawable background) {
            this.params.mBackground = background;
            return this;
        }

        public Builder setElevation(int elevation) {
            this.params.mElevation = elevation;
            return this;
        }

        public Builder setParentBackground(float background) {
            this.params.parentBackgroundAlpha = background;
            return this;
        }

        public Builder setOnViewHolderCallback(OnViewHolderCallback onViewHolderCallback) {
            this.params.mOnViewHolderCallback = onViewHolderCallback;
            return this;
        }

        public PopupHelper create() {
            PopupHelper mP = new PopupHelper(this.params.mActivity);
            this.params.apply(mP.controller);
            return mP;
        }
    }
}

