/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.permission;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.dialog.DialogHelper;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.dialog.ViewHolder;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.permission.PermissionSetting;
import java.util.ArrayList;
import java.util.List;

public final class PermissionManager
implements DialogHelper.OnConvertViewClickListener {
    private static final String TAG = PermissionManager.class.getSimpleName() + "|";
    private static final int REQUEST_PERMISSION = 100;
    static final int REQUEST_SETTING = 101;
    public static final int MODE_ONCE = 1001;
    public static final int MODE_ONCE_INFO = 1002;
    public static final int MODE_REPEAT = 1003;
    private int mRequestMode = 1002;
    private String[] mPermissions;
    private String[] mAllPermissions;
    private OnPermissionListener mOnPermissionListener;
    private AppCompatActivity mActivity;
    private Fragment mFragment;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile PermissionManager sPermissionManager;

    private PermissionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermissionManager getInstance() {
        if (sPermissionManager != null) return sPermissionManager;
        Class<PermissionManager> clazz = PermissionManager.class;
        synchronized (PermissionManager.class) {
            if (sPermissionManager != null) return sPermissionManager;
            sPermissionManager = new PermissionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sPermissionManager;
        }
    }

    public PermissionManager with(AppCompatActivity activity) {
        Logger.d(TAG + activity.getClass().getSimpleName() + " is requesting permission");
        this.mActivity = activity;
        return this;
    }

    public PermissionManager with(Fragment fragment) {
        Logger.d(TAG + fragment.getClass().getSimpleName() + " is requesting permission");
        this.mFragment = fragment;
        return this;
    }

    public PermissionManager mode(int requestMode) {
        this.mRequestMode = requestMode;
        return this;
    }

    public PermissionManager load(String permissions) {
        this.load(new String[]{permissions});
        return this;
    }

    public PermissionManager load(List<String> permissions) {
        this.load(permissions.toArray(new String[permissions.size()]));
        return this;
    }

    public PermissionManager load(String[] permissions) {
        this.mAllPermissions = permissions;
        return this;
    }

    public PermissionManager into(OnPermissionListener onPermissionListener) {
        this.mOnPermissionListener = onPermissionListener;
        return this;
    }

    public void request() {
        this.startRequestPermission();
    }

    private void startRequestPermission() {
        this.mPermissions = this.filterPermission(this.mAllPermissions);
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            this.requestResult(true);
        } else if (this.isRationaleAll()) {
            Logger.i("\u8bf7\u6c42\u6743\u9650\u65f6\u88ab\u62d2\u7edd, \u63d0\u793a\u7528\u6237\u4e3a\u4ec0\u4e48\u8981\u6388\u4e88\u6743\u9650");
            this.openPromptPermissionDialog();
        } else {
            Logger.i("\u5f00\u59cb\u8bf7\u6c42\u6743\u9650...");
            this.requestPermission();
        }
    }

    private void requestPermission() {
        ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])this.mAllPermissions, (int)100);
    }

    public void onPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (100 == requestCode) {
            this.mPermissions = this.filterPermission(permissions);
            this.onPermissionResult();
        }
    }

    private void onPermissionResult() {
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            this.requestResult(true);
        } else if (this.mRequestMode == 1001) {
            this.openFailedDialog();
        } else if (this.mRequestMode == 1002) {
            Logger.i("\u8bf7\u6c42\u6743\u9650\u88ab\u62d2\u7edd\u5e76\u4e14\u8bb0\u4f4f, \u63d0\u793a\u7528\u6237\u624b\u52a8\u6253\u5f00\u6743\u9650");
            this.openSettingDialog();
        } else if (this.mRequestMode == 1003) {
            if (this.isRationaleAll()) {
                Logger.i("\u8bf7\u6c42\u6743\u9650\u88ab\u62d2\u7edd\u672a\u8bb0\u4f4f, \u91cd\u590d\u8bf7\u6c42\u6743\u9650");
                this.startRequestPermission();
            } else {
                Logger.i("\u8bf7\u6c42\u6743\u9650\u88ab\u62d2\u7edd\u5e76\u4e14\u8bb0\u4f4f, \u63d0\u793a\u7528\u6237\u624b\u52a8\u6253\u5f00\u6743\u9650");
                this.openSettingDialog();
            }
        }
    }

    public void onSettingResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 101) {
            this.request();
        }
    }

    private void requestResult(boolean result) {
        if (this.mOnPermissionListener != null) {
            this.mOnPermissionListener.onPermit(result);
        }
    }

    private boolean isRationaleAll() {
        for (String permission2 : this.mPermissions) {
            if (OsHelper.isRationale((Activity)this.mActivity, permission2)) continue;
            return false;
        }
        return true;
    }

    private String[] filterPermission(String[] permissions) {
        if (permissions == null || permissions.length == 0) {
            return null;
        }
        ArrayList<String> filterPermits = new ArrayList<String>();
        for (String permission2 : permissions) {
            Logger.d(TAG + "request permission: " + permission2);
            if (OsHelper.isGrant((Context)this.mActivity, permission2)) continue;
            filterPermits.add(permission2);
        }
        String[] res = new String[filterPermits.size()];
        return filterPermits.toArray(res);
    }

    private void openSettingDialog() {
        String negativeText = this.mRequestMode == 1003 ? "\u8fdb\u5165\u6388\u6743" : (this.isRationaleAll() ? "\u8fdb\u5165\u6388\u6743" : "\u53d6\u6d88");
        this.getInfoDialog("\u62d2\u7edd\u6388\u4e88\u6743\u9650\u5c06\u5bfc\u81f4\u7a0b\u5e8f\u8fd0\u884c\u51fa\u73b0\u4e0d\u53ef\u9884\u6599\u7684\u9519\u8bef, \u8bf7\u524d\u5f80\u8bbe\u7f6e\u624b\u52a8\u6388\u4e88\u6743\u9650").setButtonText("\u624b\u52a8\u8bbe\u7f6e", negativeText).setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                if (confirm) {
                    PermissionSetting.openSetting((Activity)PermissionManager.this.mActivity, false);
                } else if (PermissionManager.this.isRationaleAll()) {
                    PermissionManager.this.startRequestPermission();
                } else if (PermissionManager.this.mRequestMode == 1003) {
                    PermissionManager.this.startRequestPermission();
                } else {
                    PermissionManager.this.requestResult(false);
                }
                return true;
            }
        }).show();
    }

    private void openFailedDialog() {
        this.getInfoDialog("\u62d2\u7edd\u6388\u4e88\u7a0b\u5e8f\u8fd0\u884c\u9700\u8981\u7684\u6743\u9650, \u5c06\u51fa\u73b0\u4e0d\u53ef\u9884\u77e5\u7684\u9519\u8bef, \u8bf7\u6388\u4e88\u6743\u9650\u540e\u7ee7\u7eed\u64cd\u4f5c").setButtonText("\u786e\u5b9a").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                PermissionManager.this.requestResult(false);
                return true;
            }
        }).show();
    }

    private void openPromptPermissionDialog() {
        DialogHelper.newInstance(this.mActivity).setLayout(R.layout.dialog_permission_prompt).setCancel(false).setOnConvertViewClickListener(this).setBackground(BackGHelper.solid(17170443).radius(10.0f).build()).show();
    }

    public void onConvertClick(ViewHolder holder, final AbsDialogFragment dialog) {
        ((TextView)holder.getView(R.id.tv_title)).setText((CharSequence)"\u6e29\u99a8\u63d0\u793a");
        ((TextView)holder.getView(R.id.tv_message)).setText((CharSequence)"\u7a0b\u5e8f\u8fd0\u884c\u6240\u9700\u4ee5\u4e0b\u6743\u9650");
        String permission2 = this.getPermissionPrompt();
        ((TextView)holder.getView(R.id.tv_permission)).setText((CharSequence)permission2);
        TextView confirm = (TextView)holder.getView(R.id.tv_confirm);
        confirm.setText((CharSequence)"\u524d\u5f80\u6388\u6743");
        ImageView cancel = (ImageView)holder.getView(R.id.iv_cancel);
        BackGHelper.radius(10.0f).pressed(R.color.colorLightGray).into((View)cancel);
        BackGHelper.radiusBL(10.0f).radiusBR(10.0f).pressed(R.color.colorDarkBlue, R.color.colorTranslucentDarkBlue).into((View)confirm);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionManager.this.setPromptCancelClick();
                dialog.dismiss();
            }
        });
        confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionManager.this.setPromptConfirmClick();
                dialog.dismiss();
            }
        });
    }

    private void setPromptCancelClick() {
        if (this.mRequestMode == 1003) {
            this.openSettingDialog();
        } else {
            this.requestResult(false);
        }
    }

    private void setPromptConfirmClick() {
        if (this.isRationaleAll()) {
            this.requestPermission();
        } else {
            this.openSettingDialog();
        }
    }

    private InfoDialog getInfoDialog(String message) {
        return InfoDialog.newInstance(this.mActivity).setTitle("\u6e29\u99a8\u63d0\u793a").setMessage(message).setCancel(false);
    }

    private String getPermissionPrompt() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mPermissions.length; ++i) {
            String permission2 = this.mPermissions[i];
            if (TextUtils.isEmpty((CharSequence)permission2)) continue;
            sb.append(i == 0 ? "\u2299\t\t" : "\n\u2299\t\t").append(this.getPermissionText(permission2));
        }
        return "".contentEquals(sb) ? "(\u7a7a)" : sb.toString();
    }

    private String getPermissionText(String permission2) {
        switch (permission2) {
            case "android.permission.WRITE_CONTACTS": {
                return "\u8054\u7cfb\u4eba\u5199\u5165\u6743\u9650";
            }
            case "android.permission.GET_ACCOUNTS": {
                return "\u83b7\u53d6\u8054\u7cfb\u4eba\u8d26\u6237\u6743\u9650";
            }
            case "android.permission.READ_CONTACTS": {
                return "\u8bfb\u53d6\u8054\u7cfb\u4eba\u6743\u9650";
            }
            case "android.permission.READ_CALL_LOG": {
                return "\u8bfb\u53d6\u901a\u8bdd\u8bb0\u5f55\u6743\u9650";
            }
            case "android.permission.READ_PHONE_STATE": {
                return "\u8bfb\u53d6\u624b\u673a\u72b6\u6001\u6743\u9650";
            }
            case "android.permission.CALL_PHONE": {
                return "\u62e8\u6253\u7535\u8bdd\u6743\u9650";
            }
            case "android.permission.WRITE_CALL_LOG": {
                return "\u901a\u8bdd\u8bb0\u5f55\u5199\u5165\u6743\u9650";
            }
            case "android.permission.USE_SIP": {
                return "\u4f7f\u7528SIP\u6743\u9650";
            }
            case "android.permission.PROCESS_OUTGOING_CALLS": {
                return "\u5904\u7406\u5916\u547c\u7535\u8bdd\u6743\u9650";
            }
            case "com.android.voicemail.permission.ADD_VOICEMAIL": {
                return "\u6dfb\u52a0\u58f0\u97f3\u90ae\u4ef6\u6743\u9650";
            }
            case "android.permission.READ_CALENDAR": {
                return "\u8bfb\u53d6\u65e5\u5386\u6743\u9650";
            }
            case "android.permission.WRITE_CALENDAR": {
                return "\u65e5\u5386\u5199\u5165\u6743\u9650";
            }
            case "android.permission.CAMERA": {
                return "\u7167\u76f8\u673a\u6743\u9650";
            }
            case "android.permission.BODY_SENSORS": {
                return "\u4f20\u611f\u5668\u6743\u9650";
            }
            case "android.permission.ACCESS_FINE_LOCATION": {
                return "\u8bbf\u95ee\u7cbe\u786e\u4f4d\u7f6e\u6743\u9650";
            }
            case "android.permission.ACCESS_COARSE_LOCATION": {
                return "\u8bbf\u95ee\u7c97\u7565\u4f4d\u7f6e\u6743\u9650";
            }
            case "android.permission.READ_EXTERNAL_STORAGE": {
                return "\u8bfb\u53d6\u5916\u90e8\u5b58\u50a8\u6743\u9650";
            }
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                return "\u5916\u90e8\u5b58\u50a8\u5199\u5165\u6743\u9650";
            }
            case "android.permission.RECORD_AUDIO": {
                return "\u5f55\u5236\u97f3\u9891\u6743\u9650";
            }
            case "android.permission.READ_SMS": {
                return "\u8bfb\u53d6\u77ed\u4fe1\u6743\u9650";
            }
            case "android.permission.RECEIVE_WAP_PUSH": {
                return "\u63a5\u6536WAP\u63a8\u9001\u6743\u9650";
            }
            case "android.permission.RECEIVE_MMS": {
                return "\u63a5\u6536\u5f69\u4fe1\u6743\u9650";
            }
            case "android.permission.RECEIVE_SMS": {
                return "\u63a5\u6536\u77ed\u4fe1\u6743\u9650";
            }
            case "android.permission.SEND_SMS": {
                return "\u53d1\u9001\u77ed\u4fe1\u6743\u9650";
            }
        }
        return "";
    }

    public static interface OnPermissionListener {
        public void onPermit(boolean var1);
    }
}

