/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.os;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import com.dzenm.helper.R;
import com.dzenm.helper.os.OsHelper;

public class StatusBarHelper {
    private static final int DEFAULT_STATUS_BAR_ALPHA = 112;
    private static final int FAKE_STATUS_BAR_VIEW_ID = R.id.fake_status_bar_view_id;

    public static void setStatusBarWithToolbarStyle(Activity activity, @NonNull View view, @ColorRes int color2) {
        StatusBarHelper.setColor(activity, color2);
        StatusBarHelper.adjustViewHeightForHideStatusBar(activity, view);
        view.setBackgroundColor(StatusBarHelper.getColor(activity, color2));
    }

    public static void setFragmentToolbarColor(Activity activity, @NonNull Toolbar toolbar, int color2) {
        StatusBarHelper.adjustToolbarHeightForHideStatusBar(activity, (View)toolbar);
        toolbar.setBackgroundColor(StatusBarHelper.getColor(activity, color2));
        StatusBarHelper.setColor(activity, color2);
    }

    public static void setColor(Activity activity, @ColorRes int color2) {
        StatusBarHelper.setTranslucentColor(activity, color2, 0);
    }

    public static void setTranslucentColor(@NonNull Activity activity, @ColorRes int color2, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        int calculateColor = StatusBarHelper.calculateColorByAlpha(StatusBarHelper.getColor(activity, color2), statusBarAlpha);
        StatusBarHelper.setStatusBarColor(activity, StatusBarHelper.getColor(activity, 17170445));
        StatusBarHelper.setRootViewFitsSystemWindows(activity);
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        StatusBarHelper.getStatusBarView(activity, decorView).setBackgroundColor(calculateColor);
    }

    private static void setRootViewFitsSystemWindows(@NonNull Activity activity) {
        View content = activity.findViewById(0x1020002);
        content.setSystemUiVisibility(1024);
    }

    public static void setDrawable(Activity activity, Drawable drawable2) {
        StatusBarHelper.setStatusBarColor(activity, StatusBarHelper.getColor(activity, 17170445));
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        StatusBarHelper.getStatusBarView(activity, decorView).setBackground(drawable2);
    }

    public static void setDrawLayoutColor(Activity activity, @NonNull DrawerLayout drawer, int color2) {
        StatusBarHelper.setDrawLayoutColor(activity, drawer, color2, false);
    }

    public static void setDrawLayoutColor(Activity activity, @NonNull DrawerLayout drawer, int color2, boolean isTranslucent) {
        StatusBarHelper.setStatusBarColor(activity, StatusBarHelper.getColor(activity, 17170445));
        ViewGroup decorViewLayout = (ViewGroup)drawer.getChildAt(0);
        View contentView = StatusBarHelper.getStatusBarView(activity, decorViewLayout);
        contentView.setBackgroundColor(StatusBarHelper.getColor(activity, color2));
        if (!isTranslucent) {
            contentView.setFitsSystemWindows(true);
        }
        StatusBarHelper.setRootViewFitsSystemWindows(activity);
        if (!(decorViewLayout instanceof LinearLayout) && decorViewLayout.getChildAt(1) != null) {
            decorViewLayout.getChildAt(1).setPadding(decorViewLayout.getPaddingLeft(), decorViewLayout.getPaddingTop() + StatusBarHelper.getStatusBarHeight((Context)activity), decorViewLayout.getPaddingRight(), decorViewLayout.getPaddingBottom());
        }
    }

    private static View getStatusBarView(Activity activity, @NonNull ViewGroup decorView) {
        View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
        if (fakeStatusBarView == null) {
            fakeStatusBarView = StatusBarHelper.createStatusBarView(activity);
            decorView.addView(fakeStatusBarView, 0);
        }
        return fakeStatusBarView;
    }

    private static View createStatusBarView(Activity activity) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarHelper.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setTag((Object)FAKE_STATUS_BAR_VIEW_ID);
        statusBarView.setId(FAKE_STATUS_BAR_VIEW_ID);
        return statusBarView;
    }

    public static void setColorForSwipeBack(Activity activity, int color2) {
        StatusBarHelper.setColorForSwipeBack(activity, color2, 112);
    }

    public static void setColorForSwipeBack(Activity activity, @ColorInt int color2, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (!OsHelper.isLollipop()) {
            return;
        }
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View rootView = contentView.getChildAt(0);
        int statusBarHeight = StatusBarHelper.getStatusBarHeight((Context)activity);
        if (rootView instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)rootView;
            coordinatorLayout.setStatusBarBackgroundColor(StatusBarHelper.calculateColorByAlpha(color2, statusBarAlpha));
        } else {
            contentView.setPadding(0, statusBarHeight, 0, 0);
            contentView.setBackgroundColor(StatusBarHelper.calculateColorByAlpha(color2, statusBarAlpha));
        }
        StatusBarHelper.setColor(activity, 17170445);
    }

    public static void setStatusBarTextStyle(Activity activity, boolean dark) {
        if (OsHelper.isMarshmallow()) {
            activity.getWindow().getDecorView().setSystemUiVisibility(dark ? 8192 : 256);
        }
    }

    public static void setStatusBarColor(@NonNull Activity activity, int color2) {
        Window window = activity.getWindow();
        if (OsHelper.isLollipop()) {
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(color2);
        } else {
            window.addFlags(0x4000000);
        }
    }

    public static int getStatusBarHeight(@NonNull Context context) {
        return context.getResources().getDimensionPixelSize(context.getResources().getIdentifier("status_bar_height", "dimen", "android"));
    }

    public static int getActionBarHeight(@NonNull Context context) {
        TypedValue t = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, t, true)) {
            return TypedValue.complexToDimensionPixelSize((int)t.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return -1;
    }

    public static void adjustViewHeightForHideStatusBar(Activity activity, @NonNull View view) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        params.topMargin += StatusBarHelper.getStatusBarHeight((Context)activity);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static void adjustToolbarHeightForHideStatusBar(Activity activity, @NonNull View view) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        params.height = StatusBarHelper.getStatusBarHeight((Context)activity) + StatusBarHelper.getActionBarHeight((Context)activity);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarHelper.getStatusBarHeight((Context)activity), view.getPaddingRight(), view.getPaddingBottom());
    }

    public static int calculateColorByAlpha(@ColorInt int color2, int alpha) {
        if (alpha == 0) {
            return color2;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color2 >> 16 & 0xFF;
        int green = color2 >> 8 & 0xFF;
        int blue = color2 & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static int getColor(@NonNull Activity activity, @ColorRes int color2) {
        return activity.getResources().getColor(color2);
    }
}

