/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.os;

import android.app.Activity;
import android.app.Service;
import android.os.Process;
import com.dzenm.helper.log.Logger;
import java.util.Stack;

public class ActivityHelper {
    private static final String TAG = ActivityHelper.class.getSimpleName() + "|";
    private static volatile ActivityHelper sActivityHelper;
    private static Stack<Activity> sActivityStack;
    private static Stack<Service> sServiceStack;

    private ActivityHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityHelper getInstance() {
        if (sActivityHelper != null) return sActivityHelper;
        Class<ActivityHelper> clazz = ActivityHelper.class;
        synchronized (ActivityHelper.class) {
            if (sActivityHelper != null) return sActivityHelper;
            sActivityHelper = new ActivityHelper();
            sActivityStack = new Stack();
            sServiceStack = new Stack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sActivityHelper;
        }
    }

    public boolean isAlive(Class<?> clazz) {
        if (this.isEmpty(sActivityStack)) {
            return false;
        }
        for (Activity activity : sActivityStack) {
            if (!activity.getClass().equals(clazz)) continue;
            Logger.d(TAG + clazz.getSimpleName() + " isAlive");
            return true;
        }
        Logger.d(TAG + clazz.getSimpleName() + " not isAlive");
        return false;
    }

    public ActivityHelper add(Activity activity) {
        if (sActivityStack == null) {
            throw new NullPointerException("activity stack is null");
        }
        Logger.d(TAG + "add activity: " + activity.getClass().getSimpleName());
        sActivityStack.add(activity);
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public ActivityHelper remove(Activity activity) {
        if (!this.isEmpty(sActivityStack)) {
            sActivityStack.remove(activity);
        }
        Logger.d(TAG + "remove activity: " + activity.getClass().getSimpleName());
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public <T extends Activity> T get(Class<T> clazz) {
        if (this.isEmpty(sActivityStack)) {
            return null;
        }
        for (Activity activity : sActivityStack) {
            if (!activity.getClass().equals(clazz)) continue;
            Logger.d(TAG + "get activity: " + clazz.getSimpleName());
            return (T)activity;
        }
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return null;
    }

    public Activity getTop() {
        if (!this.isEmpty(sActivityStack)) {
            return (Activity)sActivityStack.lastElement();
        }
        Logger.d(TAG + "get top activity: " + ((Activity)sActivityStack.lastElement()).getClass().getSimpleName());
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return null;
    }

    public Stack<Activity> getAll() {
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return sActivityStack;
    }

    public ActivityHelper finish(Activity activity) {
        if (this.isEmpty(sActivityStack)) {
            return this;
        }
        if (activity.isFinishing()) {
            return this;
        }
        Logger.d(TAG + "finish activity: " + activity.getClass().getSimpleName());
        activity.finish();
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public ActivityHelper finish(Class clazz) {
        if (this.isEmpty(sActivityStack)) {
            return this;
        }
        for (Activity activity : sActivityStack) {
            if (!activity.getClass().equals(clazz)) continue;
            Logger.d(TAG + "finish activity: " + activity.getClass().getSimpleName());
            this.finish(activity);
            break;
        }
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public ActivityHelper finishOthers(Class clazz) {
        if (this.isEmpty(sActivityStack)) {
            return this;
        }
        Logger.d(TAG + "finish others activity except " + clazz.getSimpleName());
        for (Activity activity : sActivityStack) {
            if (activity.getClass().equals(clazz)) continue;
            activity.finish();
        }
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public ActivityHelper finishAll() {
        if (this.isEmpty(sActivityStack)) {
            return this;
        }
        for (Activity activity : sActivityStack) {
            activity.finish();
        }
        Logger.d(TAG + "finish all activity");
        sActivityStack.clear();
        Logger.d(TAG + "activity stack's size is " + sActivityStack.size());
        return this;
    }

    public ActivityHelper add(Service service) {
        if (sServiceStack == null) {
            throw new NullPointerException("service stack is null");
        }
        Logger.d(TAG + "add service: " + service.getClass().getSimpleName());
        sServiceStack.add(service);
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return this;
    }

    public ActivityHelper remove(Service service) {
        if (this.isEmpty(sServiceStack)) {
            return this;
        }
        Logger.d(TAG + "remove service: " + service.getClass().getSimpleName());
        sServiceStack.remove(service);
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return this;
    }

    public <T> T getService(Class<?> clazz) {
        if (this.isEmpty(sServiceStack)) {
            return null;
        }
        for (Service service : sServiceStack) {
            if (!service.getClass().equals(clazz)) continue;
            Logger.d(TAG + "get services: " + service.getClass().getSimpleName());
            return (T)service;
        }
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return null;
    }

    public Service getTopService() {
        if (this.isEmpty(sServiceStack)) {
            return null;
        }
        Logger.d(TAG + "get top service: " + ((Service)sServiceStack.lastElement()).getClass().getSimpleName());
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return (Service)sServiceStack.lastElement();
    }

    public ActivityHelper stop(Service service) {
        if (this.isEmpty(sServiceStack)) {
            return this;
        }
        Logger.d(TAG + "stop services: " + service.getClass().getSimpleName());
        service.stopSelf();
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return this;
    }

    public ActivityHelper stop(Class cla) {
        if (this.isEmpty(sServiceStack)) {
            return this;
        }
        for (Service service : sServiceStack) {
            if (!service.getClass().equals(cla)) continue;
            Logger.d(TAG + "stop services: " + service.getClass().getSimpleName());
            service.stopSelf();
            break;
        }
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return this;
    }

    public ActivityHelper stop() {
        if (this.isEmpty(sServiceStack)) {
            return this;
        }
        for (Service service : sServiceStack) {
            service.stopSelf();
        }
        Logger.d(TAG + "stop all services");
        sServiceStack.clear();
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return this;
    }

    public Stack<Service> getService() {
        Logger.d(TAG + "service stack's size is " + sServiceStack.size());
        return sServiceStack;
    }

    public void exit() {
        try {
            this.finishAll();
            this.stop();
            Logger.d(TAG + "exit and finish all activity with service");
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isEmpty(Stack stack) {
        if (stack == null) {
            throw new NullPointerException("stack is null, please initialize before use");
        }
        return stack.isEmpty();
    }
}

