/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.net.NetHelper;

class NetBroadcast
extends BroadcastReceiver {
    private static final String TAG = NetBroadcast.class.getSimpleName() + "|";
    private boolean mRegister = false;
    private static NetBroadcast sNetBroadcast;
    private NetHelper.OnNetworkChangeListener mOnNetworkChangeListener;

    private NetBroadcast() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetBroadcast getInstance() {
        if (sNetBroadcast != null) return sNetBroadcast;
        Class<NetBroadcast> clazz = NetBroadcast.class;
        synchronized (NetBroadcast.class) {
            if (sNetBroadcast != null) return sNetBroadcast;
            sNetBroadcast = new NetBroadcast();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sNetBroadcast;
        }
    }

    public boolean isRegister() {
        return this.mRegister;
    }

    void setOnNetworkChangeListener(NetHelper.OnNetworkChangeListener onNetworkChangeListener) {
        this.mOnNetworkChangeListener = onNetworkChangeListener;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction() != null && intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            boolean isConnected = NetHelper.isConnected(context);
            if (this.mOnNetworkChangeListener != null) {
                Logger.i(TAG + "network broadcast receive connect state: " + isConnected);
                this.mOnNetworkChangeListener.onNetwork(isConnected);
            }
        }
    }

    void registerNetwork(Context context) {
        if (this.mRegister) {
            return;
        }
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this, intentFilter);
            this.mRegister = true;
            Logger.i(TAG + "register network broadcast");
        }
        catch (Exception e) {
            Logger.i(TAG + "register network broadcast error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    void unregisterNetwork(Context context) {
        if (!this.mRegister) {
            return;
        }
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            this.mRegister = false;
            Logger.i(TAG + "unregister network broadcast");
        }
        catch (Exception e) {
            Logger.i(TAG + "unregister network broadcast error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

