/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.dzenm.helper.date.DateHelper;
import com.dzenm.helper.file.FileHelper;
import com.dzenm.helper.log.Logger;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class CrashHelper
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashHelper.class.getSimpleName() + "|";
    private static final String PATH = "/crash";
    private static final String NAME = "crash_";
    private static final String SUFFIX = ".txt";
    private Context mContext;
    private Thread.UncaughtExceptionHandler mDefaultExceptionHandle;
    @SuppressLint(value={"StaticFieldLeak"})
    private static CrashHelper sCrashHelper;

    private CrashHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrashHelper getInstance() {
        if (sCrashHelper != null) return sCrashHelper;
        Class<CrashHelper> clazz = CrashHelper.class;
        synchronized (CrashHelper.class) {
            if (sCrashHelper != null) return sCrashHelper;
            sCrashHelper = new CrashHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sCrashHelper;
        }
    }

    public CrashHelper init(Context context) {
        this.mContext = context.getApplicationContext();
        this.mDefaultExceptionHandle = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        return this;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (this.catchCaughtException(ex) && this.mDefaultExceptionHandle != null) {
            this.mDefaultExceptionHandle.uncaughtException(thread, ex);
        } else {
            Process.killProcess((int)Process.myPid());
        }
    }

    private boolean catchCaughtException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                Toast.makeText((Context)CrashHelper.this.mContext, (CharSequence)"\u7a0b\u5e8f\u53d1\u751f\u5d29\u6e83\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00", (int)0).show();
                Looper.loop();
            }
        }).start();
        String throwable = this.outputExceptionInfo(ex);
        Map<String, String> info = this.collectDeviceInfo();
        String crashInfo = this.collectCrashInfo(throwable, info);
        String fileName = NAME + DateHelper.getCurrentTimeMillis() + SUFFIX;
        FileHelper.getInstance().newFile(this.getCrashDirect().getPath(), fileName, crashInfo);
        FileHelper.getInstance().delete(this.getCrashDirect(), fileName);
        return true;
    }

    private String outputExceptionInfo(Throwable ex) {
        Logger.e(TAG + "\u5f00\u59cb\u8f93\u51fa\u5f02\u5e38\u4fe1\u606f");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable throwable = ex.getCause(); throwable != null; throwable = throwable.getCause()) {
            throwable.printStackTrace(printWriter);
            printWriter.append("\r\n");
        }
        printWriter.close();
        Logger.e(TAG + "\u8f93\u51fa\u5f02\u5e38\u4fe1\u606f\u5b8c\u6210");
        return ((Object)writer).toString();
    }

    private Map<String, String> collectDeviceInfo() {
        Logger.e(TAG + "\u5f00\u59cb\u6536\u96c6\u8bbe\u5907\u53c2\u6570\u4fe1\u606f");
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            Field[] fields;
            for (Field field : fields = Build.class.getDeclaredFields()) {
                field.setAccessible(true);
                info.put(field.getName(), field.get("").toString());
            }
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 1);
            if (packageInfo != null) {
                info.put("\u5b89\u5353\u7248\u672c\u53f7", Build.VERSION.RELEASE);
                info.put("Target\u7248\u672c", Build.VERSION.SDK_INT + "");
                info.put("App\u7248\u672c\u540d\u79f0", packageInfo.versionName);
                info.put("App\u7248\u672c\u53f7", packageInfo.versionCode + "");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG + "\u6536\u96c6\u8bbe\u5907\u53c2\u6570\u4fe1\u606f\u5931\u8d25: " + (Object)((Object)e));
        }
        catch (IllegalAccessException e) {
            Logger.e(TAG + "\u6536\u96c6\u8bbe\u5907\u53c2\u6570\u4fe1\u606f\u5931\u8d25: " + e);
        }
        Logger.e(TAG + "\u6536\u96c6\u8bbe\u5907\u53c2\u6570\u4fe1\u606f\u5b8c\u6210");
        return info;
    }

    private String collectCrashInfo(String throwable, Map<String, String> info) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("-------- \u5f00\u59cb\u6536\u96c6\u8bbe\u5907\u4fe1\u606f --------\n");
        for (Map.Entry<String, String> entry : info.entrySet()) {
            stringBuffer.append(entry.getKey()).append(" ------ ").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("-------- \u8bbe\u5907\u4fe1\u606f\u6536\u96c6\u5b8c\u6210 --------\n\n\n");
        stringBuffer.append("-------- \u5f00\u59cb\u6536\u96c6\u5f02\u5e38\u4fe1\u606f --------\n");
        stringBuffer.append(throwable).append("\n");
        stringBuffer.append("-------- \u5f02\u5e38\u4fe1\u606f\u6536\u96c6\u5b8c\u6210 --------");
        return stringBuffer.toString();
    }

    private File getCrashDirect() {
        return FileHelper.getInstance().getFolder(PATH);
    }
}

