/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.file;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.core.content.FileProvider;
import com.dzenm.helper.date.DateHelper;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class FileHelper {
    private static final String TAG = FileHelper.class.getSimpleName() + "|";
    private Context mContext;
    private String mAppFolder;
    private String mPersonFolder;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile FileHelper sInstance;

    private FileHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<FileHelper> clazz = FileHelper.class;
        synchronized (FileHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FileHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public FileHelper init(Context context) {
        this.init(context, null);
        return this;
    }

    public FileHelper init(Context context, String companyFolder) {
        this.init(context, companyFolder, OsHelper.getAppName(context));
        return this;
    }

    public FileHelper init(Context context, String companyFolder, String appName) {
        this.mContext = context;
        if (TextUtils.isEmpty((CharSequence)companyFolder)) {
            this.createAppFolder(appName);
        } else if (TextUtils.isEmpty((CharSequence)appName)) {
            this.createAppFolder(companyFolder);
        } else {
            this.createAppFolder(companyFolder + File.separator + appName);
        }
        return this;
    }

    public FileHelper setPersonFolder(String personFolder) {
        this.mPersonFolder = personFolder;
        return this;
    }

    private void createAppFolder(String appPath) {
        if (TextUtils.isEmpty((CharSequence)appPath)) {
            throw new NullPointerException("App \u6587\u4ef6\u5939\u8def\u5f84 is null");
        }
        if (!this.isExternal()) {
            return;
        }
        File file = this.mkdir(Environment.getExternalStorageDirectory() + File.separator + appPath);
        this.mAppFolder = file.getAbsolutePath();
        Logger.d(TAG + "App\u6587\u4ef6\u5939\u8def\u5f84: " + this.mAppFolder);
    }

    public String getPath(String folder) {
        return this.getFolder(folder).getPath();
    }

    public File getFolder(String folder) {
        if (TextUtils.isEmpty((CharSequence)this.mAppFolder) || TextUtils.isEmpty((CharSequence)folder)) {
            return null;
        }
        if (!folder.startsWith("/")) {
            return null;
        }
        return this.mkdir(this.mAppFolder + folder);
    }

    public File getPersonFolder(String folder) {
        if (TextUtils.isEmpty((CharSequence)this.mPersonFolder) || TextUtils.isEmpty((CharSequence)folder)) {
            return null;
        }
        if (!folder.startsWith("/")) {
            return null;
        }
        return this.mkdir(this.mAppFolder + File.separator + this.mPersonFolder + folder);
    }

    public Uri getUri(File file) {
        if (OsHelper.isNougat()) {
            return FileProvider.getUriForFile((Context)this.mContext, (String)(this.mContext.getPackageName() + ".provider"), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public String getRealFilePath(Uri uri) {
        if (null == uri) {
            return null;
        }
        String path = this.getFilePathByUri(uri);
        if (path == null) {
            return uri.getPath();
        }
        return path;
    }

    private String getFilePathByUri(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return null;
        }
        if ("file".equalsIgnoreCase(scheme)) {
            return uri.getPath();
        }
        if ("content".equalsIgnoreCase(scheme)) {
            if (this.isGooglePhotosUri(uri)) {
                return uri.getLastPathSegment();
            }
            if (this.isGooglePlayPhotosUri(uri)) {
                return this.getImageUriWithAuthority(uri);
            }
            return this.getDataColumn(uri);
        }
        return uri.getPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDataColumn(Uri uri) {
        String column = "_data";
        String[] projection = new String[]{column};
        try (Cursor cursor = this.mContext.getContentResolver().query(uri, projection, null, null, null, null);){
            if (null == cursor) return null;
            if (!cursor.moveToFirst()) return null;
            int columnIndex = cursor.getColumnIndexOrThrow(column);
            if (columnIndex <= -1) return null;
            String string2 = cursor.getString(columnIndex);
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    private boolean isGooglePlayPhotosUri(Uri uri) {
        return "com.google.android.apps.photos.contentprovider".equals(uri.getAuthority());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getImageUriWithAuthority(Uri uri) {
        if (uri.getAuthority() == null) return null;
        try (InputStream is = this.mContext.getContentResolver().openInputStream(uri);){
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)is);
            String string2 = this.writeToTempImageAndGetPathUri(bmp).toString();
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Uri writeToTempImageAndGetPathUri(Bitmap inImage) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        inImage.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
        String path = MediaStore.Images.Media.insertImage((ContentResolver)this.mContext.getContentResolver(), (Bitmap)inImage, (String)"title", null);
        return Uri.parse((String)path);
    }

    public String getMimeType(String filePath) {
        String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath);
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
    }

    public boolean delete(File folder) {
        return this.delete(folder, "");
    }

    public boolean delete(String path) {
        return this.delete(path, "");
    }

    public boolean delete(String path, String filterName) {
        return this.delete(new File(path), filterName);
    }

    public boolean delete(File folder, String filterName) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return false;
        }
        Logger.d(TAG + folder.getPath() + "\u6587\u4ef6\u5939\u91cc\u5171\u6709" + files.length + "\u4e2a\u6587\u4ef6");
        boolean isDelete = true;
        for (File file : files) {
            if (file.getName().equals(filterName) || file.isDirectory()) continue;
            if (file.exists()) {
                isDelete = file.delete();
            }
            if (!isDelete) break;
        }
        Logger.d(TAG + "\u6587\u4ef6\u5220\u9664" + (isDelete ? "\u6210\u529f" : "\u5931\u8d25"));
        return isDelete;
    }

    public void deleteFolder(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null || children.length == 0) {
                file.delete();
                return;
            }
            for (File f : children) {
                this.delete(f);
            }
            file.delete();
        }
    }

    public String savePhoto(Bitmap bitmap, String path) {
        return this.savePhoto(bitmap, new File(path));
    }

    public String savePhoto(Bitmap bitmap, File file) {
        String fileName = DateHelper.getCurrentTimeMillis() + ".jpeg";
        this.savePhoto(bitmap, new File(file, fileName));
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean savePhoto(Bitmap bitmap, File parent, String photoName) {
        File file = new File(parent, photoName);
        if (file.exists()) {
            file.delete();
        }
        this.createNewFile(file);
        Logger.d(TAG + "save the photo's path: " + file.getPath());
        try (FileOutputStream fos = new FileOutputStream(file);){
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Bitmap getPhoto(File parent, String photoName) {
        return this.getPhoto(new File(parent, photoName));
    }

    public Bitmap getPhoto(String parent, String photoName) {
        return this.getPhoto(parent + File.separator + photoName);
    }

    public Bitmap getPhoto(Uri uri) {
        return this.getPhoto(this.getRealFilePath(uri));
    }

    public Bitmap getPhoto(String path) {
        return this.getPhoto(new File(path));
    }

    public Bitmap getPhoto(File file) {
        if (!this.isFile(file)) {
            return null;
        }
        Logger.d(TAG + "get the photo's path: " + file.getPath());
        return BitmapFactory.decodeFile((String)file.getPath());
    }

    public boolean isExternal() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public boolean newFile(String parent, String fileName, String content) {
        return this.newFile(new File(parent, fileName), content);
    }

    /*
     * Exception decompiling
     */
    public boolean newFile(File file, String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newFile(ArrayList tArrayList, String filePath) {
        File file = new File(filePath);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file.toString()));){
            objectOutputStream.writeObject(tArrayList);
            Logger.d("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f: " + filePath);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.d("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newFile(String fileName, String content) {
        try (FileOutputStream fos = this.mContext.openFileOutput(fileName, 0);){
            fos.write(content.getBytes());
            Logger.d("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.d("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newFile(String fileName, Serializable serializable) {
        try (ObjectOutputStream oos = new ObjectOutputStream(this.mContext.openFileOutput(fileName, 0));){
            oos.writeObject(serializable);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newFile(String fileName, Parcelable parcelable) {
        try (FileOutputStream fos = this.mContext.openFileOutput(fileName, 0);){
            Parcel parcel = Parcel.obtain();
            parcel.writeParcelable(parcelable, 1);
            byte[] data = parcel.marshall();
            fos.write(data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newFile(String fileName, List<Parcelable> parcelableList) {
        try (FileOutputStream fos = this.mContext.openFileOutput(fileName, 0);){
            assert (parcelableList != null);
            Parcel parcel = Parcel.obtain();
            parcel.writeList(parcelableList);
            byte[] data = parcel.marshall();
            fos.write(data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.d("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean rename(String oldFilePath, String newFileName) {
        return this.rename(new File(oldFilePath), newFileName);
    }

    public boolean rename(File oldFile, String newFileName) {
        return this.rename(oldFile, new File(oldFile.getParent(), newFileName));
    }

    public boolean rename(File oldFile, File newFile) {
        if (!oldFile.exists()) {
            return false;
        }
        if (newFile.exists()) {
            return false;
        }
        oldFile.renameTo(newFile);
        return true;
    }

    public String readFile(String filePath) {
        return this.readFile(new File(filePath));
    }

    public String readFile(File file) {
        if (!this.isFile(file)) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    public ArrayList readArrayListFile(String filePath) {
        File file = new File(filePath);
        if (!this.isFile(file)) {
            return null;
        }
        ArrayList savedArrayList = new ArrayList();
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
            savedArrayList = (ArrayList)objectInputStream.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return savedArrayList;
    }

    public byte[] readBytes(String filePath) {
        File file = new File(filePath);
        if (!this.isFile(file)) {
            return null;
        }
        byte[] bytes = null;
        try (FileInputStream fis = new FileInputStream(file);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[4096];
            while ((count = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, count);
            }
            bytes = bos.toByteArray();
            bos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public byte[] readBytes(Bitmap bitmap) {
        byte[] bytes = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            bytes = out.toByteArray();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * Exception decompiling
     */
    public String readAssets(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Parcelable readParcelable(String fileName, ClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Parcelable> readParcelableList(String fileName, ClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable readSerializable(String fileName) {
        try (ObjectInputStream ois = new ObjectInputStream(this.mContext.openFileInput(fileName));){
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean copyDBToSDCard(String databaseName) {
        String oldPath = this.mContext.getDatabasePath(databaseName).getPath();
        File file = this.getFolder("/Databases");
        if (!file.exists()) {
            file.mkdirs();
        }
        String newPath = file.getPath() + File.separator + databaseName;
        Logger.d(TAG + newPath);
        return this.copyFile(oldPath, newPath);
    }

    public boolean copySDCardToDB(String databaseName) {
        File file = this.getFolder("/Databases");
        if (!file.exists()) {
            file.mkdirs();
        }
        String oldPath = file.getPath() + File.separator + databaseName;
        String newPath = this.mContext.getDatabasePath(databaseName).getPath();
        return this.copyFile(oldPath, newPath);
    }

    public boolean copyFile(String oldPath, String newPath) {
        return this.copyFile(new File(oldPath), new File(newPath));
    }

    public boolean copyFile(File oldFile, String newPath) {
        return this.copyFile(oldFile, new File(newPath));
    }

    public boolean copyFile(String oldFile, File newFile) {
        return this.copyFile(new File(oldFile), newFile);
    }

    /*
     * Loose catch block
     */
    public boolean copyFile(File oldFile, File newFile) {
        block32: {
            boolean bl;
            Throwable throwable;
            FileOutputStream fos;
            Throwable throwable2;
            FileInputStream inStream;
            block30: {
                block31: {
                    block28: {
                        block29: {
                            if (!this.createNewFile(newFile)) {
                                return false;
                            }
                            if (!oldFile.exists()) break block32;
                            inStream = new FileInputStream(oldFile);
                            throwable2 = null;
                            fos = new FileOutputStream(newFile);
                            throwable = null;
                            byte[] buffer = new byte[1024];
                            int len = 0;
                            int byteread = 0;
                            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                                len += byteread;
                                fos.write(buffer, 0, byteread);
                            }
                            fos.flush();
                            Logger.d(TAG + "\u590d\u5236\u6587\u4ef6\u6210\u529f: " + newFile.getPath());
                            bl = true;
                            if (fos == null) break block28;
                            if (throwable == null) break block29;
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block28;
                        }
                        fos.close();
                    }
                    if (inStream == null) break block30;
                    if (throwable2 == null) break block31;
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    break block30;
                }
                ((InputStream)inStream).close();
            }
            return bl;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (fos != null) {
                                        if (throwable != null) {
                                            try {
                                                fos.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            fos.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (inStream != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((InputStream)inStream).close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable2.addSuppressed(throwable10);
                                    }
                                } else {
                                    ((InputStream)inStream).close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (Exception e) {
                        Logger.d(TAG + "\u590d\u5236\u6587\u4ef6\u51fa\u9519");
                        e.printStackTrace();
                    }
                }
            }
        }
        Logger.d(TAG + "\u590d\u5236\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
        return false;
    }

    public Bitmap drawableToBitmap(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    public String md5(String string2) {
        if (string2.length() < 1) {
            return "";
        }
        try {
            byte[] bytes = MessageDigest.getInstance("MD5Util").digest(string2.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result.append(temp);
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String md5(File file) {
        try (FileInputStream ins = new FileInputStream(file);){
            byte[] bytes;
            StringBuilder result = new StringBuilder();
            MappedByteBuffer byteBuffer = ins.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance("MD5Util");
            md5.update(byteBuffer);
            for (byte b : bytes = md5.digest()) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result.append(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private boolean isFile(File file) {
        if (!this.isExternal()) {
            return false;
        }
        if (!file.exists()) {
            Logger.d(TAG + "file is not exists");
            return false;
        }
        if (file.isDirectory()) {
            Logger.d(TAG + "file is directory");
            return false;
        }
        return true;
    }

    private boolean createNewFile(String filePath) {
        return this.createNewFile(new File(filePath));
    }

    private boolean createNewFile(File file) {
        if (!this.isExternal()) {
            return false;
        }
        if (file.exists()) {
            Logger.d(TAG + "file is exists");
            return false;
        }
        if (file.isDirectory()) {
            Logger.d(TAG + "file is directory");
            return false;
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private File mkdir(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        file.mkdirs();
        Logger.d(TAG + "create new folder and the path: " + file.getPath());
        return file;
    }
}

