/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.dialog.AnimatorHelper;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.download.DownloadHelper;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.toast.Toa;
import com.dzenm.helper.view.ProgressBar;

@SuppressLint(value={"ValidFragment"})
public class UpGradeDialog
extends AbsDialogFragment
implements View.OnClickListener,
DownloadHelper.OnDownloadListener {
    private int mHeadImage;
    private String mVersionName;
    private String mSize;
    private String mDesc;
    private int mStyleColor;
    private ProgressBar mProgressBar;
    private boolean isUpdate;
    private boolean isCanCancel;
    private DownloadHelper mDownloadHelper;
    private TextView tvUpgrade;
    private OnRequestListener mOnRequestListener;

    public static UpGradeDialog newInstance(AppCompatActivity activity) {
        return new UpGradeDialog(activity);
    }

    public UpGradeDialog setUrl(String url) {
        this.mDownloadHelper.setUrl(url);
        return this;
    }

    public UpGradeDialog setFilePath(String filePath) {
        this.mDownloadHelper.setFilePath(filePath);
        return this;
    }

    public UpGradeDialog setVersionName(@NonNull String versionName) {
        this.mDownloadHelper.setVersionName(versionName);
        this.mVersionName = versionName;
        return this;
    }

    public UpGradeDialog setSize(@NonNull String size) {
        this.mSize = size;
        return this;
    }

    public UpGradeDialog setDesc(@NonNull String desc) {
        this.mDesc = desc;
        return this;
    }

    public UpGradeDialog setNewVersionCode(long newVersionCode) {
        this.isUpdate = this.verifyVersion(newVersionCode);
        return this;
    }

    public void update() {
        if (!this.isCanCancel) {
            this.setCancel(false);
        }
        if (this.isUpdate) {
            this.show();
        } else {
            Toa.show("\u5f53\u524d\u5df2\u662f\u6700\u65b0\u7248\u672c");
        }
    }

    public UpGradeDialog setCanCancel(boolean canCancel) {
        this.isCanCancel = canCancel;
        return this;
    }

    public UpGradeDialog setHeadImage(int headImage) {
        this.mHeadImage = headImage;
        return this;
    }

    public UpGradeDialog setStyleColor(int styleColor) {
        this.mStyleColor = styleColor;
        return this;
    }

    public UpGradeDialog setOnRequestListener(OnRequestListener onRequestListener) {
        this.mOnRequestListener = onRequestListener;
        return this;
    }

    public UpGradeDialog setMargin(int margin) {
        return (UpGradeDialog)super.setMargin(margin);
    }

    public UpGradeDialog setGravity(int gravity) {
        return (UpGradeDialog)super.setGravity(gravity);
    }

    public UpGradeDialog setAnimator(int animator) {
        return (UpGradeDialog)super.setAnimator(animator);
    }

    public UpGradeDialog setBackground(Drawable background) {
        return (UpGradeDialog)super.setBackground(background);
    }

    public UpGradeDialog setTranslucent(boolean translucent) {
        return (UpGradeDialog)super.setTranslucent(translucent);
    }

    public UpGradeDialog setCancel(boolean cancel) {
        return (UpGradeDialog)super.setCancel(cancel);
    }

    public UpGradeDialog setTouchInOutSideCancel(boolean cancel) {
        return (UpGradeDialog)super.setTouchInOutSideCancel(cancel);
    }

    public UpGradeDialog setRadiusCard(float radiusCard) {
        return (UpGradeDialog)super.setRadiusCard(radiusCard);
    }

    @Override
    protected int layoutId() {
        return R.layout.dialog_upgrade;
    }

    public UpGradeDialog(AppCompatActivity activity) {
        super(activity);
        this.mBackground = BackGHelper.solid(17170445).build();
        this.mHeadImage = R.drawable.ic_upgrade_top;
        this.mStyleColor = 0x1060016;
        this.mAnimator = AnimatorHelper.overshoot();
        this.isCanCancel = true;
        this.mDownloadHelper = new DownloadHelper((Context)activity);
        this.mDownloadHelper.setOnDownloadListener(this);
    }

    @Override
    protected void initView() {
        ImageView ivHead = (ImageView)this.findViewById(R.id.iv_header);
        TextView tvVersion = (TextView)this.findViewById(R.id.tv_version);
        TextView tvSize = (TextView)this.findViewById(R.id.tv_size);
        TextView tvDesc = (TextView)this.findViewById(R.id.tv_desc);
        this.mProgressBar = (ProgressBar)((Object)this.findViewById(R.id.progress_bar));
        LinearLayout llContent = (LinearLayout)this.findViewById(R.id.ll_content);
        ivHead.setImageResource(this.mHeadImage);
        this.mProgressBar.setProgressColor(this.getColor(this.mStyleColor));
        if (TextUtils.isEmpty((CharSequence)this.mVersionName)) {
            tvVersion.setVisibility(8);
        } else {
            tvVersion.setText((CharSequence)this.mVersionName);
            tvVersion.setTextColor(this.mSecondaryTextColor);
        }
        if (TextUtils.isEmpty((CharSequence)this.mSize)) {
            tvSize.setVisibility(8);
        } else {
            tvSize.setText((CharSequence)this.mSize);
            tvSize.setTextColor(this.mSecondaryTextColor);
        }
        if (TextUtils.isEmpty((CharSequence)this.mDesc)) {
            tvDesc.setVisibility(8);
        } else {
            tvDesc.setText((CharSequence)this.mDesc);
            tvDesc.setTextColor(this.mSecondaryTextColor);
        }
        BackGHelper.solid(17170443).radiusBR(this.mRadiusCard).radiusBL(this.mRadiusCard).into((View)llContent);
        this.tvUpgrade = (TextView)this.findViewById(R.id.tv_upgrade);
        this.tvUpgrade.setOnClickListener((View.OnClickListener)this);
        BackGHelper.radius(this.mRadiusCard).pressed(this.mStyleColor, this.mPressedColor).textColor(17170443, this.mStyleColor).into((View)this.tvUpgrade);
        ImageView iv_cancel = (ImageView)this.findViewById(R.id.iv_cancel);
        iv_cancel.setOnClickListener((View.OnClickListener)this);
        iv_cancel.setImageResource(R.drawable.ic_upgrade_cancel);
    }

    @Override
    protected void setLayoutParams(ViewGroup.MarginLayoutParams layoutParams) {
        layoutParams.width = (int)((double)OsHelper.getDisplayWidth() * 0.7);
    }

    public void setLoadProgressVisible(boolean visible) {
        this.tvUpgrade.setVisibility(visible ? 8 : 0);
        this.mProgressBar.setVisibility(visible ? 0 : 8);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_upgrade) {
            this.mProgressBar.setCurrentValue(0);
            this.setLoadProgressVisible(true);
            this.mDownloadHelper.startDownload();
        } else if (v.getId() == R.id.iv_cancel) {
            if (this.mDownloadHelper.isRunningDownload()) {
                if (this.isCanCancel) {
                    this.mDownloadHelper.cancel();
                    this.dismiss();
                }
            } else {
                this.dismiss();
            }
        }
    }

    @Override
    public void onPrepared(DownloadManager.Request request) {
        request.setNotificationVisibility(2);
        if (this.mOnRequestListener != null) {
            this.mOnRequestListener.onRequest(request);
        }
    }

    @Override
    public void onProgress(long fileSize, long soFar, int value) {
        this.mProgressBar.setCurrentValue(value);
    }

    @Override
    public void onSuccess(Uri uri, String mimeType) {
        this.dismiss();
    }

    @Override
    public void onFailed(String msg) {
        this.setLoadProgressVisible(false);
        this.showDialog("\u4e0b\u8f7d\u5931\u8d25", msg);
    }

    private void showDialog(String title, String msg) {
        InfoDialog.newInstance(this.mActivity).setTitle(title).setMessage(msg).setButtonText("\u786e\u5b9a").setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

            @Override
            public boolean onClick(InfoDialog dialog, boolean confirm) {
                return true;
            }
        }).show();
    }

    private boolean verifyVersion(long newVersionCode) {
        if (newVersionCode == 0L) {
            throw new NullPointerException("the new version code is 0, please set a new version code");
        }
        return newVersionCode > OsHelper.getVersionCode((Context)this.mActivity);
    }

    public static interface OnRequestListener {
        public void onRequest(DownloadManager.Request var1);
    }
}

