/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialog;
import com.dzenm.helper.dialog.AnimatorHelper;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.os.OsHelper;

public class PromptDialog
extends AbsDialog {
    public static final int LOADING_POINT_ALPHA = 1001;
    public static final int LOADING_POINT_TRANS = 1002;
    public static final int LOADING_POINT_SCALE = 1003;
    public static final int LOADING_RECT_SCALE = 1004;
    public static final int LOADING_RECT_ALPHA = 1005;
    private boolean isCancel;
    private ImageView ivIconImage;
    private TextView tvLoadText;
    private boolean isAutoCancel;
    private float mCountTime = 1.5f;
    private OnCountDownListener mOnCountDownListener;
    private CountDownTimer mCountDownTimer = new CountDownTimer((long)(this.mCountTime * 1000.0f), 1000L){

        public void onTick(long millisUntilFinished) {
            if (PromptDialog.this.mOnCountDownListener != null) {
                PromptDialog.this.mOnCountDownListener.onTick((int)(millisUntilFinished / 1000L));
            }
        }

        public void onFinish() {
            PromptDialog.this.dismiss();
            if (PromptDialog.this.mCountDownTimer != null) {
                PromptDialog.this.mCountDownTimer.cancel();
            }
            if (PromptDialog.this.mOnCountDownListener != null) {
                PromptDialog.this.mOnCountDownListener.onFinish();
            }
        }
    };

    public static PromptDialog newInstance(@NonNull Context context) {
        return new PromptDialog(context);
    }

    public void showSuccess(String success) {
        this.show(success, R.drawable.prompt_success, true);
    }

    public void showError(String error) {
        this.show(error, R.drawable.prompt_error, true);
    }

    public void showWarming(String warming) {
        this.show(warming, R.drawable.prompt_warming, true);
    }

    public void showRefresh(String refresh) {
        this.show(refresh, R.drawable.prompt_refresh, true);
    }

    public PromptDialog setOnCountListener(OnCountDownListener onCountDownListener) {
        this.mOnCountDownListener = onCountDownListener;
        return this;
    }

    public PromptDialog setCountTime(int countTime) {
        this.mCountTime = countTime;
        return this;
    }

    public void showLoading(int type) {
        int icon = 0;
        if (type == 1003) {
            icon = R.drawable.prompt_loading_point_scale;
        } else if (type == 1001) {
            icon = R.drawable.prompt_loading_point_alpha;
        } else if (type == 1002) {
            icon = R.drawable.prompt_loading_point_translate;
        } else if (type == 1004) {
            icon = R.drawable.prompt_loading_rectangle_scale;
        } else if (type == 1005) {
            icon = R.drawable.prompt_loading_rectangle_alpha;
        }
        this.show(this.getContext().getResources().getString(R.string.dialog_loading), icon, false);
    }

    public void show(String loadText, int loadImg) {
        this.show(loadText, loadImg, true);
    }

    public void show(String loadText, int loadImg, boolean autoCancel) {
        this.show(loadText, loadImg, autoCancel, !autoCancel);
    }

    public void show(String loadText, int loadImg, boolean autoCancel, boolean cancel) {
        this.setPromptText(loadText);
        this.setImageResourceType(loadImg);
        this.setCancel(autoCancel, cancel);
        this.show();
    }

    protected void setPromptText(String promptText) {
        this.tvLoadText.setText((CharSequence)promptText);
    }

    protected void setCancel(boolean autoCancel, boolean cancel) {
        this.isAutoCancel = autoCancel;
        this.isCancel = cancel;
    }

    public PromptDialog setAnimator(int animator) {
        return (PromptDialog)((Object)super.setAnimator(animator));
    }

    public PromptDialog setMargin(int margin) {
        return (PromptDialog)((Object)super.setMargin(margin));
    }

    public PromptDialog setBackground(Drawable background) {
        return (PromptDialog)((Object)super.setBackground(background));
    }

    public PromptDialog setTranslucent(boolean translucent) {
        return (PromptDialog)((Object)super.setTranslucent(translucent));
    }

    public PromptDialog setTouchOutsideCancel(boolean cancel) {
        return (PromptDialog)((Object)super.setTouchOutsideCancel(cancel));
    }

    protected PromptDialog(@NonNull Context context) {
        super(context);
        this.mBackground = BackGHelper.solid(R.color.colorTranslucentDarkGray).radius(8.0f).build();
        this.mAnimator = AnimatorHelper.alpha();
        this.isCancel = true;
    }

    @Override
    public void show() {
        super.show();
        this.setCancelable(this.isCancel);
        if (this.isAutoCancel) {
            this.mCountDownTimer.start();
        }
    }

    public PromptDialog setGravity(int gravity) {
        super.setGravity(gravity);
        this.isDefaultBackground = false;
        return this;
    }

    @Override
    protected void initView() {
        super.initView();
        this.setContentView(this.createView());
    }

    private View createView() {
        View imageView;
        LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        int padding = OsHelper.dp2px(16.0f);
        linearLayout.setPadding(padding, padding, padding, padding);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)viewParams);
        if (this.isDefaultView()) {
            LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams(-2, -2);
            imgParams.gravity = 1;
            this.ivIconImage = new ImageView(this.getContext());
            imageView = this.ivIconImage;
            imageView.setLayoutParams((ViewGroup.LayoutParams)imgParams);
        } else {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(OsHelper.dp2px(60.0f), OsHelper.dp2px(60.0f));
            params.gravity = 1;
            imageView = this.getCustomizeImageView(params);
        }
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-2, -2);
        textParams.topMargin = OsHelper.dp2px(8.0f);
        this.tvLoadText = new TextView(this.getContext());
        this.tvLoadText.setMaxWidth(OsHelper.dp2px(100.0f));
        this.tvLoadText.setMinWidth(OsHelper.dp2px(90.0f));
        this.tvLoadText.setMaxLines(2);
        this.tvLoadText.setGravity(1);
        this.tvLoadText.setTextColor(-1);
        this.tvLoadText.setTextSize(12.0f);
        this.tvLoadText.setLayoutParams((ViewGroup.LayoutParams)textParams);
        linearLayout.addView(imageView);
        linearLayout.addView((View)this.tvLoadText);
        this.mView = linearLayout;
        return this.mView;
    }

    protected boolean isDefaultView() {
        return true;
    }

    protected View getCustomizeImageView(LinearLayout.LayoutParams params) {
        return null;
    }

    private void setImageResourceType(int icon) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.ivIconImage.getLayoutParams();
        layoutParams.width = icon == 1002 ? (layoutParams.height = OsHelper.dp2px(60.0f)) : (icon == 1003 || icon == 1001 || icon == 1004 || icon == 1005 ? (layoutParams.height = OsHelper.dp2px(60.0f)) : (layoutParams.height = OsHelper.dp2px(60.0f)));
        this.ivIconImage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.ivIconImage.setImageResource(icon);
        AnimatorHelper.play(this.ivIconImage.getDrawable());
    }

    @Override
    protected void setDialogLayoutParams(ViewGroup.MarginLayoutParams params) {
        params.bottomMargin = params.topMargin = OsHelper.dp2px(8 * this.mMargin);
    }

    @Override
    protected boolean isPromptDialog() {
        return true;
    }

    private static interface OnCountDownTimerListener {
        public void onTick(int var1);

        public void onFinish();
    }

    public static abstract class OnCountDownListener
    implements OnCountDownTimerListener {
        @Override
        public void onTick(int count) {
        }

        @Override
        public void onFinish() {
        }
    }
}

