/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.dialog.DatePickerDialog;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.view.PickerView;
import java.util.ArrayList;

@SuppressLint(value={"ValidFragment"})
public class PickerDialog
extends AbsDialogFragment
implements View.OnClickListener,
PickerView.onSelectListener {
    protected String[] mData;
    protected String mSelectedData;
    private String mTitle;
    protected boolean isLoop = false;
    protected ArrayList<String> mPrimaryList;
    protected ArrayList<String> mSecondaryList;
    protected ArrayList<String> mUnitList;
    protected PickerView pvPrimary;
    protected PickerView pvSecondary;
    protected PickerView pvUnit;
    protected OnSelectedCallback mOnSelectedCallback;

    public static DatePickerDialog newInstance(AppCompatActivity activity) {
        return new DatePickerDialog(activity);
    }

    public <T extends PickerDialog> T setTitle(String title) {
        this.mTitle = title;
        return (T)this;
    }

    public <T extends PickerDialog> T setTitle(int resId) {
        this.mTitle = this.getStrings(resId);
        return (T)this;
    }

    public <T extends PickerDialog> T setLoop(boolean loop) {
        this.isLoop = loop;
        return (T)this;
    }

    public <T extends PickerDialog> T setSelected(String date) {
        this.mSelectedData = date;
        return (T)this;
    }

    public <T extends PickerDialog> T setSelected(int resId) {
        this.mSelectedData = this.getStrings(resId);
        return (T)this;
    }

    public <T extends PickerDialog> T setOnSelectedCallback(OnSelectedCallback onSelectedCallback) {
        this.mOnSelectedCallback = onSelectedCallback;
        return (T)this;
    }

    protected PickerDialog(AppCompatActivity activity) {
        super(activity);
        this.mGravity = 80;
    }

    @Override
    protected int layoutId() {
        return R.layout.dialog_picker;
    }

    @Override
    protected void initView() {
        this.pvPrimary = (PickerView)((Object)this.findViewById(R.id.pv_primary));
        this.pvSecondary = (PickerView)((Object)this.findViewById(R.id.pv_secondary));
        this.pvUnit = (PickerView)((Object)this.findViewById(R.id.pv_unit));
        TextView tvCancel = (TextView)this.findViewById(R.id.tv_cancel);
        TextView tvTitle = (TextView)this.findViewById(R.id.tv_title);
        TextView tvConfirm = (TextView)this.findViewById(R.id.tv_confirm);
        TextView tvPrimary = (TextView)this.findViewById(R.id.tv_primary);
        TextView tvSecondary = (TextView)this.findViewById(R.id.tv_secondary);
        TextView tvUnit = (TextView)this.findViewById(R.id.tv_unit);
        tvCancel.setOnClickListener((View.OnClickListener)this);
        tvConfirm.setOnClickListener((View.OnClickListener)this);
        this.pvPrimary.setPrimaryTextColor(this.getColor(this.mPrimaryColor));
        this.pvSecondary.setPrimaryTextColor(this.getColor(this.mPrimaryColor));
        this.pvUnit.setPrimaryTextColor(this.getColor(this.mPrimaryColor));
        tvPrimary.setTextColor(this.getColor(this.mPrimaryColor));
        tvSecondary.setTextColor(this.getColor(this.mPrimaryColor));
        tvUnit.setTextColor(this.getColor(this.mPrimaryColor));
        tvCancel.setTextColor(this.getColor(this.mPrimaryColor));
        tvTitle.setTextColor(this.getColor(this.mPrimaryColor));
        tvConfirm.setTextColor(this.getColor(this.mPrimaryColor));
        if (this.mTitle != null) {
            tvTitle.setText((CharSequence)this.mTitle);
        }
        BackGHelper.radiusTL(this.mRadiusCard).pressed(17170445, this.mPressedColor).into((View)tvCancel);
        BackGHelper.radiusBR(this.mRadiusCard).pressed(17170445, this.mPressedColor).into((View)tvConfirm);
        this.initialViewData();
        this.setPickerViewArrayList();
        this.initialPickerView(this.isLoop);
        this.setSelectedData();
    }

    protected void initialViewData() {
    }

    protected void setPickerViewArrayList() {
        if (this.mPrimaryList == null) {
            this.mPrimaryList = new ArrayList();
        }
        if (this.mSecondaryList == null) {
            this.mSecondaryList = new ArrayList();
        }
        if (this.mUnitList == null) {
            this.mUnitList = new ArrayList();
        }
    }

    private void initialPickerView(boolean loop) {
        this.pvPrimary.setIsLoop(loop);
        this.pvSecondary.setIsLoop(loop);
        this.pvUnit.setIsLoop(loop);
        this.pvPrimary.setOnSelectListener(this);
        this.pvSecondary.setOnSelectListener(this);
        this.pvUnit.setOnSelectListener(this);
        this.pvPrimary.setData(this.mPrimaryList);
        this.pvSecondary.setData(this.mSecondaryList);
        this.pvUnit.setData(this.mUnitList);
    }

    protected void setSelectedData() {
    }

    protected String getSelected() {
        return null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.tv_confirm) {
            this.mOnSelectedCallback.onSelect(this.getSelected());
            this.dismiss();
        } else if (view.getId() == R.id.tv_cancel) {
            this.dismiss();
        }
    }

    @Override
    public void onSelect(PickerView pickerView) {
    }

    protected void executeAnimator(View view) {
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f, 1.0f});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.3f, 1.0f});
        PropertyValuesHolder pvhZ = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 1.3f, 1.0f});
        ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhZ}).setDuration(200L).start();
    }

    public static interface OnSelectedListener {
        public void onFinish();

        public void onSelect(String var1);
    }

    public static abstract class OnSelectedCallback
    implements OnSelectedListener {
        @Override
        public void onFinish() {
        }

        @Override
        public void onSelect(String date) {
        }
    }
}

