/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.os.OsHelper;

@SuppressLint(value={"ValidFragment"})
public class MenuDialog
extends AbsDialogFragment
implements View.OnClickListener {
    private String[] mItems;
    private OnItemClickListener mOnItemClickListener;

    public static MenuDialog newInstance(AppCompatActivity activity) {
        return new MenuDialog(activity);
    }

    public MenuDialog setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return this;
    }

    public MenuDialog(AppCompatActivity activity) {
        super(activity);
    }

    public MenuDialog setItem(String ... item) {
        this.mItems = item;
        return this;
    }

    public MenuDialog setMargin(int margin) {
        return (MenuDialog)((Object)super.setMargin(margin));
    }

    public MenuDialog setGravity(int gravity) {
        return (MenuDialog)((Object)super.setGravity(gravity));
    }

    public MenuDialog setAnimator(int animator) {
        return (MenuDialog)((Object)super.setAnimator(animator));
    }

    public MenuDialog setBackground(Drawable background) {
        return (MenuDialog)((Object)super.setBackground(background));
    }

    public MenuDialog setCenterWidth(int width) {
        return (MenuDialog)((Object)super.setCenterWidth(width));
    }

    public MenuDialog setPrimaryColor(int primaryColor) {
        return (MenuDialog)((Object)super.setPrimaryColor(primaryColor));
    }

    public MenuDialog setSecondaryColor(int secondaryColor) {
        return (MenuDialog)((Object)super.setSecondaryColor(secondaryColor));
    }

    public MenuDialog setTranslucent(boolean translucent) {
        return (MenuDialog)((Object)super.setTranslucent(translucent));
    }

    public MenuDialog setCancel(boolean cancel) {
        return (MenuDialog)((Object)super.setCancel(cancel));
    }

    public MenuDialog setTouchInOutSideCancel(boolean cancel) {
        return (MenuDialog)((Object)super.setTouchInOutSideCancel(cancel));
    }

    public MenuDialog setDivide(boolean divide) {
        return (MenuDialog)((Object)super.setDivide(divide));
    }

    public MenuDialog setRadiusCard(float radiusCard) {
        return (MenuDialog)((Object)super.setRadiusCard(radiusCard));
    }

    @Override
    protected void initView() {
        this.setTouchInOutSideCancel(true);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout layout2 = new LinearLayout((Context)this.mActivity);
        layout2.setOrientation(1);
        if (this.isShowCenter()) {
            int paddingVertical = OsHelper.dp2px(8.0f);
            layout2.setPadding(0, paddingVertical, 0, paddingVertical);
        }
        layout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        for (int i = 0; i < this.mItems.length; ++i) {
            layout2.addView(this.addItemView(this.mItems, i));
            if (!this.isDivide || i == this.mItems.length - 1) continue;
            layout2.addView(this.addDivideView());
        }
        this.mView = layout2;
    }

    protected View addItemView(String[] items, int position) {
        View view = this.createItemView();
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            textView.setText((CharSequence)items[position]);
            textView.setTextColor(this.mPrimaryTextColor);
            textView.setTag((Object)items[position]);
            textView.setOnClickListener((View.OnClickListener)this);
            int color2 = this.isDefaultBackground ? R.color.colorDivideDark : R.color.colorDivideLight;
            BackGHelper.radius(this.setPressedRadius(this.mItems, position)).ripple(17170443, color2).into((View)textView);
        }
        return view;
    }

    protected View createItemView() {
        int paddingHorizontal;
        int paddingVertical;
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        TextView textView = new TextView((Context)this.mActivity);
        if (this.isShowCenter()) {
            paddingVertical = OsHelper.dp2px(16.0f);
            paddingHorizontal = OsHelper.dp2px(32.0f);
        } else {
            textView.setGravity(17);
            paddingVertical = paddingHorizontal = OsHelper.dp2px(16.0f);
        }
        textView.setPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        return textView;
    }

    private float[] setPressedRadius(String[] items, int position) {
        if (this.isShowCenter()) {
            return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }
        if (position == 0 && items.length > 1) {
            return new float[]{this.mRadiusCard, this.mRadiusCard, 0.0f, 0.0f};
        }
        if (position == items.length - 1 && items.length > 1) {
            return new float[]{0.0f, 0.0f, this.mRadiusCard, this.mRadiusCard};
        }
        if (items.length == 1) {
            return new float[]{this.mRadiusCard, this.mRadiusCard, this.mRadiusCard, this.mRadiusCard};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    private View addDivideView() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, 1);
        View view = new View((Context)this.mActivity);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        int color2 = this.isDefaultBackground ? this.mPressedColor : 17170443;
        view.setBackgroundColor(this.getColor(color2));
        return view;
    }

    public void onClick(View v) {
        for (final String mItem : this.mItems) {
            if (v.getTag() != mItem) continue;
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MenuDialog.this.mOnItemClickListener.onItemClick(mItem);
                    MenuDialog.this.dismiss();
                }
            }, 150L);
            break;
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(Object var1);
    }
}

