/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.dialog;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.dzenm.helper.R;
import com.dzenm.helper.dialog.AbsDialogFragment;
import com.dzenm.helper.draw.BackGHelper;
import com.dzenm.helper.view.EditTextChangeHelper;

@SuppressLint(value={"ValidFragment"})
public class LoginDialog
extends AbsDialogFragment
implements View.OnClickListener {
    private static final int TYPE_LOGIN = 101;
    private static final int TYPE_REGISTER = 102;
    private static final int TYPE_LOGIN_BY_PASSWORD = 103;
    private static final int TYPE_LOGIN_BY_VERIFY = 104;
    private static final int DEFAULT_TIME = 60;
    private TextView tvLogin;
    private TextView tvRegister;
    private TextView tvCountdown;
    private EditText etUsername;
    private EditText etPassword;
    private EditText etVerifyCode;
    private LinearLayout llVerify;
    private int mTabType;
    private int mLoginType;
    private int mCountTime = 60;
    private OnClickListener onClickListener;
    private EditTextChangeHelper mEditTextChangeHelper;
    private CountDownTimer mDownTimer = new CountDownTimer(this.mCountTime * 1000, 1000L){

        public void onTick(long millisUntilFinished) {
            LoginDialog.this.tvCountdown.setText((CharSequence)(millisUntilFinished / 1000L + "\u79d2"));
        }

        public void onFinish() {
            if (LoginDialog.this.isAdded()) {
                LoginDialog.this.resetCountDown();
            }
        }
    };

    public LoginDialog setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
        return this;
    }

    public static LoginDialog newInstance(AppCompatActivity activity) {
        LoginDialog loginDialog = new LoginDialog(activity);
        return loginDialog;
    }

    public String getUsername() {
        return this.etUsername.getText().toString().trim();
    }

    public String getPassword() {
        return this.etPassword.getText().toString().trim();
    }

    public String getVerifyCode() {
        return this.etVerifyCode.getText().toString().trim();
    }

    public LoginDialog setLoginByPassword() {
        this.mLoginType = 103;
        return this;
    }

    public LoginDialog setLoginByVerifyCode() {
        this.mLoginType = 104;
        return this;
    }

    public LoginDialog setMargin(int margin) {
        return (LoginDialog)((Object)super.setMargin(margin));
    }

    public LoginDialog setGravity(int gravity) {
        return (LoginDialog)((Object)super.setGravity(gravity));
    }

    public LoginDialog setAnimator(int animator) {
        return (LoginDialog)((Object)super.setAnimator(animator));
    }

    public LoginDialog setBackground(Drawable background) {
        return (LoginDialog)((Object)super.setBackground(background));
    }

    public LoginDialog setCenterWidth(int width) {
        return (LoginDialog)((Object)super.setCenterWidth(width));
    }

    public LoginDialog setPrimaryColor(int primaryColor) {
        return (LoginDialog)((Object)super.setPrimaryColor(primaryColor));
    }

    public LoginDialog setSecondaryColor(int secondaryColor) {
        return (LoginDialog)((Object)super.setSecondaryColor(secondaryColor));
    }

    public LoginDialog setTranslucent(boolean translucent) {
        return (LoginDialog)((Object)super.setTranslucent(translucent));
    }

    public LoginDialog setCancel(boolean cancel) {
        return (LoginDialog)((Object)super.setCancel(cancel));
    }

    public LoginDialog setTouchInOutSideCancel(boolean cancel) {
        return (LoginDialog)((Object)super.setTouchInOutSideCancel(cancel));
    }

    public LoginDialog(AppCompatActivity activity) {
        super(activity);
        this.mEditTextChangeHelper = EditTextChangeHelper.newInstance();
    }

    @Override
    protected int layoutId() {
        return R.layout.dialog_login;
    }

    @Override
    protected void initView() {
        this.tvLogin = (TextView)this.findViewById(R.id.tv_login);
        this.tvRegister = (TextView)this.findViewById(R.id.tv_register);
        this.etUsername = (EditText)this.findViewById(R.id.et_username);
        this.etPassword = (EditText)this.findViewById(R.id.et_password);
        this.llVerify = (LinearLayout)this.findViewById(R.id.ll_verife);
        this.tvCountdown = (TextView)this.findViewById(R.id.tv_countdown);
        this.etVerifyCode = (EditText)this.findViewById(R.id.et_verife_code);
        TextView tvConfirm = (TextView)this.findViewById(R.id.tv_confirm);
        TextView tvCancel = (TextView)this.findViewById(R.id.tv_cancel);
        Object line_1 = this.findViewById(R.id.line_1);
        Object line_2 = this.findViewById(R.id.line_2);
        this.tvLogin.setOnClickListener((View.OnClickListener)this);
        this.tvRegister.setOnClickListener((View.OnClickListener)this);
        tvConfirm.setOnClickListener((View.OnClickListener)this);
        tvCancel.setOnClickListener((View.OnClickListener)this);
        this.tvCountdown.setOnClickListener((View.OnClickListener)this);
        BackGHelper.radiusBR(this.mRadiusCard).pressed(this.mPressedColor).into((View)tvConfirm);
        BackGHelper.radiusBL(this.mRadiusCard).pressed(this.mPressedColor).into((View)tvCancel);
        this.setClickChangeTabStyle(this.tvLogin, this.tvRegister, this.mRadiusCard, 0.0f);
        this.setEditTextStyle(this.tvCountdown, this.etUsername, this.etPassword, this.etVerifyCode, (View)line_1, (View)line_2);
        this.mEditTextChangeHelper.setEditText(this.etUsername, this.etPassword, this.etVerifyCode).verify(true);
    }

    private void setEditTextStyle(TextView tvCountdown, EditText etUsername, EditText etPassword, EditText etVerifyCode, View line_1, View line_2) {
        if (!this.isDivide) {
            etUsername.setBackgroundResource(R.drawable.bg_gray_border);
            etPassword.setBackgroundResource(R.drawable.bg_gray_border);
            etVerifyCode.setBackgroundResource(R.drawable.bg_gray_border);
            line_1.setBackgroundColor(this.getColor(R.color.colorDivideDark));
            line_2.setBackgroundColor(this.getColor(R.color.colorDivideDark));
        }
        BackGHelper.radiusTL(4.0f).radiusTR(4.0f).pressed(this.mPrimaryColor, this.mSecondaryColor).into((View)tvCountdown);
        tvCountdown.setTextColor(this.getColor(17170443));
    }

    @Override
    public void onStart() {
        super.onStart();
        this.setLoginType(false);
    }

    public void onClick(View view) {
        if (this.onClickListener != null) {
            if (view.getId() == R.id.tv_confirm) {
                if (this.isTabLogin()) {
                    if (this.isLoginType()) {
                        this.etVerifyCode.setText((CharSequence)"empty");
                    } else {
                        this.etPassword.setText((CharSequence)"empty");
                    }
                }
                if (this.mEditTextChangeHelper.verify(false)) {
                    if (this.isTabLogin()) {
                        this.onClickListener.onLoginClick(this);
                    } else {
                        this.onClickListener.onRegisterClick(this);
                    }
                }
            } else if (view.getId() == R.id.tv_cancel) {
                this.dismiss();
            } else if (view.getId() == R.id.tv_login) {
                this.setTagSelected(101);
            } else if (view.getId() == R.id.tv_register) {
                this.setTagSelected(102);
            } else if (view.getId() == R.id.tv_countdown) {
                BackGHelper.solid(this.mSecondaryColor).radiusTR(4.0f).radiusBR(4.0f).into((View)this.tvCountdown);
                this.tvCountdown.setEnabled(false);
                this.mDownTimer.start();
                this.onClickListener.onVerifyClick();
            }
        } else {
            throw new NullPointerException("onClickListener is null");
        }
    }

    private void setTagSelected(int type) {
        this.etUsername.requestFocus();
        if (this.mTabType == type) {
            return;
        }
        this.mTabType = type;
        if (this.isTabLogin()) {
            this.setClickChangeTabStyle(this.tvLogin, this.tvRegister, this.mRadiusCard, 0.0f);
            this.setLoginType(false);
        } else {
            this.setClickChangeTabStyle(this.tvRegister, this.tvLogin, 0.0f, this.mRadiusCard);
            this.setLoginType(true);
        }
        this.reset();
    }

    private void setClickChangeTabStyle(TextView selectView, TextView unSelectView, float leftRadius, float rightRadius) {
        BackGHelper.pressed(BackGHelper.solid(17170443).radiusTL(rightRadius).radiusTR(leftRadius).stroke(1.0f, this.mPrimaryColor).build(), BackGHelper.solid(this.mPressedColor).radiusTL(rightRadius).radiusTR(leftRadius).stroke(1.0f, this.mSecondaryColor).build()).into((View)unSelectView);
        unSelectView.setTextColor(this.getColor(this.mPrimaryColor));
        BackGHelper.radiusTL(leftRadius).radiusTR(rightRadius).pressed(this.mPrimaryColor, this.mSecondaryColor).into((View)selectView);
        selectView.setTextColor(this.getColor(17170443));
    }

    private void reset() {
        this.resetCountDown();
        this.etUsername.setText((CharSequence)"");
        this.etPassword.setText((CharSequence)"");
        this.etVerifyCode.setText((CharSequence)"");
        this.mEditTextChangeHelper.verify(true);
    }

    private void setLoginType(boolean visible) {
        if (this.isLoginType()) {
            this.llVerify.setVisibility(visible ? 0 : 8);
        } else {
            this.etPassword.setVisibility(visible ? 0 : 8);
        }
    }

    private void resetCountDown() {
        if (this.mDownTimer != null) {
            this.mDownTimer.cancel();
        }
        this.tvCountdown.setText((CharSequence)this.getString(R.string.dialog_reset_countdown));
        this.tvCountdown.setEnabled(true);
        BackGHelper.radiusTL(4.0f).radiusTR(4.0f).pressed(this.mPrimaryColor, this.mSecondaryColor).into((View)this.tvCountdown);
    }

    private boolean isTabLogin() {
        return this.mTabType == 101;
    }

    private boolean isLoginType() {
        return this.mLoginType == 103;
    }

    public static interface OnClickListener {
        public void onLoginClick(LoginDialog var1);

        public void onRegisterClick(LoginDialog var1);

        public void onVerifyClick();
    }
}

