/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.date;

import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.widget.DatePicker;
import android.widget.TimePicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateHelper {
    public static final String YEAR = "yyyy";
    public static final String MONTH = "MM";
    public static final String DAY = "dd";
    public static final String HOUR = "HH";
    public static final String MINUTE = "mm";
    private static final String sSeparator = "-";
    private static final String DATE = "yyyy-MM-dd";
    private static final String TIME = "HH:mm";
    private static final String DATE_TIME = "yyyy-MM-dd HH:mm";

    public static String getCurrentTimeMillis() {
        return DateHelper.formatDate("yyyy-MM-dd HH:mm:ss.SSS", new Date());
    }

    public static String getCurrentDateTime() {
        return DateHelper.formatDate(DATE_TIME, new Date());
    }

    public static String getCurrentDate() {
        return DateHelper.formatDate(DATE, new Date());
    }

    public static String getCurrentTime() {
        return DateHelper.formatDate(TIME, new Date());
    }

    public static String timestampToDate(String timestamp) {
        return DateHelper.formatDate(DATE, Long.parseLong(timestamp));
    }

    public static String timestampToTime(String timestamp) {
        return DateHelper.formatDate(TIME, Long.parseLong(timestamp));
    }

    public static String timestampToDateTime(String timestamp) {
        return DateHelper.formatDate(DATE_TIME, Long.parseLong(timestamp));
    }

    public static String dateToWeek(String date) {
        String[] weeks = new String[]{"\u661f\u671f\u5929", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateHelper.parseDate(DATE, date));
        int position = calendar.get(7) - 1;
        return weeks[position];
    }

    public static long dateTimeToTimestamp(String datetime) {
        return DateHelper.parseDate(DATE_TIME, datetime).getTime();
    }

    public static long dateToTimestamp(String datetime) {
        return DateHelper.parseDate(DATE, datetime).getTime();
    }

    public static String[] getFirstAndLastOfWeek(String date) {
        String[] weeks = new String[2];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateHelper.parseDate(DATE, date));
        int day = calendar.get(7) == 1 ? -6 : 2 - calendar.get(7);
        calendar.add(7, day);
        weeks[0] = DateHelper.formatDate(DATE, calendar.getTime());
        calendar.add(7, 6);
        weeks[1] = DateHelper.formatDate(DATE, calendar.getTime());
        return weeks;
    }

    public static String nowDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + sSeparator + (calendar.get(2) + 1) + sSeparator + calendar.get(5);
    }

    public static String nowTime() {
        return Calendar.getInstance().get(11) + ":" + Calendar.getInstance().get(12);
    }

    public static void dateTimeDialog(final Context context, final OnDateDialogListener onDateDialogListener) {
        Calendar calendarDate = Calendar.getInstance();
        new DatePickerDialog(context, new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                String mMonth = monthOfYear < 10 ? "0" + (monthOfYear + 1) : String.valueOf(monthOfYear + 1);
                String mDay = dayOfMonth < 10 ? "0" + dayOfMonth : String.valueOf(dayOfMonth);
                onDateDialogListener.onDate(String.valueOf(year) + DateHelper.sSeparator + mMonth + "/" + mDay);
                Calendar calendarTime = Calendar.getInstance();
                new TimePickerDialog(context, new TimePickerDialog.OnTimeSetListener(){

                    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                        String mHour = hourOfDay < 10 ? "0" + hourOfDay : String.valueOf(hourOfDay);
                        String mMinute = minute < 10 ? "0" + minute : String.valueOf(minute);
                        onDateDialogListener.onTime(mHour + ":" + mMinute);
                    }
                }, calendarTime.get(11), calendarTime.get(12), true).show();
            }
        }, calendarDate.get(1), calendarDate.get(2), calendarDate.get(5)).show();
    }

    public static void currentDate(Context context, final OnDateDialogListener onDateDialogListener) {
        Calendar calendar = Calendar.getInstance();
        new DatePickerDialog(context, new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                String mMonth = monthOfYear < 9 ? "0" + (monthOfYear + 1) : String.valueOf(monthOfYear + 1);
                String mDay = dayOfMonth < 10 ? "0" + dayOfMonth : String.valueOf(dayOfMonth);
                onDateDialogListener.onDate(String.valueOf(year) + DateHelper.sSeparator + mMonth + DateHelper.sSeparator + mDay);
            }
        }, calendar.get(1), calendar.get(2), calendar.get(5)).show();
    }

    public static void currentTime(Context context, final OnDateDialogListener onDateDialogListener) {
        Calendar calendar = Calendar.getInstance();
        new DatePickerDialog(context, new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                String mMonth = monthOfYear < 10 ? "0" + (monthOfYear + 1) : String.valueOf(monthOfYear + 1);
                String mDay = dayOfMonth < 10 ? "0" + dayOfMonth : String.valueOf(dayOfMonth);
                onDateDialogListener.onDate(mDay + DateHelper.sSeparator + mMonth + "\u6708");
            }
        }, calendar.get(1), calendar.get(2), calendar.get(5)).show();
    }

    public static void timeDialog(Context context, final OnDateDialogListener onDateDialogListener) {
        Calendar calendar = Calendar.getInstance();
        new TimePickerDialog(context, new TimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                onDateDialogListener.onTime(Integer.toString(hourOfDay) + ":" + Integer.toString(minute));
            }
        }, calendar.get(11), calendar.get(12), true).show();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static Date parseDate(String pattern, String source) {
        Date date = null;
        try {
            date = new SimpleDateFormat(pattern).parse(source);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String formatDate(String pattern, Object date) {
        if (date instanceof Date) {
            return new SimpleDateFormat(pattern).format((Date)date);
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String formatUnit(int unit) {
        return unit < 10 ? "0" + unit : String.valueOf(unit);
    }

    public static String formatUnit(String unit) {
        int i = Integer.valueOf(unit);
        return i < 10 ? "0" + i : "" + unit;
    }

    public static String pattern(String separator) {
        return YEAR + separator + MONTH + separator + DAY;
    }

    public static interface OnDateSetListener {
        public void onDateTime(String var1, String var2);

        public void onDate(String var1);

        public void onTime(String var1);
    }

    public class OnDateDialogListener
    implements OnDateSetListener {
        @Override
        public void onDateTime(String date, String time) {
        }

        @Override
        public void onDate(String date) {
        }

        @Override
        public void onTime(String time) {
        }
    }
}

